/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.transformers;

import com.mirth.connect.donkey.model.DonkeyException;
import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.donkey.server.channel.components.PreProcessor;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.server.MirthJavascriptTransformerException;
import com.mirth.connect.server.MirthScopeProvider;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.transformers.JavaScriptInitializationException;
import com.mirth.connect.server.util.javascript.JavaScriptExecutorException;
import com.mirth.connect.server.util.javascript.JavaScriptTask;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import com.mirth.connect.util.ErrorMessageBuilder;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.tools.debugger.MirthMain;

public class JavaScriptPreprocessor
implements PreProcessor {
    private Logger logger = LogManager.getLogger(this.getClass());
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private Channel channel;
    private String scriptId;
    private volatile String contextFactoryId;
    private MirthScopeProvider scopeProvider = new MirthScopeProvider();
    private MirthMain debugger;
    private String preProcessingScript;
    private Boolean debug = false;

    public JavaScriptPreprocessor(Channel channel, String preProcessingScript, DebugOptions debugOptions) throws JavaScriptInitializationException {
        this.channel = channel;
        this.preProcessingScript = preProcessingScript;
        this.scriptId = ScriptController.getScriptId("Preprocessor", channel.getChannelId());
        this.debug = debugOptions != null && debugOptions.isDeployUndeployPreAndPostProcessorScripts();
        if (!this.debug.booleanValue()) {
            try {
                MirthContextFactory contextFactory = this.contextFactoryController.getContextFactory(channel.getResourceIds());
                this.contextFactoryId = contextFactory.getId();
                JavaScriptUtil.compileAndAddScript(channel.getChannelId(), contextFactory, this.scriptId, preProcessingScript, ContextType.CHANNEL_PREPROCESSOR);
            }
            catch (Exception e2) {
                MirthJavascriptTransformerException e2;
                this.logger.error("Error compiling preprocessor script " + this.scriptId + ".", (Throwable)e2);
                if (e2 instanceof RhinoException) {
                    e2 = new MirthJavascriptTransformerException((RhinoException)e2, channel.getChannelId(), null, 0, ErrorEventType.PREPROCESSOR_SCRIPT.toString(), null);
                }
                this.logger.error(ErrorMessageBuilder.buildErrorMessage(ErrorEventType.PREPROCESSOR_SCRIPT.toString(), null, e2));
                throw new JavaScriptInitializationException("Error initializing JavaScript Preprocessor", e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPreProcess(ConnectorMessage message) throws DonkeyException, InterruptedException {
        try {
            MirthContextFactory contextFactory;
            block13: {
                try {
                    HashMap<String, MirthContextFactory> contextFactories = new HashMap<String, MirthContextFactory>();
                    if (this.debug.booleanValue()) {
                        String preProcessingScriptId = ScriptController.getScriptId("Preprocessor", this.channel.getChannelId());
                        contextFactory = this.getContextFactory();
                        this.contextFactoryId = contextFactory.getId();
                        contextFactory.setContextType(ContextType.CHANNEL_PREPROCESSOR);
                        contextFactory.setScriptText(this.preProcessingScript);
                        contextFactory.setDebugType(true);
                        contextFactories.put(preProcessingScriptId, contextFactory);
                        if (JavaScriptUtil.getCompiledScript(this.scriptId) != null) {
                            this.debugger = JavaScriptUtil.getDebugger(contextFactory, this.scopeProvider, this.channel, this.scriptId, true);
                        }
                        break block13;
                    }
                    contextFactory = this.getContextFactory();
                    if (this.contextFactoryId.equals(contextFactory.getId())) break block13;
                    JavaScriptPreprocessor javaScriptPreprocessor = this;
                    synchronized (javaScriptPreprocessor) {
                        contextFactory = this.getContextFactory();
                        if (!this.contextFactoryId.equals(contextFactory.getId())) {
                            JavaScriptUtil.recompileGeneratedScript(contextFactory, this.scriptId);
                            this.contextFactoryId = contextFactory.getId();
                        }
                    }
                }
                catch (Exception e2) {
                    MirthJavascriptTransformerException e2;
                    this.logger.error("Error compiling preprocessor script " + this.scriptId + ".", (Throwable)e2);
                    if (e2 instanceof RhinoException) {
                        e2 = new MirthJavascriptTransformerException((RhinoException)e2, this.channel.getChannelId(), null, 0, ErrorEventType.POSTPROCESSOR_SCRIPT.toString(), null);
                    }
                    this.logger.error(ErrorMessageBuilder.buildErrorMessage(ErrorEventType.PREPROCESSOR_SCRIPT.toString(), null, e2));
                    throw new JavaScriptInitializationException("Error initializing JavaScript Preprocessor", e2);
                }
            }
            return JavaScriptUtil.executeJavaScriptPreProcessorTask(new JavaScriptPreProcessorTask(contextFactory, message), message.getChannelId());
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof JavaScriptExecutorException) {
                t = e.getCause();
            }
            this.eventController.dispatchEvent((Event)new ErrorEvent(message.getChannelId(), null, Long.valueOf(message.getMessageId()), ErrorEventType.PREPROCESSOR_SCRIPT, null, null, "Error running preprocessor scripts", t));
            throw new DonkeyException(t, ErrorMessageBuilder.buildErrorMessage(ErrorEventType.PREPROCESSOR_SCRIPT.toString(), "Error running preprocessor scripts", t));
        }
    }

    protected MirthContextFactory getContextFactory() throws Exception {
        if (this.debug.booleanValue()) {
            return this.contextFactoryController.getDebugContextFactory(this.channel.getResourceIds(), this.channel.getChannelId(), this.scriptId);
        }
        return this.contextFactoryController.getContextFactory(this.channel.getResourceIds());
    }

    private class JavaScriptPreProcessorTask
    extends JavaScriptTask<Object> {
        private ConnectorMessage message;
        private MirthScopeProvider scopeProvider;

        public JavaScriptPreProcessorTask(MirthContextFactory contextFactory, ConnectorMessage message) {
            super(contextFactory, "Preprocessor", JavaScriptPreprocessor.this.channel.getChannelId(), JavaScriptPreprocessor.this.channel.getName());
            this.message = message;
            this.scopeProvider = null;
        }

        public JavaScriptPreProcessorTask(MirthContextFactory contextFactory, ConnectorMessage message, MirthScopeProvider scopeProvider) {
            super(contextFactory, "Preprocessor", JavaScriptPreprocessor.this.channel.getChannelId(), JavaScriptPreprocessor.this.channel.getName());
            this.message = message;
            this.scopeProvider = scopeProvider;
        }

        @Override
        public Object doCall() throws Exception {
            if (JavaScriptPreprocessor.this.debug.booleanValue() && JavaScriptPreprocessor.this.debugger != null) {
                JavaScriptPreprocessor.this.debugger.doBreak();
                if (!JavaScriptPreprocessor.this.debugger.isVisible()) {
                    JavaScriptPreprocessor.this.debugger.setVisible(true);
                }
            }
            return JavaScriptUtil.executePreprocessorScripts(this, this.message, JavaScriptPreprocessor.this.channel.getSourceConnector().getDestinationIdMap(), this.scopeProvider);
        }
    }
}

