/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.userutil;

import com.mirth.connect.donkey.model.message.MessageSerializerException;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.donkey.server.controllers.UnsupportedDataTypeException;
import com.mirth.connect.server.attachments.MirthAttachmentHandlerProvider;
import com.mirth.connect.server.attachments.passthru.PassthruAttachmentHandlerProvider;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EngineController;
import com.mirth.connect.server.controllers.MessageController;
import com.mirth.connect.server.userutil.Attachment;
import com.mirth.connect.userutil.ImmutableConnectorMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AttachmentUtil {
    private static EngineController engineController = ControllerFactory.getFactory().createEngineController();

    private AttachmentUtil() {
    }

    public static byte[] reAttachMessage(String raw, ImmutableConnectorMessage connectorMessage, String charsetEncoding, boolean binary) {
        return AttachmentUtil.getAttachmentHandlerProvider(connectorMessage.getChannelId()).reAttachMessage(raw, connectorMessage, charsetEncoding, binary, true);
    }

    public static byte[] reAttachMessage(String raw, ImmutableConnectorMessage connectorMessage, String charsetEncoding, boolean binary, boolean reattach, boolean localOnly) {
        return AttachmentUtil.getAttachmentHandlerProvider(connectorMessage.getChannelId()).reAttachMessage(raw, connectorMessage, charsetEncoding, binary, reattach, localOnly);
    }

    public static String reAttachMessage(ImmutableConnectorMessage connectorMessage) {
        return AttachmentUtil.getAttachmentHandlerProvider(connectorMessage.getChannelId()).reAttachMessage(connectorMessage, true);
    }

    public static String reAttachMessage(String raw, ImmutableConnectorMessage connectorMessage) {
        return AttachmentUtil.getAttachmentHandlerProvider(connectorMessage.getChannelId()).reAttachMessage(raw, connectorMessage, true);
    }

    public static List<String> getMessageAttachmentIds(ImmutableConnectorMessage connectorMessage) throws MessageSerializerException {
        return AttachmentUtil.getAttachmentHandlerProvider(connectorMessage.getChannelId()).getMessageAttachmentIds(connectorMessage);
    }

    public static List<String> getMessageAttachmentIds(String channelId, Long messageId) throws MessageSerializerException {
        return AttachmentUtil.getAttachmentHandlerProvider(channelId).getMessageAttachmentIds(channelId, messageId);
    }

    public static List<Attachment> getMessageAttachments(ImmutableConnectorMessage connectorMessage) throws MessageSerializerException {
        return AttachmentUtil.convertFromDonkeyAttachmentList(AttachmentUtil.getAttachmentHandlerProvider(connectorMessage.getChannelId()).getMessageAttachments(connectorMessage));
    }

    public static List<Attachment> getMessageAttachments(ImmutableConnectorMessage connectorMessage, boolean base64Decode) throws MessageSerializerException {
        return AttachmentUtil.convertFromDonkeyAttachmentList(AttachmentUtil.getAttachmentHandlerProvider(connectorMessage.getChannelId()).getMessageAttachments(connectorMessage, base64Decode));
    }

    public static List<Attachment> getMessageAttachments(String channelId, Long messageId) throws MessageSerializerException {
        return AttachmentUtil.convertFromDonkeyAttachmentList(AttachmentUtil.getAttachmentHandlerProvider(channelId).getMessageAttachments(channelId, messageId));
    }

    public static List<Attachment> getMessageAttachments(String channelId, Long messageId, boolean base64Decode) throws MessageSerializerException {
        return AttachmentUtil.convertFromDonkeyAttachmentList(AttachmentUtil.getAttachmentHandlerProvider(channelId).getMessageAttachments(channelId, messageId, base64Decode));
    }

    public static Attachment getMessageAttachment(ImmutableConnectorMessage connectorMessage, String attachmentId) throws MessageSerializerException {
        return AttachmentUtil.getMessageAttachment(connectorMessage, attachmentId, false);
    }

    public static Attachment getMessageAttachment(ImmutableConnectorMessage connectorMessage, String attachmentId, boolean base64Decode) throws MessageSerializerException {
        return AttachmentUtil.getMessageAttachment(connectorMessage.getChannelId(), connectorMessage.getMessageId(), attachmentId, base64Decode);
    }

    public static Attachment getMessageAttachment(String channelId, Long messageId, String attachmentId) throws MessageSerializerException {
        Attachment attachment = AttachmentUtil.convertFromDonkeyAttachment(AttachmentUtil.getAttachmentHandlerProvider(channelId).getMessageAttachment(channelId, messageId, attachmentId));
        return StringUtils.equals((CharSequence)attachment.getId(), (CharSequence)attachmentId) ? attachment : null;
    }

    public static Attachment getMessageAttachment(String channelId, Long messageId, String attachmentId, boolean base64Decode) throws MessageSerializerException {
        Attachment attachment = AttachmentUtil.convertFromDonkeyAttachment(AttachmentUtil.getAttachmentHandlerProvider(channelId).getMessageAttachment(channelId, messageId, attachmentId, base64Decode));
        return StringUtils.equals((CharSequence)attachment.getId(), (CharSequence)attachmentId) ? attachment : null;
    }

    public static List<Attachment> getMessageAttachmentsFromSourceChannel(ImmutableConnectorMessage connectorMessage) throws MessageSerializerException {
        return AttachmentUtil.getMessageAttachmentsFromSourceChannel(connectorMessage, false);
    }

    public static List<Attachment> getMessageAttachmentsFromSourceChannel(ImmutableConnectorMessage connectorMessage, boolean base64Decode) throws MessageSerializerException {
        Map sourceMap = connectorMessage.getSourceMap();
        try {
            String sourceChannelId = (String)sourceMap.get("sourceChannelId");
            Long sourceMessageId = (Long)sourceMap.get("sourceMessageId");
            List sourceChannelIds = (List)sourceMap.get("sourceChannelIds");
            List sourceMessageIds = (List)sourceMap.get("sourceMessageIds");
            if (CollectionUtils.isNotEmpty((Collection)sourceChannelIds) && CollectionUtils.isNotEmpty((Collection)sourceMessageIds)) {
                sourceChannelId = (String)sourceChannelIds.get(0);
                sourceMessageId = (Long)sourceMessageIds.get(0);
            }
            if (sourceChannelId != null && sourceMessageId != null) {
                return AttachmentUtil.convertFromDonkeyAttachmentList(AttachmentUtil.getAttachmentHandlerProvider(sourceChannelId).getMessageAttachments(sourceChannelId, sourceMessageId, base64Decode));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList<Attachment>();
    }

    public static Attachment addAttachment(List<Attachment> attachments, Object content, String type) throws UnsupportedDataTypeException {
        return AttachmentUtil.addAttachment(attachments, content, type, false);
    }

    public static Attachment addAttachment(List<Attachment> attachments, Object content, String type, boolean base64Encode) throws UnsupportedDataTypeException {
        Attachment userAttachment = AttachmentUtil.convertFromDonkeyAttachment(com.mirth.connect.donkey.server.controllers.MessageController.getInstance().createAttachment(content, type, base64Encode));
        attachments.add(userAttachment);
        return userAttachment;
    }

    public static Attachment createAttachment(ImmutableConnectorMessage connectorMessage, Object content, String type) throws UnsupportedDataTypeException {
        return AttachmentUtil.createAttachment(connectorMessage, content, type, false);
    }

    public static Attachment createAttachment(ImmutableConnectorMessage connectorMessage, Object content, String type, boolean base64Encode) throws UnsupportedDataTypeException {
        com.mirth.connect.donkey.model.message.attachment.Attachment attachment = com.mirth.connect.donkey.server.controllers.MessageController.getInstance().createAttachment(content, type, base64Encode);
        com.mirth.connect.donkey.server.controllers.MessageController.getInstance().insertAttachment(attachment, connectorMessage.getChannelId(), Long.valueOf(connectorMessage.getMessageId()));
        return AttachmentUtil.convertFromDonkeyAttachment(attachment);
    }

    public static Attachment updateAttachment(ImmutableConnectorMessage connectorMessage, String attachmentId, Object content, String type) throws UnsupportedDataTypeException {
        return AttachmentUtil.updateAttachment(connectorMessage, attachmentId, content, type, false);
    }

    public static Attachment updateAttachment(ImmutableConnectorMessage connectorMessage, String attachmentId, Object content, String type, boolean base64Encode) throws UnsupportedDataTypeException {
        return AttachmentUtil.updateAttachment(connectorMessage.getChannelId(), connectorMessage.getMessageId(), attachmentId, content, type, base64Encode);
    }

    public static Attachment updateAttachment(ImmutableConnectorMessage connectorMessage, Attachment attachment) throws UnsupportedDataTypeException {
        return AttachmentUtil.updateAttachment(connectorMessage, attachment, false);
    }

    public static Attachment updateAttachment(ImmutableConnectorMessage connectorMessage, Attachment attachment, boolean base64Encode) throws UnsupportedDataTypeException {
        return AttachmentUtil.updateAttachment(connectorMessage.getChannelId(), connectorMessage.getMessageId(), attachment.getId(), attachment.getContent(), attachment.getType(), base64Encode);
    }

    public static Attachment updateAttachment(String channelId, Long messageId, Attachment attachment) throws UnsupportedDataTypeException {
        return AttachmentUtil.updateAttachment(channelId, messageId, attachment, false);
    }

    public static Attachment updateAttachment(String channelId, Long messageId, Attachment attachment, boolean base64Encode) throws UnsupportedDataTypeException {
        return AttachmentUtil.updateAttachment(channelId, messageId, attachment.getId(), attachment.getContent(), attachment.getType(), base64Encode);
    }

    public static Attachment updateAttachment(String channelId, Long messageId, String attachmentId, Object content, String type) throws UnsupportedDataTypeException {
        return AttachmentUtil.updateAttachment(channelId, messageId, attachmentId, content, type, false);
    }

    public static Attachment updateAttachment(String channelId, Long messageId, String attachmentId, Object content, String type, boolean base64Encode) throws UnsupportedDataTypeException {
        com.mirth.connect.donkey.model.message.attachment.Attachment attachment = com.mirth.connect.donkey.server.controllers.MessageController.getInstance().createAttachment(content, type, base64Encode);
        attachment.setId(attachmentId);
        com.mirth.connect.donkey.server.controllers.MessageController.getInstance().updateAttachment(attachment, channelId, messageId);
        return AttachmentUtil.convertFromDonkeyAttachment(attachment);
    }

    static List<Attachment> convertFromDonkeyAttachmentList(List<com.mirth.connect.donkey.model.message.attachment.Attachment> attachments) {
        ArrayList<Attachment> list = new ArrayList<Attachment>();
        for (com.mirth.connect.donkey.model.message.attachment.Attachment attachment : attachments) {
            list.add(AttachmentUtil.convertFromDonkeyAttachment(attachment));
        }
        return list;
    }

    static List<com.mirth.connect.donkey.model.message.attachment.Attachment> convertToDonkeyAttachmentList(List<Attachment> attachments) {
        ArrayList<com.mirth.connect.donkey.model.message.attachment.Attachment> list = new ArrayList<com.mirth.connect.donkey.model.message.attachment.Attachment>();
        for (Attachment attachment : attachments) {
            list.add(AttachmentUtil.convertToDonkeyAttachment(attachment));
        }
        return list;
    }

    static Attachment convertFromDonkeyAttachment(com.mirth.connect.donkey.model.message.attachment.Attachment attachment) {
        return new Attachment(attachment.getId(), attachment.getContent(), attachment.getType());
    }

    static com.mirth.connect.donkey.model.message.attachment.Attachment convertToDonkeyAttachment(Attachment attachment) {
        return new com.mirth.connect.donkey.model.message.attachment.Attachment(attachment.getId(), attachment.getContent(), attachment.getType());
    }

    private static MirthAttachmentHandlerProvider getAttachmentHandlerProvider(String channelId) {
        MirthAttachmentHandlerProvider provider;
        Channel deployedChannel = engineController.getDeployedChannel(channelId);
        if (deployedChannel != null && (provider = (MirthAttachmentHandlerProvider)deployedChannel.getAttachmentHandlerProvider()) != null) {
            return provider;
        }
        return new PassthruAttachmentHandlerProvider(MessageController.getInstance());
    }
}

