/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.userutil;

import com.mirth.connect.donkey.model.message.MessageSerializerException;
import com.mirth.connect.donkey.util.Base64Util;
import com.mirth.connect.model.converters.DICOMConverter;
import com.mirth.connect.server.userutil.Attachment;
import com.mirth.connect.server.userutil.AttachmentUtil;
import com.mirth.connect.server.util.DICOMMessageUtil;
import com.mirth.connect.userutil.ImmutableConnectorMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che2.data.DicomObject;

public class DICOMUtil {
    private DICOMUtil() {
    }

    public static String getDICOMRawData(ImmutableConnectorMessage connectorMessage) {
        return DICOMMessageUtil.getDICOMRawData(connectorMessage);
    }

    public static byte[] getDICOMRawBytes(ImmutableConnectorMessage connectorMessage) {
        return DICOMMessageUtil.getDICOMRawBytes(connectorMessage);
    }

    public static byte[] getDICOMMessage(ImmutableConnectorMessage connectorMessage) {
        return DICOMMessageUtil.getDICOMMessage(connectorMessage);
    }

    public static String mergeHeaderAttachments(ImmutableConnectorMessage connectorMessage, List<Attachment> attachments) throws MessageSerializerException, IOException {
        return new String(Base64Util.encodeBase64((byte[])DICOMMessageUtil.mergeHeaderAttachments(connectorMessage, AttachmentUtil.convertToDonkeyAttachmentList(attachments))));
    }

    public static String mergeHeaderPixelData(byte[] header, List<byte[]> images) throws IOException {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (byte[] image : images) {
            Attachment attachment = new Attachment();
            attachment.setContent(image);
            attachments.add(attachment);
        }
        return new String(Base64Util.encodeBase64((byte[])DICOMMessageUtil.mergeHeaderPixelData(header, AttachmentUtil.convertToDonkeyAttachmentList(attachments))));
    }

    public static int getSliceCount(ImmutableConnectorMessage connectorMessage) {
        return DICOMMessageUtil.getSliceCount(connectorMessage);
    }

    public static String convertDICOM(String imageType, ImmutableConnectorMessage connectorMessage, boolean autoThreshold) {
        return DICOMMessageUtil.convertDICOM(imageType, connectorMessage, 1, autoThreshold);
    }

    public static String convertDICOM(String imageType, ImmutableConnectorMessage connectorMessage) {
        return DICOMMessageUtil.convertDICOM(imageType, connectorMessage, 1, false);
    }

    public static String convertDICOM(String imageType, ImmutableConnectorMessage connectorMessage, int sliceIndex) {
        return DICOMMessageUtil.convertDICOM(imageType, connectorMessage, sliceIndex, false);
    }

    public static String convertDICOM(String imageType, ImmutableConnectorMessage connectorMessage, int sliceIndex, boolean autoThreshold) {
        return DICOMMessageUtil.convertDICOM(imageType, connectorMessage, sliceIndex, autoThreshold);
    }

    public static byte[] convertDICOMToByteArray(String imageType, ImmutableConnectorMessage connectorMessage) {
        return DICOMMessageUtil.convertDICOMToByteArray(imageType, connectorMessage, 1, false);
    }

    public static byte[] convertDICOMToByteArray(String imageType, ImmutableConnectorMessage connectorMessage, int sliceIndex) {
        return DICOMMessageUtil.convertDICOMToByteArray(imageType, connectorMessage, sliceIndex, false);
    }

    public static byte[] convertDICOMToByteArray(String imageType, ImmutableConnectorMessage connectorMessage, int sliceIndex, boolean autoThreshold) {
        return DICOMMessageUtil.convertDICOMToByteArray(imageType, connectorMessage, sliceIndex, autoThreshold);
    }

    public static DicomObject byteArrayToDicomObject(byte[] bytes, boolean decodeBase64) throws IOException {
        return DICOMConverter.byteArrayToDicomObject(bytes, decodeBase64);
    }

    public static byte[] dicomObjectToByteArray(DicomObject dicomObject) throws IOException {
        return DICOMConverter.dicomObjectToByteArray(dicomObject);
    }
}

