/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.userutil;

import com.mirth.connect.server.userutil.MirthCachedRowSet;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import javax.sql.rowset.CachedRowSet;
import org.apache.commons.dbutils.DbUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseConnection {
    private Logger logger = LogManager.getLogger(this.getClass());
    private Connection connection;
    private String address;

    public DatabaseConnection(String address) throws SQLException {
        this.logger.debug("creating new database connection: address=" + address);
        this.address = address;
        this.connection = DriverManager.getConnection(address);
    }

    public DatabaseConnection(String address, Properties info) throws SQLException {
        this.logger.debug("creating new database connection: address=" + address);
        this.address = address;
        this.connection = DriverManager.getConnection(address, info);
    }

    public DatabaseConnection(Driver driver, String address) throws SQLException {
        this.logger.debug("creating new database connection: address=" + address);
        this.address = address;
        this.connection = driver.connect(address, new Properties());
    }

    public DatabaseConnection(Driver driver, String address, Properties info) throws SQLException {
        this.logger.debug("creating new database connection: address=" + address);
        this.address = address;
        this.connection = driver.connect(address, info);
    }

    public String getAddress() {
        return this.address;
    }

    public CachedRowSet executeCachedQuery(String expression) throws SQLException {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            this.logger.debug("executing query:\n" + expression);
            ResultSet result = statement.executeQuery(expression);
            MirthCachedRowSet crs = new MirthCachedRowSet();
            crs.populate(result);
            DbUtils.closeQuietly((ResultSet)result);
            MirthCachedRowSet mirthCachedRowSet = crs;
            return mirthCachedRowSet;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            DbUtils.closeQuietly((Statement)statement);
        }
    }

    public int executeUpdate(String expression) throws SQLException {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            this.logger.debug("executing update:\n" + expression);
            if (statement.execute(expression)) {
                int n = -1;
                return n;
            }
            int n = statement.getUpdateCount();
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            DbUtils.closeQuietly((Statement)statement);
        }
    }

    public int executeUpdate(String expression, List<Object> parameters) throws SQLException {
        int n;
        PreparedStatement statement;
        block6: {
            statement = null;
            statement = this.connection.prepareStatement(expression);
            this.logger.debug("executing prepared statement:\n" + expression);
            ListIterator<Object> iterator = parameters.listIterator();
            while (iterator.hasNext()) {
                int index = iterator.nextIndex() + 1;
                Object value = iterator.next();
                this.logger.debug("adding parameter: index=" + index + ", value=" + String.valueOf(value));
                statement.setObject(index, value);
            }
            if (!statement.execute()) break block6;
            n = -1;
            DbUtils.closeQuietly((Statement)statement);
            return n;
        }
        try {
            n = statement.getUpdateCount();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)statement);
        return n;
    }

    public CachedRowSet executeCachedQuery(String expression, List<Object> parameters) throws SQLException {
        MirthCachedRowSet mirthCachedRowSet;
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(expression);
            this.logger.debug("executing prepared statement:\n" + expression);
            ListIterator<Object> iterator = parameters.listIterator();
            while (iterator.hasNext()) {
                int index = iterator.nextIndex() + 1;
                Object value = iterator.next();
                this.logger.debug("adding parameter: index=" + index + ", value=" + String.valueOf(value));
                statement.setObject(index, value);
            }
            ResultSet result = statement.executeQuery();
            MirthCachedRowSet crs = new MirthCachedRowSet();
            crs.populate(result);
            DbUtils.closeQuietly((ResultSet)result);
            mirthCachedRowSet = crs;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)statement);
        return mirthCachedRowSet;
    }

    public void close() {
        try {
            DbUtils.close((Connection)this.connection);
        }
        catch (SQLException e) {
            this.logger.warn((Object)e);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public CachedRowSet executeUpdateAndGetGeneratedKeys(String expression) throws SQLException {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            this.logger.debug("executing update:\n" + expression);
            statement.executeUpdate(expression, 1);
            MirthCachedRowSet crs = new MirthCachedRowSet();
            crs.populate(statement.getGeneratedKeys());
            MirthCachedRowSet mirthCachedRowSet = crs;
            return mirthCachedRowSet;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            DbUtils.closeQuietly((Statement)statement);
        }
    }

    public CachedRowSet executeUpdateAndGetGeneratedKeys(String expression, List<Object> parameters) throws SQLException {
        MirthCachedRowSet mirthCachedRowSet;
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(expression, 1);
            this.logger.debug("executing prepared statement:\n" + expression);
            ListIterator<Object> iterator = parameters.listIterator();
            while (iterator.hasNext()) {
                int index = iterator.nextIndex() + 1;
                Object value = iterator.next();
                this.logger.debug("adding parameter: index=" + index + ", value=" + String.valueOf(value));
                statement.setObject(index, value);
            }
            statement.executeUpdate();
            MirthCachedRowSet crs = new MirthCachedRowSet();
            crs.populate(statement.getGeneratedKeys());
            mirthCachedRowSet = crs;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)statement);
        return mirthCachedRowSet;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

