/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.userutil;

import com.mirth.connect.connectors.jdbc.CustomDriver;
import com.mirth.connect.server.userutil.DatabaseConnection;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseConnectionFactory {
    private MirthContextFactory contextFactory;
    private Map<String, CustomDriverInfo> customDriverInfoMap;
    private Logger logger = LogManager.getLogger(this.getClass());

    public DatabaseConnectionFactory(MirthContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public DatabaseConnection createDatabaseConnection(String driver, String address, String username, String password) throws SQLException {
        CustomDriverInfo customDriverInfo = this.getCustomDriverInfo(driver);
        Properties info = new Properties();
        info.setProperty("user", username);
        info.setProperty("password", password);
        if (customDriverInfo != null && customDriverInfo.customDriver != null) {
            return new DatabaseConnection((Driver)customDriverInfo.customDriver, address, info);
        }
        return new DatabaseConnection(address, info);
    }

    public DatabaseConnection createDatabaseConnection(String driver, String address) throws SQLException {
        CustomDriverInfo customDriverInfo = this.getCustomDriverInfo(driver);
        if (customDriverInfo != null && customDriverInfo.customDriver != null) {
            return new DatabaseConnection((Driver)customDriverInfo.customDriver, address);
        }
        return new DatabaseConnection(address);
    }

    public Connection createConnection(String driver, String address, String username, String password) throws SQLException {
        CustomDriverInfo customDriverInfo = this.getCustomDriverInfo(driver);
        Properties info = new Properties();
        info.setProperty("user", username);
        info.setProperty("password", password);
        if (customDriverInfo != null && customDriverInfo.customDriver != null) {
            return customDriverInfo.customDriver.connect(address, info);
        }
        return DriverManager.getConnection(address, info);
    }

    public void initializeDriver(String driver) throws Exception {
        this.initializeDriverAndGetInfo(driver);
    }

    private CustomDriverInfo initializeDriverAndGetInfo(String driver) throws Exception {
        CustomDriverInfo customDriverInfo;
        if (this.customDriverInfoMap == null) {
            this.customDriverInfoMap = new HashMap<String, CustomDriverInfo>();
        }
        if ((customDriverInfo = this.customDriverInfoMap.get(driver)) == null) {
            customDriverInfo = new CustomDriverInfo();
            this.customDriverInfoMap.put(driver, customDriverInfo);
        }
        if (!customDriverInfo.customDriverAttempted) {
            try {
                ClassLoader isolatedClassLoader = this.contextFactory.getIsolatedClassLoader();
                if (isolatedClassLoader != null) {
                    customDriverInfo.customDriver = new CustomDriver(isolatedClassLoader, driver);
                    this.logger.debug("Custom driver created: " + customDriverInfo.customDriver.toString() + ", Version " + customDriverInfo.customDriver.getMajorVersion() + "." + customDriverInfo.customDriver.getMinorVersion());
                } else {
                    this.logger.debug("Custom classloader is not being used, defaulting to DriverManager.");
                }
            }
            catch (Exception e) {
                this.logger.debug("Error creating custom driver, defaulting to DriverManager.", (Throwable)e);
            }
            customDriverInfo.customDriverAttempted = true;
        }
        if (customDriverInfo.customDriver == null) {
            Class.forName(driver, true, Thread.currentThread().getContextClassLoader());
        }
        return customDriverInfo;
    }

    private CustomDriverInfo getCustomDriverInfo(String driver) {
        try {
            return this.initializeDriverAndGetInfo(driver);
        }
        catch (Exception e) {
            this.logger.error("Error initializing DatabaseConnectionFactory driver: " + driver, (Throwable)e);
            return null;
        }
    }

    private class CustomDriverInfo {
        public boolean customDriverAttempted;
        public CustomDriver customDriver;

        private CustomDriverInfo() {
        }
    }
}

