/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.userutil;

import com.mirth.connect.userutil.ImmutableConnectorMessage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.Context;

public class DestinationSet {
    private Map<String, Integer> destinationIdMap;
    private Set<Integer> metaDataIds;

    public DestinationSet(ImmutableConnectorMessage connectorMessage) {
        try {
            if (connectorMessage.getSourceMap().containsKey("destinationSet")) {
                this.destinationIdMap = connectorMessage.getDestinationIdMap();
                this.metaDataIds = (Set)connectorMessage.getSourceMap().get("destinationSet");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean remove(Object metaDataIdOrConnectorName) {
        Integer metaDataId;
        if (this.metaDataIds != null && (metaDataId = this.convertToMetaDataId(metaDataIdOrConnectorName)) != null) {
            return this.metaDataIds.remove(metaDataId);
        }
        return false;
    }

    public boolean remove(Collection<Object> metaDataIdOrConnectorNames) {
        boolean removed = false;
        for (Object metaDataIdOrConnectorName : metaDataIdOrConnectorNames) {
            if (!this.remove(metaDataIdOrConnectorName)) continue;
            removed = true;
        }
        return removed;
    }

    public boolean removeAllExcept(Object metaDataIdOrConnectorName) {
        if (this.metaDataIds != null) {
            Integer metaDataId = this.convertToMetaDataId(metaDataIdOrConnectorName);
            Set<Object> set = metaDataId != null ? Collections.singleton(metaDataId) : Collections.emptySet();
            return this.metaDataIds.retainAll(set);
        }
        return false;
    }

    public boolean removeAllExcept(Collection<Object> metaDataIdOrConnectorNames) {
        if (this.metaDataIds != null) {
            HashSet<Integer> set = new HashSet<Integer>();
            for (Object metaDataIdOrConnectorName : metaDataIdOrConnectorNames) {
                Integer metaDataId = this.convertToMetaDataId(metaDataIdOrConnectorName);
                if (metaDataId == null) continue;
                set.add(metaDataId);
            }
            return this.metaDataIds.retainAll(set);
        }
        return false;
    }

    public boolean removeAll() {
        if (this.metaDataIds != null && this.metaDataIds.size() > 0) {
            this.metaDataIds.clear();
            return true;
        }
        return false;
    }

    private Integer convertToMetaDataId(Object metaDataIdOrConnectorName) {
        if (metaDataIdOrConnectorName != null) {
            if (metaDataIdOrConnectorName instanceof Number) {
                return ((Number)metaDataIdOrConnectorName).intValue();
            }
            if (metaDataIdOrConnectorName.getClass().getName().equals("org.mozilla.javascript.NativeNumber")) {
                return (Integer)Context.jsToJava((Object)metaDataIdOrConnectorName, Integer.TYPE);
            }
            if (this.destinationIdMap != null) {
                return this.destinationIdMap.get(metaDataIdOrConnectorName.toString());
            }
        }
        return null;
    }
}

