/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.userutil;

import com.mirth.commons.encryption.EncryptionException;
import com.mirth.commons.encryption.Encryptor;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.userutil.EncryptedData;

public class EncryptionUtil {
    public static String encrypt(String data) throws EncryptionException {
        return EncryptionUtil.getEncryptor().encrypt(data);
    }

    public static EncryptedData encrypt(byte[] data) throws EncryptionException {
        Encryptor.EncryptedData result = EncryptionUtil.getEncryptor().encrypt(data);
        return new EncryptedData(result.getHeader(), result.getEncryptedData());
    }

    public static String decrypt(String data) throws EncryptionException {
        return EncryptionUtil.getEncryptor().decrypt(data);
    }

    public static byte[] decrypt(String header, byte[] data) throws EncryptionException {
        return EncryptionUtil.getEncryptor().decrypt(header, data);
    }

    private static Encryptor getEncryptor() {
        return ControllerFactory.getFactory().createConfigurationController().getEncryptor();
    }
}

