/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.userutil;

import com.mirth.connect.connectors.http.HttpMessageConverter;
import com.mirth.connect.donkey.util.DonkeyElement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.ContentType;

public class HTTPUtil {
    private HTTPUtil() {
    }

    public static Map<String, String> parseHeaders(String str) throws Exception {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        Header[] headers = HttpParser.parseHeaders((InputStream)new ByteArrayInputStream(str.getBytes()), (String)"UTF-8");
        for (int i = 0; i < headers.length; ++i) {
            headersMap.put(headers[i].getName(), headers[i].getValue());
        }
        return headersMap;
    }

    public static String httpBodyToXml(InputStream httpBody, String contentType) throws MessagingException, IOException, DonkeyElement.DonkeyElementException, ParserConfigurationException {
        ContentType type = HTTPUtil.getContentType(contentType);
        String content = type.getMimeType().startsWith("multipart/") ? new MimeMultipart((DataSource)new ByteArrayDataSource(httpBody, type.toString())) : IOUtils.toString((InputStream)httpBody, (String)HttpMessageConverter.getDefaultHttpCharset((String)type.getCharset().name()));
        return HttpMessageConverter.contentToXml((Object)content, (ContentType)type, (boolean)true, null);
    }

    public static String httpBodyToXml(String httpBody, String contentType) throws MessagingException, IOException, DonkeyElement.DonkeyElementException, ParserConfigurationException {
        ContentType type = HTTPUtil.getContentType(contentType);
        String content = type.getMimeType().startsWith("multipart/") ? new MimeMultipart((DataSource)new ByteArrayDataSource(httpBody, type.toString())) : httpBody;
        return HttpMessageConverter.contentToXml((Object)content, (ContentType)type, (boolean)true, null);
    }

    private static ContentType getContentType(String contentType) {
        try {
            return ContentType.parse((String)contentType);
        }
        catch (RuntimeException e) {
            return ContentType.TEXT_PLAIN;
        }
    }
}

