/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.userutil;

import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;

public class HashUtil {
    private static final String DEFAULT_ALGORITHM = "SHA-256";

    private HashUtil() {
    }

    public static String generate(Object data) throws Exception {
        if (data instanceof byte[]) {
            return HashUtil.generate((byte[])data, DEFAULT_ALGORITHM);
        }
        return HashUtil.generate(String.valueOf(data).getBytes(), DEFAULT_ALGORITHM);
    }

    public static String generate(String str, String encoding, String algorithm) throws Exception {
        return HashUtil.generate(str.getBytes(encoding), algorithm);
    }

    public static String generate(byte[] bytes, String algorithm) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        messageDigest.update(bytes);
        byte[] hash = messageDigest.digest();
        return Hex.encodeHexString((byte[])hash);
    }
}

