/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.userutil;

import com.mirth.connect.model.converters.IMessageSerializer;
import com.mirth.connect.model.datatype.SerializerProperties;
import com.mirth.connect.plugins.DataTypeServerPlugin;
import com.mirth.connect.server.controllers.ControllerFactory;
import java.util.Map;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SerializerFactory {
    private static Logger logger = LogManager.getLogger(SerializerFactory.class);
    private static Map<String, DataTypeServerPlugin> dataPlugins = new CaseInsensitiveMap(ControllerFactory.getFactory().createExtensionController().getDataTypePlugins());

    private SerializerFactory() {
    }

    public static IMessageSerializer getSerializer(String dataType) {
        return SerializerFactory.getSerializer(dataType, null, null);
    }

    public static IMessageSerializer getSerializer(String dataType, Map<String, Object> serializationPropertiesMap, Map<String, Object> deserializationPropertiesMap) {
        DataTypeServerPlugin plugin = dataPlugins.get(dataType);
        if (plugin != null) {
            SerializerProperties properties;
            if (serializationPropertiesMap == null) {
                serializationPropertiesMap = SerializerFactory.getDefaultSerializationProperties(dataType);
            }
            if (deserializationPropertiesMap == null) {
                deserializationPropertiesMap = SerializerFactory.getDefaultDeserializationProperties(dataType);
            }
            if ((properties = plugin.getDefaultProperties().getSerializerProperties()).getSerializationProperties() != null) {
                properties.getSerializationProperties().setProperties(serializationPropertiesMap);
            }
            if (properties.getDeserializationProperties() != null) {
                properties.getDeserializationProperties().setProperties(deserializationPropertiesMap);
            }
            return plugin.getSerializer(properties);
        }
        return null;
    }

    public static Map<String, Object> getDefaultSerializationProperties(String dataType) {
        DataTypeServerPlugin plugin = dataPlugins.get(dataType);
        if (plugin != null && plugin.getDefaultProperties().getSerializationProperties() != null) {
            return plugin.getDefaultProperties().getSerializationProperties().getProperties();
        }
        return null;
    }

    public static Map<String, Object> getDefaultDeserializationProperties(String dataType) {
        DataTypeServerPlugin plugin = dataPlugins.get(dataType);
        if (plugin != null && plugin.getDefaultProperties().getDeserializationProperties() != null) {
            return plugin.getDefaultProperties().getDeserializationProperties().getProperties();
        }
        return null;
    }

    @Deprecated
    private static IMessageSerializer getHL7SerializerQuietly(boolean useStrictParser, boolean useStrictValidation, boolean handleRepetitions, boolean convertLFtoCR, boolean handleSubcomponents) {
        String dataType = "HL7V2";
        Map<String, Object> serializationPropertiesMap = SerializerFactory.getDefaultSerializationProperties(dataType);
        serializationPropertiesMap.put("handleRepetitions", handleRepetitions);
        serializationPropertiesMap.put("handleSubcomponents", handleSubcomponents);
        serializationPropertiesMap.put("useStrictParser", useStrictParser);
        serializationPropertiesMap.put("useStrictValidation", useStrictValidation);
        serializationPropertiesMap.put("segmentDelimiter", "\\r");
        serializationPropertiesMap.put("convertLineBreaks", convertLFtoCR);
        serializationPropertiesMap.put("stripNamespaces", false);
        Map<String, Object> deserializationPropertiesMap = SerializerFactory.getDefaultDeserializationProperties(dataType);
        deserializationPropertiesMap.put("useStrictParser", useStrictParser);
        deserializationPropertiesMap.put("useStrictValidation", useStrictValidation);
        return SerializerFactory.getSerializer(dataType, serializationPropertiesMap, deserializationPropertiesMap);
    }

    @Deprecated
    public static IMessageSerializer getHL7Serializer(boolean useStrictParser, boolean useStrictValidation, boolean handleRepetitions, boolean convertLFtoCR, boolean handleSubcomponents) {
        logger.error("The getHL7Serializer(useStrictParser, useStrictValidation, handleRepetitions, convertLFtoCR, handleSubcomponents) method is deprecated and will soon be removed. Please use the \"Convert HL7 v2.x\" templates from the References tab instead. Look at the tooltips to see the available property keys. The new method will strip namespaces by default unless the 'stripNamespaces' property is set to false.");
        return SerializerFactory.getHL7SerializerQuietly(useStrictParser, useStrictValidation, handleRepetitions, convertLFtoCR, handleSubcomponents);
    }

    @Deprecated
    public static IMessageSerializer getHL7Serializer(boolean useStrictParser, boolean useStrictValidation, boolean handleRepetitions, boolean convertLFtoCR) {
        logger.error("The getHL7Serializer(useStrictParser, useStrictValidation, handleRepetitions, convertLFtoCR) method is deprecated and will soon be removed. Please use the \"Convert HL7 v2.x\" templates from the References tab instead. Look at the tooltips to see the available property keys. The new method will strip namespaces by default unless the 'stripNamespaces' property is set to false.");
        return SerializerFactory.getHL7SerializerQuietly(useStrictParser, useStrictValidation, handleRepetitions, convertLFtoCR, false);
    }

    @Deprecated
    public static IMessageSerializer getHL7Serializer(boolean useStrictParser, boolean useStrictValidation, boolean handleRepetitions) {
        logger.error("The getHL7Serializer(useStrictParser, useStrictValidation, handleRepetitions) method is deprecated and will soon be removed. Please use the \"Convert HL7 v2.x\" templates from the References tab instead. Look at the tooltips to see the available property keys. The new method will strip namespaces by default unless the 'stripNamespaces' property is set to false.");
        return SerializerFactory.getHL7SerializerQuietly(useStrictParser, useStrictValidation, handleRepetitions, true, false);
    }

    @Deprecated
    public static IMessageSerializer getHL7Serializer(boolean useStrictParser, boolean useStrictValidation) {
        logger.error("The getHL7Serializer(useStrictParser, useStrictValidation) method is deprecated and will soon be removed. Please use the \"Convert HL7 v2.x\" templates from the References tab instead. Look at the tooltips to see the available property keys. The new method will strip namespaces by default unless the 'stripNamespaces' property is set to false.");
        return SerializerFactory.getHL7SerializerQuietly(useStrictParser, useStrictValidation, false, true, false);
    }

    @Deprecated
    public static IMessageSerializer getHL7Serializer() {
        logger.error("The getHL7Serializer() method is deprecated and will soon be removed. Please use the \"Convert HL7 v2.x\" templates from the References tab instead. Look at the tooltips to see the available property keys. The new method will strip namespaces by default unless the 'stripNamespaces' property is set to false.");
        return SerializerFactory.getHL7SerializerQuietly(false, false, false, true, false);
    }

    @Deprecated
    public static IMessageSerializer getX12Serializer(boolean inferDelimiters) {
        logger.error("The getX12Serializer(inferDelimiters) method is deprecated and will soon be removed. Please use the \"Convert EDI / X12\" templates from the References tab instead. Look at the tooltips to see the available property keys.");
        String dataType = "EDI/X12";
        Map<String, Object> serializationPropertiesMap = SerializerFactory.getDefaultSerializationProperties(dataType);
        serializationPropertiesMap.put("inferX12Delimiters", inferDelimiters);
        return SerializerFactory.getSerializer(dataType, serializationPropertiesMap, null);
    }

    @Deprecated
    public static IMessageSerializer getEDISerializer(String segmentDelim, String elementDelim, String subelementDelim) {
        logger.error("The getEDISerializer(segmentDelim, elementDelim, subelementDelim) method is deprecated and will soon be removed. Please use the \"Convert EDI / X12\" templates from the References tab instead. Look at the tooltips to see the available property keys.");
        String dataType = "EDI/X12";
        Map<String, Object> serializationPropertiesMap = SerializerFactory.getDefaultSerializationProperties(dataType);
        serializationPropertiesMap.put("segmentDelimiter", segmentDelim);
        serializationPropertiesMap.put("elementDelimiter", elementDelim);
        serializationPropertiesMap.put("subelementDelimiter", subelementDelim);
        serializationPropertiesMap.put("inferX12Delimiters", false);
        return SerializerFactory.getSerializer(dataType, serializationPropertiesMap, null);
    }

    @Deprecated
    private static IMessageSerializer getNCPDPSerializerQuietly(String segmentDelim, String groupDelim, String fieldDelim, boolean useStrictValidation) {
        String dataType = "NCPDP";
        Map<String, Object> serializationPropertiesMap = SerializerFactory.getDefaultSerializationProperties(dataType);
        serializationPropertiesMap.put("segmentDelimiter", segmentDelim);
        serializationPropertiesMap.put("groupDelimiter", groupDelim);
        serializationPropertiesMap.put("fieldDelimiter", fieldDelim);
        Map<String, Object> deserializationPropertiesMap = SerializerFactory.getDefaultDeserializationProperties(dataType);
        deserializationPropertiesMap.put("segmentDelimiter", segmentDelim);
        deserializationPropertiesMap.put("groupDelimiter", groupDelim);
        deserializationPropertiesMap.put("fieldDelimiter", fieldDelim);
        deserializationPropertiesMap.put("useStrictValidation", useStrictValidation);
        return SerializerFactory.getSerializer(dataType, serializationPropertiesMap, deserializationPropertiesMap);
    }

    @Deprecated
    public static IMessageSerializer getNCPDPSerializer(String segmentDelim, String groupDelim, String fieldDelim, boolean useStrictValidation) {
        logger.error("The getNCPDPSerializer(segmentDelim, groupDelim, fieldDelim, useStrictValidation) method is deprecated and will soon be removed. Please use the \"Convert NCPDP\" templates from the References tab instead. Look at the tooltips to see the available property keys.");
        return SerializerFactory.getNCPDPSerializerQuietly(segmentDelim, groupDelim, fieldDelim, useStrictValidation);
    }

    @Deprecated
    public static IMessageSerializer getNCPDPSerializer(String segmentDelim, String groupDelim, String fieldDelim) {
        logger.error("The getNCPDPSerializer(segmentDelim, groupDelim, fieldDelim) method is deprecated and will soon be removed. Please use the \"Convert NCPDP\" templates from the References tab instead. Look at the tooltips to see the available property keys.");
        return SerializerFactory.getNCPDPSerializerQuietly(segmentDelim, groupDelim, fieldDelim, false);
    }
}

