/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.Script;

public class CompiledScriptCache {
    private Logger logger = LogManager.getLogger(this.getClass());
    private Map<String, Script> compiledScripts = new ConcurrentHashMap<String, Script>();
    private Map<String, String> sourceScripts = new ConcurrentHashMap<String, String>();
    private static CompiledScriptCache instance = null;

    private CompiledScriptCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompiledScriptCache getInstance() {
        Class<CompiledScriptCache> clazz = CompiledScriptCache.class;
        synchronized (CompiledScriptCache.class) {
            if (instance == null) {
                instance = new CompiledScriptCache();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Script getCompiledScript(String id) {
        return this.compiledScripts.get(id);
    }

    public String getSourceScript(String id) {
        return this.sourceScripts.get(id);
    }

    public void putCompiledScript(String id, Script compiledScript, String sourceScript) {
        this.logger.debug("adding script to cache");
        this.compiledScripts.put(id, compiledScript);
        this.sourceScripts.put(id, sourceScript);
    }

    public void removeCompiledScript(String id) {
        this.logger.debug("removing script from cache");
        this.compiledScripts.remove(id);
        this.sourceScripts.remove(id);
    }
}

