/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import com.mirth.connect.server.util.SyncObject;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class GlobalChannelVariableStore {
    public Map<String, Object> globalChannelVariableMap = new ConcurrentHashMap<String, Object>();
    public Map<String, SyncObject> globalChannelVariableSyncMap = new ConcurrentHashMap<String, SyncObject>();

    public boolean containsKey(String key) {
        return this.globalChannelVariableMap.containsKey(key);
    }

    public synchronized void remove(String key) {
        this.globalChannelVariableMap.remove(key);
    }

    public Object get(String key) {
        return this.globalChannelVariableMap.get(key);
    }

    public synchronized void put(String key, Object value) {
        this.globalChannelVariableMap.put(key, value);
    }

    public synchronized void putAll(Map<String, Object> map) {
        this.globalChannelVariableMap.putAll(map);
    }

    public Map<String, Object> getVariables() {
        return Collections.unmodifiableMap(this.globalChannelVariableMap);
    }

    public synchronized void clear() {
        this.globalChannelVariableMap.clear();
    }

    public String toString() {
        return this.globalChannelVariableMap.toString();
    }

    public void lock(String key) {
        this.globalChannelVariableSyncMap.get(key).getLock().lock();
    }

    public void unlock(String key) {
        this.globalChannelVariableSyncMap.get(key).getLock().unlock();
    }

    public boolean containsKeySync(String key) {
        return this.globalChannelVariableSyncMap.containsKey(key);
    }

    public void removeSync(String key) {
        this.globalChannelVariableSyncMap.remove(key);
    }

    public Object getSync(String key) {
        this.lock(key);
        Object value = this.globalChannelVariableSyncMap.get(key).getValue();
        this.unlock(key);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSync(String key, Object value) {
        boolean exists = true;
        Map<String, SyncObject> map = this.globalChannelVariableSyncMap;
        synchronized (map) {
            if (!this.containsKeySync(key)) {
                exists = false;
                this.globalChannelVariableSyncMap.put(key, new SyncObject(value, new ReentrantLock()));
            }
        }
        if (exists) {
            this.lock(key);
            this.globalChannelVariableSyncMap.get(key).setValue(value);
            this.unlock(key);
        }
    }

    public void putAllSync(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.putSync(entry.getKey(), entry.getValue());
        }
    }

    public void clearSync() {
        this.globalChannelVariableSyncMap.clear();
    }
}

