/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import com.mirth.connect.server.util.SyncObject;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class GlobalVariableStore {
    public Map<String, Object> globalVariableMap = new ConcurrentHashMap<String, Object>();
    public Map<String, SyncObject> globalVariableSyncMap = new ConcurrentHashMap<String, SyncObject>();
    private static GlobalVariableStore instance = null;

    private GlobalVariableStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlobalVariableStore getInstance() {
        Class<GlobalVariableStore> clazz = GlobalVariableStore.class;
        synchronized (GlobalVariableStore.class) {
            if (instance == null) {
                instance = new GlobalVariableStore();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean containsKey(String key) {
        return this.globalVariableMap.containsKey(key);
    }

    public synchronized void remove(String key) {
        this.globalVariableMap.remove(key);
    }

    public Object get(String key) {
        return this.globalVariableMap.get(key);
    }

    public synchronized void put(String key, Object value) {
        this.globalVariableMap.put(key, value);
    }

    public synchronized void putAll(Map<String, Object> map) {
        this.globalVariableMap.putAll(map);
    }

    public Map<String, Object> getVariables() {
        return Collections.unmodifiableMap(this.globalVariableMap);
    }

    public synchronized void clear() {
        this.globalVariableMap.clear();
    }

    public String toString() {
        return this.globalVariableMap.toString();
    }

    public void lock(String key) {
        this.globalVariableSyncMap.get(key).getLock().lock();
    }

    public void unlock(String key) {
        this.globalVariableSyncMap.get(key).getLock().unlock();
    }

    public boolean containsKeySync(String key) {
        return this.globalVariableSyncMap.containsKey(key);
    }

    public void removeSync(String key) {
        this.globalVariableSyncMap.remove(key);
    }

    public Object getSync(String key) {
        this.lock(key);
        Object value = this.globalVariableSyncMap.get(key).getValue();
        this.unlock(key);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSync(String key, Object value) {
        boolean exists = true;
        Map<String, SyncObject> map = this.globalVariableSyncMap;
        synchronized (map) {
            if (!this.containsKeySync(key)) {
                exists = false;
                this.globalVariableSyncMap.put(key, new SyncObject(value, new ReentrantLock()));
            }
        }
        if (exists) {
            this.lock(key);
            this.globalVariableSyncMap.get(key).setValue(value);
            this.unlock(key);
        }
    }

    public void putAllSync(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.putSync(entry.getKey(), entry.getValue());
        }
    }

    public void clearSync() {
        this.globalVariableSyncMap.clear();
    }
}

