/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.model.LoginStrike;
import com.mirth.connect.model.PasswordRequirements;
import com.mirth.connect.model.User;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.UserController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class LoginRequirementsChecker {
    private static Logger logger = LogManager.getLogger(LoginRequirementsChecker.class);
    private User user;
    private PasswordRequirements passwordRequirements;
    private UserController userController;

    public LoginRequirementsChecker(User user) {
        this(user, ControllerFactory.getFactory().createConfigurationController().getPasswordRequirements(), ControllerFactory.getFactory().createUserController());
    }

    public LoginRequirementsChecker(User user, PasswordRequirements passwordRequirements, UserController userController) {
        this.user = user;
        this.passwordRequirements = passwordRequirements;
        this.userController = userController;
    }

    public int getStrikeCount() {
        return this.user.getStrikeCount() != null ? this.user.getStrikeCount() : 0;
    }

    public void incrementStrikes() {
        try {
            this.updateStrikeInfo(this.userController.incrementStrikes(this.user.getId()));
        }
        catch (ControllerException e) {
            logger.error("Unable to increment login strikes for user: " + this.user.toAuditString(), (Throwable)e);
        }
    }

    public void resetStrikes() {
        try {
            this.updateStrikeInfo(this.userController.resetStrikes(this.user.getId()));
        }
        catch (ControllerException e) {
            logger.error("Unable to increment login strikes for user: " + this.user.toAuditString(), (Throwable)e);
        }
    }

    private void updateStrikeInfo(LoginStrike strikeInfo) {
        if (strikeInfo != null) {
            this.user.setStrikeCount(strikeInfo.getLastStrikeCount());
            this.user.setLastStrikeTime(strikeInfo.getLastStrikeTime());
        }
    }

    public void resetExpiredStrikes() {
        if (this.getStrikeCount() > 0 && this.getStrikeTimeRemaining() <= 0L) {
            this.resetStrikes();
        }
    }

    public boolean isUserLockedOut() {
        if (!this.isLockoutEnabled()) {
            return false;
        }
        return this.getAttemptsRemaining() <= 0 && this.getStrikeTimeRemaining() > 0L;
    }

    public boolean isLockoutEnabled() {
        return this.passwordRequirements.getRetryLimit() > 0;
    }

    public int getAttemptsRemaining() {
        int retryLimit = this.passwordRequirements.getRetryLimit();
        return retryLimit + 1 - this.getStrikeCount();
    }

    public long getStrikeTimeRemaining() {
        Duration lockoutPeriod = Duration.standardHours((long)this.passwordRequirements.getLockoutPeriod());
        long lastStrikeTime = this.user.getLastStrikeTime() != null ? this.user.getLastStrikeTime().getTimeInMillis() : 0L;
        Duration strikeDuration = new Duration(lastStrikeTime, System.currentTimeMillis());
        return lockoutPeriod.minus((ReadableDuration)strikeDuration).getMillis();
    }

    public String getPrintableStrikeTimeRemaining() {
        Period period = new Period(this.getStrikeTimeRemaining());
        PeriodFormatter periodFormatter = period.toStandardMinutes().getMinutes() > 0 ? new PeriodFormatterBuilder().printZeroNever().appendHours().appendSuffix(" hour", " hours").appendSeparator(" and ").printZeroAlways().appendMinutes().appendSuffix(" minute", " minutes").toFormatter() : new PeriodFormatterBuilder().printZeroAlways().appendSeconds().appendSuffix(" second", " seconds").toFormatter();
        return periodFormatter.print((ReadablePeriod)period);
    }

    public String getPrintableLockoutPeriod() {
        return PeriodFormat.getDefault().print((ReadablePeriod)Period.hours((int)this.passwordRequirements.getLockoutPeriod()));
    }

    public boolean isPasswordExpired(long passwordTime, long currentTime) {
        return this.getDurationRemainingFromDays(passwordTime, currentTime, this.passwordRequirements.getExpiration()).getMillis() < 0L;
    }

    public long getGraceTimeRemaining(long gracePeriodStartTime, long currentTime) {
        return this.getDurationRemainingFromDays(gracePeriodStartTime, currentTime, this.passwordRequirements.getGracePeriod()).getMillis();
    }

    public String getPrintableGraceTimeRemaining(long graceTimeRemaining) {
        Period period = new Period(graceTimeRemaining);
        PeriodFormatter periodFormatter = period.toStandardHours().getHours() > 0 ? new PeriodFormatterBuilder().printZeroRarelyFirst().appendDays().appendSuffix(" day", " days").appendSeparator(" and ").printZeroAlways().appendHours().appendSuffix(" hour", " hours").toFormatter() : new PeriodFormatterBuilder().printZeroNever().appendMinutes().appendSuffix(" minute", " minutes").appendSeparator(" and ").printZeroAlways().appendSeconds().appendSuffix(" second", " seconds").toFormatter();
        return periodFormatter.print((ReadablePeriod)period);
    }

    private Duration getDurationRemainingFromDays(long passwordTime, long currentTime, int durationDays) {
        Duration expirationDuration = Duration.standardDays((long)durationDays);
        Duration passwordDuration = new Duration(passwordTime, currentTime);
        return expirationDuration.minus((ReadableDuration)passwordDuration);
    }
}

