/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.model.Credentials;
import com.mirth.connect.model.PasswordRequirements;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.UserController;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class PasswordRequirementsChecker
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PASSWORD_IS_TOO_SHORT_MINIMUM_LENGTH = "Password is too short. Minimum length is %d characters";
    private static final String PASSWORD_MUST_CONTAIN_A_SPECIAL_CHARACTER = "Password must contain %d special character(s)";
    private static final String PASSWORD_MUST_NOT_CONTAIN_A_SPECIAL_CHARACTER = "Password must not contain a special character";
    private static final String PASSWORD_MUST_CONTAIN_A_NUMERIC_VALUE = "Password must contain %d numeric value(s)";
    private static final String PASSWORD_MUST_NOT_CONTAIN_A_NUMERIC_VALUE = "Password must not contain a numeric value";
    private static final String PASSWORD_MUST_CONTAIN_A_LOWERCASE_LETTER = "Password must contain %d lowercase letter(s)";
    private static final String PASSWORD_MUST_NOT_CONTAIN_A_LOWERCASE_LETTER = "Password must not contain a lowercase letter";
    private static final String PASSWORD_MUST_CONTAIN_AN_UPPERCASE_LETTER = "Password must contain %d uppercase letter(s)";
    private static final String PASSWORD_MUST_NOT_CONTAIN_AN_UPPERCASE_LETTER = "Password not must contain an uppercase letter";
    private static final String PASSWORD_MINLENGTH = "password.minlength";
    private static final String PASSWORD_MIN_NUMERIC = "password.minnumeric";
    private static final String PASSWORD_MIN_LOWER = "password.minlower";
    private static final String PASSWORD_MIN_UPPER = "password.minupper";
    private static final String PASSWORD_MIN_SPECIAL = "password.minspecial";
    private static final String PASSWORD_EXPIRATION = "password.expiration";
    private static final String PASSWORD_GRACE_PERIOD = "password.graceperiod";
    private static final String PASSWORD_RETRY_LIMIT = "password.retrylimit";
    private static final String PASSWORD_LOCKOUT_PERIOD = "password.lockoutperiod";
    private static final String PASSWORD_REUSE_PERIOD = "password.reuseperiod";
    private static final String PASSWORD_REUSE_LIMIT = "password.reuselimit";
    private static PasswordRequirementsChecker instance = null;

    private PasswordRequirementsChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PasswordRequirementsChecker getInstance() {
        Class<PasswordRequirementsChecker> clazz = PasswordRequirementsChecker.class;
        synchronized (PasswordRequirementsChecker.class) {
            if (instance == null) {
                instance = new PasswordRequirementsChecker();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public PasswordRequirements loadPasswordRequirements(PropertiesConfiguration securityProperties) {
        PasswordRequirements passwordRequirements = new PasswordRequirements();
        passwordRequirements.setMinLength(securityProperties.getInt(PASSWORD_MINLENGTH, 0));
        passwordRequirements.setMinUpper(securityProperties.getInt(PASSWORD_MIN_UPPER, 0));
        passwordRequirements.setMinLower(securityProperties.getInt(PASSWORD_MIN_LOWER, 0));
        passwordRequirements.setMinNumeric(securityProperties.getInt(PASSWORD_MIN_NUMERIC, 0));
        passwordRequirements.setMinSpecial(securityProperties.getInt(PASSWORD_MIN_SPECIAL, 0));
        passwordRequirements.setExpiration(securityProperties.getInt(PASSWORD_EXPIRATION, 0));
        passwordRequirements.setGracePeriod(securityProperties.getInt(PASSWORD_GRACE_PERIOD, 0));
        passwordRequirements.setRetryLimit(securityProperties.getInt(PASSWORD_RETRY_LIMIT, 0));
        passwordRequirements.setLockoutPeriod(securityProperties.getInt(PASSWORD_LOCKOUT_PERIOD, 0));
        passwordRequirements.setReusePeriod(securityProperties.getInt(PASSWORD_REUSE_PERIOD, 0));
        passwordRequirements.setReuseLimit(securityProperties.getInt(PASSWORD_REUSE_LIMIT, 0));
        return passwordRequirements;
    }

    public List<String> doesPasswordMeetRequirements(Integer userId, String plainPassword, PasswordRequirements passwordRequirements) {
        ArrayList<String> resultList = new ArrayList<String>();
        this.addResult(resultList, this.checkMinLower(plainPassword, passwordRequirements.getMinLower()));
        this.addResult(resultList, this.checkMinUpper(plainPassword, passwordRequirements.getMinUpper()));
        this.addResult(resultList, this.checkMinNumeric(plainPassword, passwordRequirements.getMinNumeric()));
        this.addResult(resultList, this.checkMinSpecial(plainPassword, passwordRequirements.getMinSpecial()));
        if (passwordRequirements.getMinLength() > 0 && plainPassword.length() < passwordRequirements.getMinLength()) {
            this.addResult(resultList, String.format(PASSWORD_IS_TOO_SHORT_MINIMUM_LENGTH, passwordRequirements.getMinLength()));
        }
        if (userId != null && (passwordRequirements.getReusePeriod() != 0 || passwordRequirements.getReuseLimit() != 0)) {
            try {
                List<Credentials> previousCredentials = ControllerFactory.getFactory().createUserController().getUserCredentials(userId);
                this.addResult(resultList, this.checkReusePeriod(previousCredentials, plainPassword, passwordRequirements.getReusePeriod()));
                this.addResult(resultList, this.checkReuseLimit(previousCredentials, plainPassword, passwordRequirements.getReuseLimit()));
            }
            catch (ControllerException e) {
                this.addResult(resultList, "There was an error checking against previous user passwords.");
            }
        }
        if (resultList.size() == 0) {
            return null;
        }
        return resultList;
    }

    private void addResult(List<String> responseList, String result) {
        if (StringUtils.isNotBlank((CharSequence)result)) {
            responseList.add(result);
        }
    }

    private String checkMinNumeric(String plainTextPassword, int minNumeric) {
        if (minNumeric == -1) {
            Pattern pattern = Pattern.compile("[0-9]");
            Matcher matcher = pattern.matcher(plainTextPassword);
            if (matcher.find()) {
                return PASSWORD_MUST_NOT_CONTAIN_A_NUMERIC_VALUE;
            }
        } else {
            Pattern pattern = Pattern.compile("(?=(.*[0-9]){" + minNumeric + "})");
            Matcher matcher = pattern.matcher(plainTextPassword);
            if (!matcher.find()) {
                return String.format(PASSWORD_MUST_CONTAIN_A_NUMERIC_VALUE, minNumeric);
            }
        }
        return null;
    }

    private String checkMinUpper(String plainTextPassword, int minUpper) {
        if (minUpper == -1) {
            Pattern pattern = Pattern.compile("[A-Z]");
            Matcher matcher = pattern.matcher(plainTextPassword);
            if (matcher.find()) {
                return PASSWORD_MUST_NOT_CONTAIN_AN_UPPERCASE_LETTER;
            }
        } else {
            Pattern pattern = Pattern.compile("(?=(.*[A-Z]){" + minUpper + "})");
            Matcher matcher = pattern.matcher(plainTextPassword);
            if (!matcher.find()) {
                return String.format(PASSWORD_MUST_CONTAIN_AN_UPPERCASE_LETTER, minUpper);
            }
        }
        return null;
    }

    private String checkMinLower(String plainTextPassword, int minLower) {
        if (minLower == -1) {
            Pattern pattern = Pattern.compile("[a-z]");
            Matcher matcher = pattern.matcher(plainTextPassword);
            if (matcher.find()) {
                return PASSWORD_MUST_NOT_CONTAIN_A_LOWERCASE_LETTER;
            }
        } else {
            Pattern pattern = Pattern.compile("(?=(.*[a-z]){" + minLower + "})");
            Matcher matcher = pattern.matcher(plainTextPassword);
            if (!matcher.find()) {
                return String.format(PASSWORD_MUST_CONTAIN_A_LOWERCASE_LETTER, minLower);
            }
        }
        return null;
    }

    private String checkMinSpecial(String plainTextPassword, int minSpecial) {
        if (minSpecial == -1) {
            Pattern pattern = Pattern.compile("[!,@,#,$,%,^,&,*,?,_,~,\\+,-,=,\\(,\\),`,\\[,\\],:,;,\",',/,<,>]");
            Matcher matcher = pattern.matcher(plainTextPassword);
            if (matcher.find()) {
                return PASSWORD_MUST_NOT_CONTAIN_A_SPECIAL_CHARACTER;
            }
        } else {
            Pattern pattern = Pattern.compile("(?=(.*[!,@,#,$,%,^,&,*,?,_,~,\\+,-,=,\\(,\\),`,\\[,\\],:,;,\",',/,<,>]){" + minSpecial + "})");
            Matcher matcher = pattern.matcher(plainTextPassword);
            if (!matcher.find()) {
                return String.format(PASSWORD_MUST_CONTAIN_A_SPECIAL_CHARACTER, minSpecial);
            }
        }
        return null;
    }

    private String checkReusePeriod(List<Credentials> previousCredentials, String plainPassword, int reusePeriod) {
        if (reusePeriod == 0) {
            return null;
        }
        UserController userController = ControllerFactory.getFactory().createUserController();
        Duration reusePeriodDuration = null;
        if (reusePeriod != -1) {
            reusePeriodDuration = Duration.standardDays((long)reusePeriod);
        }
        for (Credentials credentials : previousCredentials) {
            boolean checkPassword = false;
            checkPassword = reusePeriodDuration == null ? true : reusePeriodDuration.isLongerThan((ReadableDuration)new Duration(credentials.getPasswordDate().getTimeInMillis(), System.currentTimeMillis()));
            if (!checkPassword || !userController.checkPassword(plainPassword, credentials.getPassword())) continue;
            if (reusePeriod == -1) {
                return "You cannot reuse the same password.";
            }
            return "You cannot reuse the same password within " + reusePeriod + " days.";
        }
        return null;
    }

    private String checkReuseLimit(List<Credentials> previousCredentials, String plainPassword, int reuseLimit) {
        if (reuseLimit == 0) {
            return null;
        }
        UserController userController = ControllerFactory.getFactory().createUserController();
        int reuseCount = 0;
        for (Credentials credentials : previousCredentials) {
            if (!userController.checkPassword(plainPassword, credentials.getPassword())) continue;
            ++reuseCount;
        }
        if (reuseCount > 0 && reuseCount > reuseLimit) {
            if (reuseLimit == -1) {
                return "You cannot reuse the same password.";
            }
            return "You cannot reuse the same password more than " + reuseLimit + " times.";
        }
        return null;
    }

    public Calendar getLastExpirationDate(PasswordRequirements passwordRequirements) {
        DateTime dateTime = new DateTime();
        if (passwordRequirements.getReusePeriod() == -1 || passwordRequirements.getReuseLimit() != 0) {
            return null;
        }
        if (passwordRequirements.getReusePeriod() == 0) {
            return Calendar.getInstance();
        }
        return dateTime.minus((ReadableDuration)Duration.standardDays((long)passwordRequirements.getReusePeriod())).toCalendar(Locale.getDefault());
    }
}

