/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import com.google.inject.Inject;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.model.DatabaseSettings;
import com.mirth.connect.model.PluginMetaData;
import com.mirth.connect.model.converters.DocumentSerializer;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ExtensionController;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.session.SqlSessionManager;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SqlConfig {
    @Inject
    private static volatile SqlConfig instance = null;
    private boolean splitReadWrite = false;
    private boolean writePoolCache = false;
    private SqlSessionFactory sqlSessionfactory;
    private SqlSessionManager sqlSessionManager = null;
    private SqlSessionFactory readOnlySqlSessionfactory;
    private SqlSessionManager readOnlySqlSessionManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SqlConfig getInstance() {
        SqlConfig sqlConfig = instance;
        if (sqlConfig != null) return sqlConfig;
        Class<SqlConfig> clazz = SqlConfig.class;
        synchronized (SqlConfig.class) {
            sqlConfig = instance;
            if (sqlConfig != null) return sqlConfig;
            instance = sqlConfig = new SqlConfig();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sqlConfig;
        }
    }

    public SqlConfig() {
        this.init();
    }

    public SqlSessionManager getSqlSessionManager() {
        return this.sqlSessionManager;
    }

    public SqlSessionManager getReadOnlySqlSessionManager() {
        return this.readOnlySqlSessionManager;
    }

    public boolean isSplitReadWrite() {
        return this.splitReadWrite;
    }

    public boolean isWritePoolCache() {
        return this.writePoolCache;
    }

    private void init() {
        try {
            LogFactory.useLog4JLogging();
            System.setProperty("derby.stream.error.method", "com.mirth.connect.server.Mirth.getNullOutputStream");
            DatabaseSettings databaseSettings = ControllerFactory.getFactory().createConfigurationController().getDatabaseSettings();
            this.sqlSessionfactory = this.createFactory(databaseSettings.getDatabase(), databaseSettings, null);
            this.sqlSessionManager = SqlSessionManager.newInstance((SqlSessionFactory)this.sqlSessionfactory);
            if (databaseSettings.isSplitReadWrite()) {
                String readOnlyDatabase = (String)StringUtils.defaultIfBlank((CharSequence)databaseSettings.getDatabaseReadOnly(), (CharSequence)databaseSettings.getDatabase());
                this.readOnlySqlSessionfactory = this.createFactory(readOnlyDatabase, databaseSettings, "readonly");
                this.readOnlySqlSessionManager = SqlSessionManager.newInstance((SqlSessionFactory)this.readOnlySqlSessionfactory);
                this.splitReadWrite = true;
            } else {
                this.readOnlySqlSessionfactory = this.sqlSessionfactory;
                this.readOnlySqlSessionManager = this.sqlSessionManager;
            }
            this.writePoolCache = databaseSettings.isWritePoolCache();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected SqlSessionFactory createFactory(String database, DatabaseSettings databaseSettings, String environment) throws Exception {
        BufferedReader br = new BufferedReader(Resources.getResourceAsReader((String)"SqlMapConfig.xml"));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
        Document document = factory.newDocumentBuilder().parse(new InputSource(br));
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        this.addPluginSqlMaps(database, new DonkeyElement(document.getDocumentElement()).getChildElement("mappers"));
        DocumentSerializer docSerializer = new DocumentSerializer();
        StringReader reader = new StringReader(docSerializer.toXML(document));
        Properties dbProperties = new Properties();
        dbProperties.putAll((Map<?, ?>)databaseSettings.getProperties());
        dbProperties.setProperty("database", database);
        if (environment != null) {
            return new SqlSessionFactoryBuilder().build((Reader)reader, environment, dbProperties);
        }
        return new SqlSessionFactoryBuilder().build((Reader)reader, dbProperties);
    }

    protected void addPluginSqlMaps(String database, DonkeyElement sqlMapConfigElement) throws Exception {
        ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();
        Map<String, PluginMetaData> plugins = extensionController.getPluginMetaData();
        if (MapUtils.isNotEmpty(plugins)) {
            for (String pluginName : plugins.keySet()) {
                PluginMetaData pmd = plugins.get(pluginName);
                if (!extensionController.isExtensionEnabled(pluginName) || pmd.getSqlMapConfigs() == null) continue;
                String pluginSqlMapName = pmd.getSqlMapConfigs().get(database);
                if (StringUtils.isBlank((CharSequence)pluginSqlMapName)) {
                    pluginSqlMapName = pmd.getSqlMapConfigs().get("all");
                }
                if (StringUtils.isNotBlank((CharSequence)pluginSqlMapName)) {
                    File sqlMapConfigFile = new File(ExtensionController.getExtensionsPath() + pmd.getPath(), pluginSqlMapName);
                    DonkeyElement sqlMapElement = sqlMapConfigElement.addChildElement("mapper");
                    sqlMapElement.setAttribute("url", sqlMapConfigFile.toURI().toURL().toString());
                    continue;
                }
                throw new RuntimeException("SQL map file not found for database: " + database);
            }
        }
    }
}

