/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util;

import com.mirth.connect.model.User;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserSessionCache {
    private Logger logger = LogManager.getLogger(this.getClass());
    private Map<HttpSession, User> userSessionMap = new ConcurrentHashMap<HttpSession, User>();
    private static UserSessionCache instance = null;

    private UserSessionCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserSessionCache getInstance() {
        Class<UserSessionCache> clazz = UserSessionCache.class;
        synchronized (UserSessionCache.class) {
            if (instance == null) {
                instance = new UserSessionCache();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void registerSessionForUser(HttpSession session, User user) {
        this.logger.debug("registering session: user=" + user.getId() + ", session=" + session.getId());
        this.userSessionMap.put(session, user);
    }

    public void invalidateAllSessionsForUser(Integer userId) {
        for (Map.Entry<HttpSession, User> entry : this.userSessionMap.entrySet()) {
            HttpSession entrySession = entry.getKey();
            User entryUser = entry.getValue();
            if (!entryUser.getId().equals(userId)) continue;
            this.logger.debug("invalidating session: user=" + entryUser.getId() + ", session=" + entrySession.getId());
            try {
                entrySession.removeAttribute("authorized");
            }
            catch (IllegalStateException e) {
                this.logger.debug("tried to invalidate session, but user was already logged out");
            }
            this.userSessionMap.remove(entrySession);
        }
    }
}

