/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util.javascript;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.transformers.InvalidTransformedDataException;
import com.mirth.connect.server.userutil.AlertSender;
import com.mirth.connect.server.userutil.Attachment;
import com.mirth.connect.server.userutil.ChannelMap;
import com.mirth.connect.server.userutil.ContextFactory;
import com.mirth.connect.server.userutil.DatabaseConnectionFactory;
import com.mirth.connect.server.userutil.DestinationSet;
import com.mirth.connect.server.userutil.ImmutableResponse;
import com.mirth.connect.server.userutil.SourceMap;
import com.mirth.connect.server.userutil.VMRouter;
import com.mirth.connect.server.util.GlobalChannelVariableStoreFactory;
import com.mirth.connect.server.util.GlobalVariableStore;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContext;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import com.mirth.connect.userutil.ImmutableConnectorMessage;
import com.mirth.connect.userutil.ImmutableMessage;
import com.mirth.connect.userutil.Response;
import com.mirth.connect.userutil.ResponseMap;
import com.mirth.connect.userutil.Status;
import com.mirth.connect.util.PropertyLoader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections4.MapUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJSON;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class JavaScriptScopeUtil {
    private static Logger logger = LogManager.getLogger(JavaScriptScopeUtil.class);
    private static Integer rhinoOptimizationLevel = null;

    protected static Context getContext(org.mozilla.javascript.ContextFactory contextFactory) {
        Context context = contextFactory.enterContext();
        context.setOptimizationLevel(rhinoOptimizationLevel.intValue());
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ScriptableObject createSealedSharedScope(org.mozilla.javascript.ContextFactory contextFactory) {
        Context context = contextFactory.enterContext();
        try {
            context.setOptimizationLevel(rhinoOptimizationLevel.intValue());
            ImporterTopLevel sealedSharedScope = new ImporterTopLevel(context);
            Script script = JavaScriptUtil.getCompiledGlobalSealedScript(context);
            script.exec(context, (Scriptable)sealedSharedScope);
            sealedSharedScope.sealObject();
            ImporterTopLevel importerTopLevel = sealedSharedScope;
            return importerTopLevel;
        }
        finally {
            Context.exit();
        }
    }

    private static Scriptable getScope(Context context) {
        Scriptable scope = context.newObject((Scriptable)((MirthContext)context).getSealedSharedScope());
        scope.setPrototype((Scriptable)((MirthContext)context).getSealedSharedScope());
        scope.setParentScope(null);
        return scope;
    }

    private static void add(String name, Scriptable scope, Object object) {
        scope.put(name, scope, Context.javaToJS((Object)object, (Scriptable)scope));
    }

    private static void addRawMessage(Scriptable scope, String message) {
        JavaScriptScopeUtil.add("message", scope, message);
    }

    private static void addMessage(Scriptable scope, Message message) {
        ImmutableMessage immutableMessage = new ImmutableMessage(message);
        JavaScriptScopeUtil.add("message", scope, immutableMessage);
        ConnectorMessage mergedConnectorMessage = message.getMergedConnectorMessage();
        ImmutableConnectorMessage immutableConnectorMessage = new ImmutableConnectorMessage(mergedConnectorMessage);
        JavaScriptScopeUtil.add("sourceMap", scope, new SourceMap(immutableConnectorMessage.getSourceMap()));
        JavaScriptScopeUtil.add("channelMap", scope, new ChannelMap(immutableConnectorMessage.getChannelMap(), immutableConnectorMessage.getSourceMap()));
        JavaScriptScopeUtil.add("responseMap", scope, new ResponseMap(mergedConnectorMessage.getResponseMap(), immutableMessage.getDestinationIdMap()));
    }

    private static void addConnectorMessage(Scriptable scope, ImmutableConnectorMessage message) {
        JavaScriptScopeUtil.add("connectorMessage", scope, message);
        JavaScriptScopeUtil.add("sourceMap", scope, new SourceMap(message.getSourceMap()));
        JavaScriptScopeUtil.add("connectorMap", scope, message.getConnectorMap());
        JavaScriptScopeUtil.add("channelMap", scope, new ChannelMap(message.getChannelMap(), message.getSourceMap()));
        JavaScriptScopeUtil.add("responseMap", scope, new ResponseMap(message.getResponseMap(), message.getDestinationIdMap()));
        JavaScriptScopeUtil.add("connector", scope, message.getConnectorName());
        JavaScriptScopeUtil.add("alerts", scope, new AlertSender(message));
        if (message.getMetaDataId() == 0) {
            JavaScriptScopeUtil.add("destinationSet", scope, new DestinationSet(message));
        }
    }

    private static void addResponse(Scriptable scope, Response response) {
        JavaScriptScopeUtil.add("response", scope, new ImmutableResponse(response));
        JavaScriptScopeUtil.add("responseStatus", scope, response.getStatus());
        JavaScriptScopeUtil.add("responseErrorMessage", scope, response.getError());
        JavaScriptScopeUtil.add("responseStatusMessage", scope, response.getStatusMessage());
    }

    private static void addRouter(Scriptable scope) {
        JavaScriptScopeUtil.add("router", scope, new VMRouter());
    }

    private static void addReplacer(Scriptable scope) {
        JavaScriptScopeUtil.add("replacer", scope, new TemplateValueReplacer());
    }

    private static void addGlobalMap(Scriptable scope) {
        JavaScriptScopeUtil.add("globalMap", scope, GlobalVariableStore.getInstance());
    }

    private static void addConfigurationMap(Scriptable scope) {
        JavaScriptScopeUtil.add("configurationMap", scope, ConfigurationController.getInstance().getConfigurationMap());
    }

    private static void addChannel(Scriptable scope, String channelId, String channelName) {
        JavaScriptScopeUtil.add("alerts", scope, new AlertSender(channelId));
        JavaScriptScopeUtil.add("channelId", scope, channelId);
        JavaScriptScopeUtil.add("channelName", scope, channelName);
        JavaScriptScopeUtil.add("globalChannelMap", scope, GlobalChannelVariableStoreFactory.getInstance().get(channelId));
    }

    private static void addLogger(Scriptable scope, Object logger) {
        JavaScriptScopeUtil.add("logger", scope, logger);
    }

    private static void addDatabaseConnectionFactory(Scriptable scope, Context context) {
        JavaScriptScopeUtil.add("DatabaseConnectionFactory", scope, new DatabaseConnectionFactory((MirthContextFactory)((MirthContext)context).getFactory()));
    }

    private static void addContextFactory(Scriptable scope, Context context) {
        JavaScriptScopeUtil.add("contextFactory", scope, new ContextFactory((MirthContextFactory)((MirthContext)context).getFactory()));
    }

    private static void addStatusValues(Scriptable scope) {
        for (Status status : Status.values()) {
            JavaScriptScopeUtil.add(status.toString(), scope, status);
        }
    }

    private static Scriptable getBasicScope(Context context) {
        Scriptable scope = JavaScriptScopeUtil.getScope(context);
        JavaScriptScopeUtil.addRouter(scope);
        JavaScriptScopeUtil.addReplacer(scope);
        JavaScriptScopeUtil.addConfigurationMap(scope);
        JavaScriptScopeUtil.addGlobalMap(scope);
        JavaScriptScopeUtil.addDatabaseConnectionFactory(scope, context);
        JavaScriptScopeUtil.addContextFactory(scope, context);
        return scope;
    }

    private static Scriptable getBasicScope(Context context, Object logger) {
        Scriptable scope = JavaScriptScopeUtil.getBasicScope(context);
        JavaScriptScopeUtil.addLogger(scope, logger);
        return scope;
    }

    private static Scriptable getBasicScope(Context context, Object logger, String channelId, String channelName) {
        Scriptable scope = JavaScriptScopeUtil.getBasicScope(context, logger);
        JavaScriptScopeUtil.addChannel(scope, channelId, channelName);
        return scope;
    }

    private static Scriptable getBasicScope(Context context, Object logger, ImmutableConnectorMessage message) {
        return JavaScriptScopeUtil.getBasicScope(context, logger, message.getChannelId(), message.getChannelName());
    }

    public static Scriptable getAttachmentScope(org.mozilla.javascript.ContextFactory contextFactory, Object logger, String channelId, String channelName, RawMessage message, List<Attachment> attachments, boolean isBinary) {
        Scriptable scope = JavaScriptScopeUtil.getBasicScope(JavaScriptScopeUtil.getContext(contextFactory), logger, channelId, channelName);
        JavaScriptScopeUtil.addRawMessage(scope, message.getRawData());
        JavaScriptScopeUtil.add("sourceMap", scope, new SourceMap(Collections.unmodifiableMap(message.getSourceMap())));
        JavaScriptScopeUtil.add("mirth_attachments", scope, attachments);
        JavaScriptScopeUtil.add("binary", scope, isBinary);
        return scope;
    }

    public static Scriptable getPreprocessorScope(org.mozilla.javascript.ContextFactory contextFactory, Object logger, String channelId, String message, ImmutableConnectorMessage connectorMessage) {
        Scriptable scope = JavaScriptScopeUtil.getBasicScope(JavaScriptScopeUtil.getContext(contextFactory), logger, channelId, connectorMessage.getChannelName());
        JavaScriptScopeUtil.addRawMessage(scope, message);
        JavaScriptScopeUtil.addConnectorMessage(scope, connectorMessage);
        return scope;
    }

    public static Scriptable getPostprocessorScope(org.mozilla.javascript.ContextFactory contextFactory, Object logger, String channelId, Message message) {
        Scriptable scope = JavaScriptScopeUtil.getBasicScope(JavaScriptScopeUtil.getContext(contextFactory), logger, channelId, message.getMergedConnectorMessage().getChannelName());
        JavaScriptScopeUtil.addStatusValues(scope);
        JavaScriptScopeUtil.addMessage(scope, message);
        return scope;
    }

    public static Scriptable getPostprocessorScope(org.mozilla.javascript.ContextFactory contextFactory, Object logger, String channelId, Message message, Response response) {
        Scriptable scope = JavaScriptScopeUtil.getBasicScope(JavaScriptScopeUtil.getContext(contextFactory), logger, channelId, message.getMergedConnectorMessage().getChannelName());
        JavaScriptScopeUtil.addMessage(scope, message);
        JavaScriptScopeUtil.addStatusValues(scope);
        JavaScriptScopeUtil.add("response", scope, response);
        return scope;
    }

    public static Scriptable getFilterTransformerScope(org.mozilla.javascript.ContextFactory contextFactory, Object logger, ImmutableConnectorMessage message, String template, Object phase) {
        Scriptable scope = JavaScriptScopeUtil.getBasicScope(JavaScriptScopeUtil.getContext(contextFactory), logger, message);
        JavaScriptScopeUtil.addConnectorMessage(scope, message);
        JavaScriptScopeUtil.add("template", scope, template);
        JavaScriptScopeUtil.add("phase", scope, phase);
        return scope;
    }

    public static Scriptable getResponseTransformerScope(org.mozilla.javascript.ContextFactory contextFactory, Object logger, Response response, ImmutableConnectorMessage message, String template) {
        Scriptable scope = JavaScriptScopeUtil.getBasicScope(JavaScriptScopeUtil.getContext(contextFactory), logger, message);
        JavaScriptScopeUtil.addConnectorMessage(scope, message);
        JavaScriptScopeUtil.addResponse(scope, response);
        JavaScriptScopeUtil.addStatusValues(scope);
        JavaScriptScopeUtil.add("template", scope, template);
        return scope;
    }

    public static Scriptable getDeployScope(org.mozilla.javascript.ContextFactory contextFactory, Object logger, String channelId, String channelName) {
        return JavaScriptScopeUtil.getBasicScope(JavaScriptScopeUtil.getContext(contextFactory), logger, channelId, channelName);
    }

    public static Scriptable getDeployScope(org.mozilla.javascript.ContextFactory contextFactory, Object logger) {
        return JavaScriptScopeUtil.getBasicScope(JavaScriptScopeUtil.getContext(contextFactory), logger);
    }

    public static Scriptable getUndeployScope(org.mozilla.javascript.ContextFactory contextFactory, Object logger, String channelId, String channelName) {
        return JavaScriptScopeUtil.getBasicScope(JavaScriptScopeUtil.getContext(contextFactory), logger, channelId, channelName);
    }

    public static Scriptable getUndeployScope(org.mozilla.javascript.ContextFactory contextFactory, Object logger) {
        return JavaScriptScopeUtil.getBasicScope(JavaScriptScopeUtil.getContext(contextFactory), logger);
    }

    public static Scriptable getMessageReceiverScope(org.mozilla.javascript.ContextFactory contextFactory, Object logger, String channelId, String channelName) {
        return JavaScriptScopeUtil.getBasicScope(JavaScriptScopeUtil.getContext(contextFactory), logger, channelId, channelName);
    }

    public static Scriptable getMessageReceiverScope(org.mozilla.javascript.ContextFactory contextFactory, Object logger, String channelId, ImmutableConnectorMessage message) {
        Scriptable scope = JavaScriptScopeUtil.getBasicScope(JavaScriptScopeUtil.getContext(contextFactory), logger, channelId, message.getChannelName());
        JavaScriptScopeUtil.addConnectorMessage(scope, message);
        return scope;
    }

    public static Scriptable getMessageDispatcherScope(org.mozilla.javascript.ContextFactory contextFactory, Object logger, String channelId, ImmutableConnectorMessage message) {
        Scriptable scope = JavaScriptScopeUtil.getBasicScope(JavaScriptScopeUtil.getContext(contextFactory), logger, channelId, message.getChannelName());
        JavaScriptScopeUtil.addConnectorMessage(scope, message);
        JavaScriptScopeUtil.addStatusValues(scope);
        return scope;
    }

    public static Scriptable getBatchProcessorScope(org.mozilla.javascript.ContextFactory contextFactory, Object logger, String channelId, String channelName, Map<String, Object> scopeObjects) {
        Scriptable scope = JavaScriptScopeUtil.getBasicScope(JavaScriptScopeUtil.getContext(contextFactory), logger);
        for (Map.Entry<String, Object> entry : scopeObjects.entrySet()) {
            JavaScriptScopeUtil.add(entry.getKey(), scope, entry.getValue());
        }
        if (channelId != null) {
            JavaScriptScopeUtil.addChannel(scope, channelId, channelName);
        }
        return scope;
    }

    public static String getTransformedDataFromScope(Scriptable scope, boolean hasTemplate) throws InvalidTransformedDataException {
        String result = null;
        String transformedVariableName = hasTemplate ? "tmp" : "msg";
        Object transformedData = scope.get(transformedVariableName, scope);
        if (transformedData != Scriptable.NOT_FOUND) {
            if (transformedData instanceof NativeObject || transformedData instanceof NativeArray) {
                try {
                    result = NativeJSON.stringify(Context.getCurrentContext(), scope, transformedData, null, null).toString();
                }
                catch (Exception e) {
                    throw new InvalidTransformedDataException("Error converting JavaScript object \"" + transformedVariableName + "\" to JSON.", e);
                }
            } else {
                result = Context.toString((Object)transformedData);
            }
        }
        return result;
    }

    public static void getResponseDataFromScope(Scriptable scope, Response response) {
        Object status = scope.get("responseStatus", scope);
        Object statusMessage = scope.get("responseStatusMessage", scope);
        Object errorMessage = scope.get("responseErrorMessage", scope);
        response.setStatus((Status)Context.jsToJava((Object)status, Status.class));
        if (statusMessage != null && !(statusMessage instanceof Undefined)) {
            response.setStatusMessage(Context.toString((Object)statusMessage));
        } else {
            response.setStatusMessage(null);
        }
        if (errorMessage != null && !(errorMessage instanceof Undefined)) {
            response.setError(Context.toString((Object)errorMessage));
        } else {
            response.setError(null);
        }
    }

    static {
        Properties properties = PropertyLoader.loadProperties("mirth");
        if (MapUtils.isNotEmpty((Map)properties) && properties.containsKey("rhino.optimizationlevel")) {
            logger.debug("set Rhino context optimization level: " + rhinoOptimizationLevel);
            rhinoOptimizationLevel = (int)Integer.valueOf(properties.getProperty("rhino.optimizationlevel"));
        } else {
            logger.debug("using default Rhino context optimization level (-1)");
            rhinoOptimizationLevel = -1;
        }
    }
}

