/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.util.javascript;

import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.util.ThreadUtils;
import com.mirth.connect.server.util.javascript.JavaScriptScopeUtil;
import com.mirth.connect.server.util.javascript.MirthContext;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import com.mirth.connect.server.util.javascript.MirthJavaScriptThread;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public abstract class JavaScriptTask<T>
implements Callable<T> {
    private Logger logger = LogManager.getLogger(JavaScriptTask.class);
    private MirthContextFactory contextFactory;
    private String threadName;
    private Context context;
    private boolean contextCreated = false;

    public JavaScriptTask(MirthContextFactory contextFactory, String name) {
        this(contextFactory, name, null, null);
    }

    public JavaScriptTask(MirthContextFactory contextFactory, String name, String channelId, String channelName) {
        this(contextFactory, name, channelId, channelName, null, null);
    }

    public JavaScriptTask(MirthContextFactory contextFactory, SourceConnector sourceConnector) {
        this(contextFactory, sourceConnector.getConnectorProperties().getName(), sourceConnector);
    }

    public JavaScriptTask(MirthContextFactory contextFactory, String name, SourceConnector sourceConnector) {
        this(contextFactory, name, sourceConnector.getChannelId(), sourceConnector.getChannel().getName(), sourceConnector.getMetaDataId(), null);
    }

    public JavaScriptTask(MirthContextFactory contextFactory, DestinationConnector destinationConnector) {
        this(contextFactory, destinationConnector.getConnectorProperties().getName(), destinationConnector.getChannelId(), destinationConnector.getChannel().getName(), destinationConnector.getMetaDataId(), destinationConnector.getDestinationName());
    }

    public JavaScriptTask(MirthContextFactory contextFactory, Connector connector) {
        this(contextFactory, connector.getConnectorProperties().getName(), connector);
    }

    public JavaScriptTask(MirthContextFactory contextFactory, String name, Connector connector) {
        this(contextFactory);
        if (connector instanceof SourceConnector) {
            this.init(name, connector.getChannelId(), connector.getChannel().getName(), connector.getMetaDataId(), null);
        } else {
            this.init(name, connector.getChannelId(), connector.getChannel().getName(), connector.getMetaDataId(), ((DestinationConnector)connector).getDestinationName());
        }
    }

    private JavaScriptTask(MirthContextFactory contextFactory, String name, String channelId, String channelName, Integer metaDataId, String destinationName) {
        this(contextFactory);
        this.init(name, channelId, channelName, metaDataId, destinationName);
    }

    private JavaScriptTask(MirthContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    private void init(String name, String channelId, String channelName, Integer metaDataId, String destinationName) {
        StringBuilder builder = new StringBuilder(name).append(" JavaScript Task");
        if (StringUtils.isNotEmpty((CharSequence)channelName)) {
            builder.append(" on ").append(channelName);
            if (StringUtils.isNotEmpty((CharSequence)channelId)) {
                builder.append(" (").append(channelId).append(')');
            }
            if (metaDataId != null && metaDataId > 0) {
                builder.append(',');
                if (StringUtils.isNotEmpty((CharSequence)destinationName)) {
                    builder.append(' ').append(destinationName);
                }
                builder.append(" (").append(metaDataId).append(')');
            }
        }
        this.threadName = builder.toString();
    }

    public MirthContextFactory getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(MirthContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    protected Context getContext() {
        return this.context;
    }

    public abstract T doCall() throws Exception;

    @Override
    public final T call() throws Exception {
        String originalThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(this.threadName + " < " + originalThreadName);
            T t = this.doCall();
            return t;
        }
        finally {
            Thread.currentThread().setName(originalThreadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeScript(Script compiledScript, Scriptable scope) throws InterruptedException {
        Thread currentThread = Thread.currentThread();
        try {
            Object object = this;
            synchronized (object) {
                ThreadUtils.checkInterruptedStatus();
                this.context = Context.getCurrentContext();
                currentThread.setContextClassLoader(this.contextFactory.getApplicationClassLoader());
                this.logger.debug(StringUtils.defaultString((String)StringUtils.trimToNull((String)this.getClass().getSimpleName()), (String)this.getClass().getName()) + " using context factory: " + ((Object)((Object)this.contextFactory)).hashCode());
                if (this.context == null) {
                    this.contextCreated = true;
                    this.context = JavaScriptScopeUtil.getContext(this.contextFactory);
                }
                if (this.context instanceof MirthContext) {
                    ((MirthContext)this.context).setRunning(true);
                }
            }
            if (currentThread instanceof MirthJavaScriptThread) {
                MirthJavaScriptThread mirthThread = (MirthJavaScriptThread)currentThread;
                mirthThread.setContext(this.context);
                mirthThread.setScope(scope);
            }
            object = compiledScript.exec(this.context, scope);
            return object;
        }
        finally {
            if (this.contextCreated) {
                Context.exit();
                this.contextCreated = false;
            }
            if (currentThread instanceof MirthJavaScriptThread) {
                MirthJavaScriptThread mirthThread = (MirthJavaScriptThread)currentThread;
                mirthThread.setContext(null);
                mirthThread.setScope(null);
            }
        }
    }
}

