/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mozilla.javascript.RhinoException;

public class ErrorMessageBuilder {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static String buildErrorMessage(String errorType, String customMessage, Throwable e) {
        String errorSourceLine = null;
        if (e instanceof RhinoException) {
            errorSourceLine = ((RhinoException)e).lineSource();
        }
        StringBuilder builder = new StringBuilder();
        String stackTrace = new String();
        if (e != null) {
            stackTrace = ExceptionUtils.getStackTrace((Throwable)e);
        }
        builder.append(errorType);
        builder.append(" error");
        if (StringUtils.isNotBlank((CharSequence)errorSourceLine)) {
            builder.append(LINE_SEPARATOR);
            builder.append("ERROR SOURCE: ");
            builder.append(errorSourceLine);
        }
        if (StringUtils.isNotBlank((CharSequence)customMessage)) {
            builder.append(LINE_SEPARATOR);
            builder.append("ERROR MESSAGE: ");
            builder.append(customMessage);
        }
        if (StringUtils.isNotBlank((CharSequence)stackTrace)) {
            builder.append(LINE_SEPARATOR);
            builder.append(stackTrace);
        }
        return builder.toString();
    }

    public static String buildErrorResponse(String customMessage, Throwable e) {
        Object responseException = new String();
        if (e != null) {
            responseException = " [" + e.getClass().getSimpleName() + ": " + e.getMessage() + "]";
        }
        return customMessage + (String)responseException;
    }
}

