/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import com.mirth.connect.server.util.ResourceUtil;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.NumberLiteral;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.StringLiteral;
import org.mozilla.javascript.ast.XmlDotQuery;
import org.mozilla.javascript.ast.XmlElemRef;
import org.mozilla.javascript.ast.XmlMemberGet;
import org.mozilla.javascript.ast.XmlPropRef;

public class JavaScriptSharedUtil {
    private static final Pattern RESULT_PATTERN = Pattern.compile("responseMap\\s*\\.\\s*put\\s*\\(\\s*(['\"])(((?!(?<!\\\\)\\1).)*)(?<!\\\\)\\1|\\$r\\s*\\(\\s*(['\"])(((?!(?<!\\\\)\\4).)*)(?<!\\\\)\\4(?=\\s*,)");
    private static final Pattern INVALID_IDENTIFIER_PATTERN = Pattern.compile("[^a-zA-Z0-9_$]");
    private static final Pattern INVALID_PROLOG_PATTERN = Pattern.compile("<<\\s*\\?\\s*xml\\s+version\\s*=\\s*\"(?<version>[^\"]*)\"(\\s+encoding\\s*=\\s*\"(?<encoding>[^\"]*)\")?\\s*\\?\\s*>");
    private static final int FULL_NAME_MATCHER_INDEX = 2;
    private static final int SHORT_NAME_MATCHER_INDEX = 5;
    private static volatile ScriptableObject cachedFormatterScope;
    private static int rhinoLanguageVersion;
    private static Logger logger;

    public static void setRhinoLanguageVersion(int version) {
        try {
            Context.checkLanguageVersion((int)version);
        }
        catch (Exception e) {
            logger.error("Error setting Rhino version.", (Throwable)e);
            version = 0;
        }
        rhinoLanguageVersion = version;
    }

    public static Context getGlobalContextForValidation() {
        Context context = Context.enter();
        context.setOptimizationLevel(-1);
        context.setLanguageVersion(rhinoLanguageVersion);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String validateScript(String script) {
        Context context = JavaScriptSharedUtil.getGlobalContextForValidation();
        try {
            context.compileString("function rhinoWrapper() {" + script + "\n}", UUID.randomUUID().toString(), 1, null);
        }
        catch (EvaluatorException e) {
            String string = "Error on line " + e.lineNumber() + ": " + e.getMessage() + ".";
            return string;
        }
        catch (Exception e) {
            String string = "Unknown error occurred during validation.";
            return string;
        }
        finally {
            Context.exit();
        }
        return null;
    }

    public static Collection<String> getResponseVariables(String script) {
        HashSet<String> variables = new HashSet<String>();
        if (script != null && script.length() > 0) {
            Matcher matcher = RESULT_PATTERN.matcher(script);
            while (matcher.find()) {
                variables.add(JavaScriptSharedUtil.getMapKey(matcher));
            }
        }
        return variables;
    }

    private static String getMapKey(Matcher matcher) {
        String key = matcher.group(2);
        if (key == null) {
            key = matcher.group(5);
        }
        return StringEscapeUtils.unescapeEcmaScript((String)key);
    }

    public static String convertIdentifier(String identifier) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)INVALID_IDENTIFIER_PATTERN.matcher(identifier).replaceAll(""), (CharSequence)"_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String prettyPrint(String script) {
        ScriptableObject scope = cachedFormatterScope;
        if (scope == null) {
            Class<JavaScriptSharedUtil> clazz = JavaScriptSharedUtil.class;
            // MONITORENTER : com.mirth.connect.util.JavaScriptSharedUtil.class
            scope = cachedFormatterScope;
            if (scope == null) {
                scope = cachedFormatterScope = JavaScriptSharedUtil.getFormatterScope();
            }
            // MONITOREXIT : clazz
        }
        if (scope == null) return script;
        Context currentThreadContext = JavaScriptSharedUtil.getGlobalContextForValidation();
        try {
            Scriptable global = (Scriptable)scope.get("global", (Scriptable)scope);
            Scriptable opts = (Scriptable)scope.get("opts", (Scriptable)scope);
            Function function = (Function)global.get("js_beautify", global);
            Object result = function.call(currentThreadContext, (Scriptable)scope, (Scriptable)scope, new Object[]{script, opts});
            String prettyPrinted = (String)Context.jsToJava((Object)result, String.class);
            Matcher matcher = INVALID_PROLOG_PATTERN.matcher(prettyPrinted);
            if (matcher.find()) {
                StringBuffer buffer = new StringBuffer();
                do {
                    String version = matcher.group("version");
                    String encoding = matcher.group("encoding");
                    StringBuilder prolog = new StringBuilder("<?xml version=\"").append(version).append('\"');
                    if (encoding != null) {
                        prolog.append(" encoding=\"").append(encoding).append('\"');
                    }
                    prolog.append("?>");
                    matcher.appendReplacement(buffer, prolog.toString());
                } while (matcher.find());
                matcher.appendTail(buffer);
                prettyPrinted = buffer.toString();
            }
            String string = prettyPrinted;
            return string;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScriptableObject getFormatterScope() {
        Context context = JavaScriptSharedUtil.getGlobalContextForValidation();
        InputStream is = null;
        try {
            is = JavaScriptSharedUtil.class.getResourceAsStream("beautify-1.6.8.js");
            String script = IOUtils.toString((InputStream)is);
            ScriptableObject scope = context.initStandardObjects();
            context.evaluateString((Scriptable)scope, "var global = {};", UUID.randomUUID().toString(), 1, null);
            context.evaluateString((Scriptable)scope, script, UUID.randomUUID().toString(), 1, null);
            context.evaluateString((Scriptable)scope, "var opts = { 'e4x': true };", UUID.randomUUID().toString(), 1, null);
            ScriptableObject scriptableObject = scope;
            return scriptableObject;
        }
        catch (Exception e) {
            logger.error("Failed to load beautify library.");
            ScriptableObject scriptableObject = null;
            return scriptableObject;
        }
        finally {
            ResourceUtil.closeResourceQuietly(is);
            Context.exit();
        }
    }

    public static String removeNumberLiterals(String expression) {
        if (expression == null) {
            return null;
        }
        String suffix = "";
        if (StringUtils.endsWith((CharSequence)expression, (CharSequence)".toString()")) {
            suffix = ".toString()";
            expression = StringUtils.removeEnd((String)expression, (String)suffix);
        }
        StringBuilder builder = new StringBuilder();
        for (ExprPart part : JavaScriptSharedUtil.getExpressionParts(expression, false)) {
            builder.append(part.getValue());
        }
        return builder.append(suffix).toString();
    }

    public static List<ExprPart> getExpressionParts(String expression) {
        return JavaScriptSharedUtil.getExpressionParts(expression, true);
    }

    public static List<ExprPart> getExpressionParts(String expression, boolean includeNumberLiterals) {
        try {
            ExpressionVisitor visitor = new ExpressionVisitor(includeNumberLiterals);
            CompilerEnvirons env = new CompilerEnvirons();
            env.setRecordingLocalJsDocComments(true);
            env.setAllowSharpComments(true);
            env.setRecordingComments(true);
            new Parser(env).parse((Reader)new StringReader(expression), null, 1).visitAll((NodeVisitor)visitor);
            if (!visitor.getParts().isEmpty()) {
                return visitor.getParts();
            }
        }
        catch (Exception e) {
            logger.debug("Error parsing expression: " + expression);
        }
        if (StringUtils.isNotBlank((CharSequence)expression)) {
            return new ArrayList<ExprPart>(Collections.singletonList(new ExprPart(expression, expression)));
        }
        return new ArrayList<ExprPart>();
    }

    static {
        rhinoLanguageVersion = 0;
        logger = LogManager.getLogger(JavaScriptSharedUtil.class);
    }

    public static class ExprPart {
        private String value;
        private String propertyName;
        private boolean numberLiteral;

        public ExprPart(String value, String propertyName) {
            this(value, propertyName, false);
        }

        public ExprPart(String value, String propertyName, boolean numberLiteral) {
            this.value = value;
            this.propertyName = propertyName;
            this.numberLiteral = numberLiteral;
        }

        public String getValue() {
            return this.value;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public boolean isNumberLiteral() {
            return this.numberLiteral;
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public String toString() {
            return this.value;
        }
    }

    private static class ExpressionVisitor
    implements NodeVisitor {
        private boolean includeNumberLiterals;
        private List<ExprPart> parts = new ArrayList<ExprPart>();

        public ExpressionVisitor(boolean includeNumberLiterals) {
            this.includeNumberLiterals = includeNumberLiterals;
        }

        public List<ExprPart> getParts() {
            return this.parts;
        }

        public boolean visit(AstNode node) {
            if (node instanceof AstRoot && node.hasChildren() && node.getFirstChild() instanceof ExpressionStatement) {
                ((ExpressionStatement)node.getFirstChild()).getExpression().visit((NodeVisitor)this);
            } else if (node instanceof ElementGet || node instanceof PropertyGet || node instanceof XmlMemberGet || node instanceof XmlDotQuery) {
                return true;
            }
            ExprPart part = null;
            if (node instanceof Name) {
                Name name = (Name)node;
                part = this.parts.isEmpty() ? new ExprPart(name.getIdentifier(), name.getIdentifier()) : (name.getParent() instanceof PropertyGet ? new ExprPart("." + name.toSource(), name.getIdentifier()) : new ExprPart("[" + name.toSource() + "]", name.getIdentifier()));
            } else if (!this.parts.isEmpty()) {
                if (node instanceof StringLiteral) {
                    part = new ExprPart("[" + node.toSource() + "]", node.toSource());
                } else if (node instanceof NumberLiteral) {
                    if (this.includeNumberLiterals) {
                        part = new ExprPart("[" + node.toSource() + "]", node.toSource(), true);
                    }
                } else if (node instanceof XmlPropRef) {
                    part = new ExprPart("." + node.toSource(), ((XmlPropRef)node).getPropName().toSource());
                } else if (node instanceof XmlElemRef) {
                    part = new ExprPart("." + node.toSource(), ((XmlElemRef)node).getExpression().toSource());
                }
            }
            if (part != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{part.getPropertyName(), part.getValue()})) {
                this.parts.add(part);
            }
            return false;
        }
    }
}

