/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.odysseus.staxon.json.JsonXMLConfig;
import de.odysseus.staxon.json.JsonXMLConfigBuilder;
import de.odysseus.staxon.json.JsonXMLInputFactory;
import de.odysseus.staxon.json.JsonXMLOutputFactory;
import de.odysseus.staxon.json.JsonXMLStreamReader;
import de.odysseus.staxon.json.JsonXMLStreamWriter;
import de.odysseus.staxon.json.stream.JsonStreamFactory;
import de.odysseus.staxon.json.stream.JsonStreamSource;
import de.odysseus.staxon.json.stream.JsonStreamTarget;
import de.odysseus.staxon.json.stream.JsonStreamToken;
import de.odysseus.staxon.json.stream.util.AutoPrimitiveTarget;
import de.odysseus.staxon.json.stream.util.MirthArrayTarget;
import de.odysseus.staxon.json.stream.util.RemoveRootTarget;
import de.odysseus.staxon.util.StreamWriterDelegate;
import de.odysseus.staxon.xml.util.PrettyXMLStreamWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;

public class JsonXmlUtil {
    private static final String SEPARATOR = ":";

    public static String xmlToJson(String xmlStr) throws IOException, XMLStreamException, FactoryConfigurationError, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        return JsonXmlUtil.xmlToJson(xmlStr, true);
    }

    public static String xmlToJson(String xmlStr, boolean normalizeNamespaces) throws IOException, XMLStreamException, FactoryConfigurationError, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        return JsonXmlUtil.xmlToJson(xmlStr, normalizeNamespaces, false, false);
    }

    public static String xmlToJson(String xmlStr, boolean normalizeNamespaces, boolean alwaysArray, boolean alwaysExpandObjects) throws IOException, XMLStreamException, FactoryConfigurationError, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        JsonXMLConfig config = new JsonXMLConfigBuilder().autoArray(true).autoPrimitive(true).prettyPrint(false).build();
        return JsonXmlUtil.xmlToJson(config, xmlStr, normalizeNamespaces, alwaysArray, alwaysExpandObjects);
    }

    public static String xmlToJson(JsonXMLConfig config, String xmlStr, boolean normalizeNamespaces, boolean alwaysArray, boolean alwaysExpandObjects) throws IOException, XMLStreamException, FactoryConfigurationError, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        try (InputStream inputStream = IOUtils.toInputStream((String)xmlStr);){
            String string;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
                XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(inputStream);
                StAXSource source = new StAXSource(reader);
                CorrectedJsonStreamFactory streamFactory = new CorrectedJsonStreamFactory();
                ExtendedJsonOutputFactory outputFactory = new ExtendedJsonOutputFactory(config, streamFactory, alwaysArray, alwaysExpandObjects);
                ExtendedJsonStreamWriterDelegate writer = new ExtendedJsonStreamWriterDelegate((XMLStreamWriter)outputFactory.createXMLStreamWriter(outputStream), normalizeNamespaces, alwaysExpandObjects);
                StAXResult result = new StAXResult((XMLStreamWriter)((Object)writer));
                JsonXmlUtil.getTransformerFactory().newTransformer().transform(source, result);
                string = outputStream.toString();
            }
            return string;
        }
    }

    public static String jsonToXml(String jsonStr) throws IOException, XMLStreamException, FactoryConfigurationError, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        JsonXMLConfig config = new JsonXMLConfigBuilder().multiplePI(false).build();
        return JsonXmlUtil.jsonToXml(config, jsonStr);
    }

    public static String jsonToXml(JsonXMLConfig config, String jsonStr) throws IOException, XMLStreamException, FactoryConfigurationError, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        String xmlString = null;
        try {
            xmlString = JsonXmlUtil.conversionJsontoXml(config, jsonStr);
        }
        catch (TransformerException e) {
            if (e.getCause() instanceof XMLStreamException) {
                String reOrderedString = JsonXmlUtil.reOrderJsonString(jsonStr);
                xmlString = JsonXmlUtil.conversionJsontoXml(config, reOrderedString);
            }
            throw e;
        }
        return xmlString;
    }

    private static String conversionJsontoXml(JsonXMLConfig config, String jsonStr) throws XMLStreamException, FactoryConfigurationError, TransformerException, TransformerConfigurationException, IOException {
        try (InputStream inputStream = IOUtils.toInputStream((String)jsonStr);){
            String string;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                JsonXMLStreamReader reader = new NormalizeXMLInputFactory(config).createXMLStreamReader(inputStream);
                Map<String, Deque<String>> prefixByTag = ((NormalizeXMLStreamReader)reader).prefixByTag;
                StAXSource source = new StAXSource((XMLStreamReader)reader);
                NormalizeXMLStreamWriterDelegate writer = new NormalizeXMLStreamWriterDelegate(XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream), prefixByTag);
                if (config.isPrettyPrint()) {
                    writer = new PrettyXMLStreamWriter((XMLStreamWriter)((Object)writer));
                }
                StAXResult result = new StAXResult((XMLStreamWriter)((Object)writer));
                JsonXmlUtil.getTransformerFactory().newTransformer().transform(source, result);
                string = outputStream.toString();
            }
            return string;
        }
    }

    private static void reOrderJsonNode(JsonNode currentNode) {
        if (currentNode.isObject()) {
            Iterator jsonFieldNames = currentNode.fieldNames();
            ArrayList<String> jsonKeys = new ArrayList<String>();
            while (jsonFieldNames.hasNext()) {
                jsonKeys.add((String)jsonFieldNames.next());
            }
            for (String currentKey : jsonKeys) {
                if (currentKey.startsWith("@")) continue;
                JsonNode removingObject = currentNode.get(currentKey);
                ObjectNode object = (ObjectNode)currentNode;
                object.remove(currentKey);
                object.put(currentKey, removingObject);
            }
            currentNode.fields().forEachRemaining(entry -> JsonXmlUtil.reOrderJsonNode((JsonNode)entry.getValue()));
        }
    }

    public static String reOrderJsonString(String jsonStr) throws JsonMappingException, JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(jsonStr);
        JsonXmlUtil.reOrderJsonNode(jsonNode);
        return jsonNode.toString();
    }

    private static TransformerFactory getTransformerFactory() {
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return tf;
    }

    public static class CorrectedJsonStreamFactory
    extends JsonStreamFactory {
        static final String REPLACEE_TEXT = "@xmlns:xmlns";
        static final String REPLACEMENT_TEXT = "@xmlns";
        private final JsonStreamFactory delegate;

        public CorrectedJsonStreamFactory() {
            this(CorrectedJsonStreamFactory.newFactory());
        }

        public CorrectedJsonStreamFactory(JsonStreamFactory delegate) {
            this.delegate = delegate;
        }

        public JsonStreamSource createJsonStreamSource(InputStream input) throws IOException {
            return this.delegate.createJsonStreamSource(input);
        }

        public JsonStreamSource createJsonStreamSource(Reader reader) throws IOException {
            return this.delegate.createJsonStreamSource(reader);
        }

        public JsonStreamTarget createJsonStreamTarget(OutputStream output, boolean prettyPrint) throws IOException {
            return new MyJsonStreamTarget(this.delegate.createJsonStreamTarget(output, prettyPrint));
        }

        public JsonStreamTarget createJsonStreamTarget(Writer writer, boolean prettyPrint) throws IOException {
            return new MyJsonStreamTarget(this.delegate.createJsonStreamTarget(writer, prettyPrint));
        }

        static class MyJsonStreamTarget
        implements JsonStreamTarget {
            final JsonStreamTarget delegate;

            public MyJsonStreamTarget(JsonStreamTarget delegate) {
                this.delegate = delegate;
            }

            public void close() throws IOException {
                this.delegate.close();
            }

            public void flush() throws IOException {
                this.delegate.flush();
            }

            public void endArray() throws IOException {
                this.delegate.endArray();
            }

            public void endObject() throws IOException {
                this.delegate.endObject();
            }

            public void name(String name) throws IOException {
                this.delegate.name(CorrectedJsonStreamFactory.REPLACEE_TEXT.equals(name) ? CorrectedJsonStreamFactory.REPLACEMENT_TEXT : name);
            }

            public void startArray() throws IOException {
                this.delegate.startArray();
            }

            public void startObject() throws IOException {
                this.delegate.startObject();
            }

            public void value(Object value) throws IOException {
                this.delegate.value(value);
            }
        }
    }

    private static class ExtendedJsonOutputFactory
    extends JsonXMLOutputFactory {
        private boolean alwaysArray;
        private boolean alwaysExpandObjects;

        public ExtendedJsonOutputFactory(JsonXMLConfig config, JsonStreamFactory streamFactory, boolean alwaysArray, boolean alwaysExpandObjects) {
            super(config, streamFactory);
            this.alwaysArray = alwaysArray;
            this.alwaysExpandObjects = alwaysExpandObjects;
        }

        public JsonXMLStreamWriter createXMLStreamWriter(OutputStream stream) throws XMLStreamException {
            try {
                return new NormalizeJsonStreamWriter(this.decorate(this.streamFactory.createJsonStreamTarget(stream, this.prettyPrint)), this.repairNamespacesMap(), this.multiplePI, this.namespaceSeparator, this.namespaceDeclarations, this.alwaysExpandObjects);
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }

        public JsonXMLStreamWriter createXMLStreamWriter(Writer stream) throws XMLStreamException {
            try {
                return new NormalizeJsonStreamWriter(this.decorate(this.streamFactory.createJsonStreamTarget(stream, this.prettyPrint)), this.repairNamespacesMap(), this.multiplePI, this.namespaceSeparator, this.namespaceDeclarations, this.alwaysExpandObjects);
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }

        protected JsonStreamTarget decorate(JsonStreamTarget target) {
            if (this.virtualRoot != null) {
                target = new RemoveRootTarget(target, this.virtualRoot, this.namespaceSeparator);
            }
            if (this.alwaysArray || this.autoArray) {
                target = new MirthArrayTarget(target, this.alwaysArray);
            }
            if (this.autoPrimitive) {
                target = new AutoPrimitiveTarget(target, false);
            }
            return target;
        }
    }

    private static class ExtendedJsonStreamWriterDelegate
    extends StreamWriterDelegate {
        private boolean normalizeNamespaces;
        private boolean alwaysExpandObjects;

        public ExtendedJsonStreamWriterDelegate(XMLStreamWriter parent, boolean normalizeNamespaces, boolean alwaysExpandObjects) {
            super(parent);
            this.normalizeNamespaces = normalizeNamespaces;
            this.alwaysExpandObjects = alwaysExpandObjects;
        }

        public void writeStartElement(String localName) throws XMLStreamException {
            if (this.normalizeNamespaces) {
                Pair<String, String> splitPair = ExtendedJsonStreamWriterDelegate.splitPrefixAndLocalName(localName);
                String prefix = (String)splitPair.getLeft();
                String local = (String)splitPair.getRight();
                super.writeStartElement(local);
                if (!prefix.equals("")) {
                    super.writeAttribute("xmlnsprefix", prefix);
                }
            } else {
                super.writeStartElement(localName);
            }
        }

        public void writeAttribute(String localName, String value) throws XMLStreamException {
            if (this.alwaysExpandObjects) {
                super.writeStartElement("@" + localName);
                super.writeAttribute("$", value);
                super.writeEndElement();
            } else {
                super.writeAttribute(localName, value);
            }
        }

        public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
            if (this.normalizeNamespaces) {
                if (prefix != null && "xml".equals(prefix)) {
                    prefix = "";
                    namespaceURI = "";
                    localName = "xml:" + (String)localName;
                }
                if (prefix.equals("")) {
                    if (this.alwaysExpandObjects) {
                        super.writeStartElement("@" + (String)localName);
                        super.writeAttribute("$", value);
                        super.writeEndElement();
                    } else {
                        super.writeAttribute(prefix, namespaceURI, (String)localName, value);
                    }
                } else {
                    super.writeStartElement("@" + (String)localName);
                    super.writeAttribute("xmlnsprefix", prefix);
                    super.writeAttribute("$", value);
                    super.writeEndElement();
                }
            } else if (this.alwaysExpandObjects) {
                super.writeStartElement("@" + prefix + JsonXmlUtil.SEPARATOR + (String)localName);
                super.writeAttribute("$", value);
                super.writeEndElement();
            } else {
                super.writeAttribute(prefix, namespaceURI, (String)localName, value);
            }
        }

        private static Pair<String, String> splitPrefixAndLocalName(String key) {
            String localName;
            String prefix;
            int separatorLocation = key.indexOf(JsonXmlUtil.SEPARATOR);
            if (separatorLocation != -1) {
                prefix = key.substring(0, separatorLocation);
                localName = key.substring(separatorLocation + 1);
            } else {
                prefix = "";
                localName = key;
            }
            return Pair.of((Object)prefix, (Object)localName);
        }
    }

    private static class NormalizeXMLInputFactory
    extends JsonXMLInputFactory {
        public NormalizeXMLInputFactory(JsonXMLConfig config) throws FactoryConfigurationError {
            super(config);
        }

        public JsonXMLStreamReader createXMLStreamReader(InputStream stream) throws XMLStreamException {
            try {
                return new NormalizeXMLStreamReader(this.decorate(this.streamFactory.createJsonStreamSource(stream)), this.multiplePI, this.namespaceSeparator, this.namespaceMappings);
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }
    }

    private static class NormalizeXMLStreamReader
    extends JsonXMLStreamReader {
        public Map<String, Deque<String>> prefixByTag;
        private String currentTagName;

        public NormalizeXMLStreamReader(JsonStreamSource decorate, boolean multiplePI, char namespaceSeparator, Map<String, String> namespaceMappings) throws XMLStreamException {
            super(decorate, multiplePI, namespaceSeparator, namespaceMappings);
        }

        public int getTextLength() {
            try {
                return super.getTextLength();
            }
            catch (NullPointerException e) {
                return 0;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void consumeName(JsonXMLStreamReader.ScopeInfo info) throws XMLStreamException, IOException {
            String fieldName = this.source.name();
            if (fieldName.startsWith("@")) {
                fieldName = fieldName.substring(1);
                if (this.source.peek() == JsonStreamToken.VALUE) {
                    this.handleValue(fieldName);
                    return;
                } else if ("xmlns".equals(fieldName)) {
                    this.handleXmlns();
                    return;
                } else if (this.source.peek() == JsonStreamToken.START_OBJECT) {
                    this.handleObject(fieldName);
                    return;
                } else {
                    if (this.source.peek() != JsonStreamToken.START_ARRAY) throw new IllegalStateException("Expected attribute value");
                    this.source.startArray();
                    while (this.source.peek() != JsonStreamToken.END_ARRAY) {
                        if (this.source.peek() == JsonStreamToken.VALUE) {
                            this.handleValue(fieldName);
                            continue;
                        }
                        if (this.source.peek() != JsonStreamToken.START_OBJECT) continue;
                        this.handleObject(fieldName);
                    }
                    this.source.endArray();
                }
                return;
            } else if ("$".equals(fieldName)) {
                this.readData(this.source.value(), 4);
                return;
            } else {
                info.currentTagName = fieldName;
            }
        }

        private void handleValue(String fieldName) throws XMLStreamException, IOException {
            String value = this.source.value().text;
            if (fieldName.equals("xmlnsprefix")) {
                Deque<String> prefixes;
                if (this.prefixByTag == null) {
                    this.prefixByTag = new HashMap<String, Deque<String>>();
                }
                if ((prefixes = this.prefixByTag.get(this.currentTagName)) == null) {
                    prefixes = new ArrayDeque<String>();
                    this.prefixByTag.put(this.currentTagName, prefixes);
                }
                prefixes.addLast(value);
            } else {
                this.readAttrNsDecl(fieldName, value);
            }
        }

        private void handleXmlns() throws XMLStreamException, IOException {
            this.source.startObject();
            while (this.source.peek() == JsonStreamToken.NAME) {
                String prefix = this.source.name();
                if ("$".equals(prefix)) {
                    this.readNsDecl("", this.source.value().text);
                    continue;
                }
                this.readNsDecl(prefix, this.source.value().text);
            }
            this.source.endObject();
        }

        private void handleObject(String fieldName) throws XMLStreamException, IOException {
            this.source.startObject();
            String prefix = "";
            while (this.source.peek() == JsonStreamToken.NAME) {
                String name = this.source.name();
                String text = this.source.value().text;
                if (name.equals("@xmlnsprefix")) {
                    prefix = text;
                    continue;
                }
                if (!name.equals("$")) continue;
                this.readAttrNsDecl(prefix + JsonXmlUtil.SEPARATOR + fieldName, text);
            }
            this.source.endObject();
        }

        protected void readStartElementTag(String name) throws XMLStreamException {
            this.currentTagName = name;
            super.readStartElementTag(name);
        }
    }

    private static class NormalizeXMLStreamWriterDelegate
    extends StreamWriterDelegate {
        private Map<String, Deque<String>> prefixByTag;

        public NormalizeXMLStreamWriterDelegate(XMLStreamWriter parent, Map<String, Deque<String>> prefixByTag) {
            super(parent);
            this.prefixByTag = prefixByTag;
        }

        public void writeStartElement(String localName) throws XMLStreamException {
            Deque<String> prefixes;
            if (this.prefixByTag != null && this.prefixByTag.containsKey(localName) && !(prefixes = this.prefixByTag.get(localName)).isEmpty()) {
                localName = prefixes.removeFirst() + JsonXmlUtil.SEPARATOR + (String)localName;
            }
            super.writeStartElement((String)localName);
        }

        public void setPrefix(String prefix, String uri) throws XMLStreamException {
            if (!"xml".equals(prefix) && !"xmlns".equals(prefix)) {
                super.setPrefix(prefix, uri);
            }
        }
    }

    private static class NormalizeJsonStreamWriter
    extends JsonXMLStreamWriter {
        private boolean alwaysExpandObjects;

        public NormalizeJsonStreamWriter(JsonStreamTarget target, boolean repairNamespaces, boolean multiplePI, char namespaceSeparator, boolean namespaceDeclarations, boolean alwaysExpandObjects) {
            super(target, repairNamespaces, multiplePI, namespaceSeparator, namespaceDeclarations);
            this.alwaysExpandObjects = alwaysExpandObjects;
        }

        public NormalizeJsonStreamWriter(JsonStreamTarget target, Map<String, String> repairNamespaces, boolean multiplePI, char namespaceSeparator, boolean namespaceDeclarations, boolean alwaysExpandObjects) {
            super(target, repairNamespaces, multiplePI, namespaceSeparator, namespaceDeclarations);
            this.alwaysExpandObjects = alwaysExpandObjects;
        }

        protected void writeAttr(String prefix, String localName, String namespaceURI, String value) throws XMLStreamException {
            String name = "".equals(prefix) ? localName : prefix + this.namespaceSeparator + localName;
            try {
                if (!((JsonXMLStreamWriter.ScopeInfo)this.getScope().getInfo()).startObjectWritten) {
                    this.target.startObject();
                    ((JsonXMLStreamWriter.ScopeInfo)this.getScope().getInfo()).startObjectWritten = true;
                }
                if (localName.equals("$")) {
                    this.target.name("$");
                } else {
                    this.target.name("@" + name);
                }
                this.target.value((Object)value);
            }
            catch (IOException e) {
                throw new XMLStreamException("Cannot write attribute: " + name, e);
            }
        }

        protected void writeData(Object data, int type) throws XMLStreamException {
            switch (type) {
                case 4: 
                case 12: {
                    if (this.getScope().isRoot() && !this.isStartDocumentWritten()) {
                        try {
                            this.target.value(data);
                            break;
                        }
                        catch (IOException e) {
                            throw new XMLStreamException("Cannot write data", e);
                        }
                    }
                    if (data == null) {
                        throw new XMLStreamException("Cannot write null data");
                    }
                    if (this.getScope().getLastChild() == null && ((JsonXMLStreamWriter.ScopeInfo)this.getScope().getInfo()).hasData()) {
                        if (data instanceof String) {
                            ((JsonXMLStreamWriter.ScopeInfo)this.getScope().getInfo()).addText(data.toString());
                            break;
                        }
                        throw new XMLStreamException("Cannot append primitive data: " + String.valueOf(data));
                    }
                    if (this.getScope().getLastChild() == null) {
                        if (this.alwaysExpandObjects) {
                            try {
                                if (!((JsonXMLStreamWriter.ScopeInfo)this.getScope().getInfo()).startObjectWritten) {
                                    this.target.startObject();
                                    ((JsonXMLStreamWriter.ScopeInfo)this.getScope().getInfo()).startObjectWritten = true;
                                }
                            }
                            catch (IOException e) {
                                throw new XMLStreamException("Cannot write start element: " + this.getScope().getLocalName(), e);
                            }
                        }
                        ((JsonXMLStreamWriter.ScopeInfo)this.getScope().getInfo()).setData(data);
                        break;
                    }
                    if (this.getScope().getLastChild().getLocalName().startsWith("@")) {
                        if (data instanceof String) {
                            ((JsonXMLStreamWriter.ScopeInfo)this.getScope().getInfo()).addText(data.toString());
                            break;
                        }
                        throw new XMLStreamException("Cannot append primitive data: " + String.valueOf(data));
                    }
                    if (this.skipSpace && NormalizeJsonStreamWriter.isWhitespace((Object)data)) break;
                    throw new XMLStreamException("Mixed content is not supported: '" + String.valueOf(data) + "'");
                }
                case 5: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Cannot write data of type " + type);
                }
            }
        }
    }
}

