/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    private static final Pattern pattern = Pattern.compile("xmlns:?[^=]*=[\\\"\\\"][^\\\"\\\"]*[\\\"\\\"]");

    public static String convertLineBreaks(String text, String replacement) {
        int start = 0;
        int end = -1;
        StringBuilder builder = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            boolean append = false;
            if (text.charAt(i) == '\r') {
                end = i;
                append = true;
                if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                    ++i;
                }
            } else if (text.charAt(i) == '\n') {
                end = i;
                append = true;
            }
            if (!append) continue;
            builder.append(text.substring(start, end));
            builder.append(replacement);
            start = i + 1;
        }
        if (start == 0) {
            return text;
        }
        builder.append(text.substring(start, text.length()));
        return builder.toString();
    }

    public static String stripNamespaces(String string) {
        return pattern.matcher(string).replaceAll("");
    }

    public static String unescape(String s) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        if (((String)s).length() >= 2 && ((String)s).substring(0, 1).equals("\"") && ((String)s).substring(((String)s).length() - 1, ((String)s).length()).equals("\"")) {
            return ((String)s).substring(1, ((String)s).length() - 1);
        }
        s = ((String)s).replace("\\b", "\b");
        s = ((String)s).replace("\\t", "\t");
        s = ((String)s).replace("\\n", "\n");
        s = ((String)s).replace("\\f", "\f");
        s = ((String)s).replace("\\r", "\r");
        int n = 0;
        while ((n = ((String)s).indexOf("0x", n)) != -1 && ((String)s).length() >= n + 4) {
            char ch;
            try {
                ch = (char)Integer.parseInt(((String)s).substring(n + 2, n + 4), 16);
            }
            catch (NumberFormatException e) {
                n += 2;
                continue;
            }
            if (n + 4 >= ((String)s).length()) {
                s = ((String)s).substring(0, n) + ch;
                break;
            }
            s = ((String)s).substring(0, n) + ch + ((String)s).substring(n + 4);
            ++n;
        }
        return s;
    }

    public static String valueOf(Object object) {
        if (object != null) {
            if (object instanceof Object[]) {
                return Arrays.toString((Object[])object);
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                StringBuilder builder = new StringBuilder("{");
                Iterator it = map.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    builder.append(key == map ? "(this Map)" : StringUtil.valueOf(key));
                    builder.append('=');
                    builder.append(value == map ? "(this Map)" : StringUtil.valueOf(value));
                    if (!it.hasNext()) continue;
                    builder.append(", ");
                }
                builder.append('}');
                return builder.toString();
            }
        }
        return String.valueOf(object);
    }

    public static boolean equalsIgnoreNull(String str1, String str2) {
        if (Strings.isNullOrEmpty((String)str1) && Strings.isNullOrEmpty((String)str2)) {
            return true;
        }
        return StringUtils.equals((CharSequence)str1, (CharSequence)str2);
    }
}

