/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.server.userutil.HashUtil;
import com.mirth.connect.userutil.ImmutableConnectorMessage;
import com.mirth.connect.userutil.ImmutableMessage;
import com.mirth.connect.userutil.JsonUtil;
import com.mirth.connect.userutil.XmlUtil;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.DateTool;

public class ValueReplacer {
    private Logger logger = LogManager.getLogger(this.getClass());
    private AtomicLong count = new AtomicLong(1L);

    public long getCount() {
        return this.count.getAndIncrement();
    }

    public static boolean hasReplaceableValues(String str) {
        return str != null && str.indexOf("$") > -1;
    }

    public Map<String, String> replaceValuesInMap(Map<String, String> map) {
        HashMap<String, String> localMap = new HashMap<String, String>(map);
        for (Map.Entry entry : localMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            localMap.put(key, this.replaceValues(value));
        }
        return localMap;
    }

    public Map<String, String> replaceValuesInMap(Map<String, String> map, ConnectorMessage connectorMessage) {
        HashMap<String, String> localMap = new HashMap<String, String>(map);
        for (Map.Entry entry : localMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            localMap.put(key, this.replaceValues(value, connectorMessage));
        }
        return localMap;
    }

    public Map<String, List<String>> replaceKeysAndValuesInMap(Map<String, List<String>> map, ConnectorMessage connectorMessage) {
        HashMap<String, List<String>> localMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String key = this.replaceValues(entry.getKey(), connectorMessage);
            ArrayList<String> list = new ArrayList<String>((Collection)entry.getValue());
            this.replaceValuesInList(list, connectorMessage);
            localMap.put(key, list);
        }
        return localMap;
    }

    public void replaceValuesInList(List<String> list) {
        for (int i = 0; i <= list.size() - 1; ++i) {
            list.set(i, this.replaceValues(list.get(i)));
        }
    }

    public void replaceValuesInList(List<String> list, ConnectorMessage connectorMessage) {
        for (int i = 0; i <= list.size() - 1; ++i) {
            list.set(i, this.replaceValues(list.get(i), connectorMessage));
        }
    }

    public String replaceValues(String template, Map<String, Object> map) {
        if (ValueReplacer.hasReplaceableValues(template)) {
            VelocityContext context = this.getDefaultContext();
            this.loadContextFromMap(context, map);
            return this.evaluate(context, template);
        }
        return template;
    }

    public String replaceValues(String template, ConnectorMessage connectorMessage) {
        if (ValueReplacer.hasReplaceableValues(template)) {
            VelocityContext context = this.getDefaultContext();
            this.loadContextFromConnectorMessage(context, connectorMessage);
            return this.evaluate(context, template);
        }
        return template;
    }

    public String replaceValues(String template, Message message) {
        if (ValueReplacer.hasReplaceableValues(template)) {
            VelocityContext context = this.getDefaultContext();
            this.loadContextFromMessage(context, message);
            return this.evaluate(context, template);
        }
        return template;
    }

    public String replaceValues(String template) {
        if (ValueReplacer.hasReplaceableValues(template)) {
            VelocityContext context = this.getDefaultContext();
            return this.evaluate(context, template);
        }
        return template;
    }

    public String replaceURLValues(String url, ConnectorMessage connectorMessage) {
        String host = new String();
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            try {
                host = URLDecoder.decode(url, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                try {
                    host = URLDecoder.decode(url, "default");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            host = this.replaceValues(host, connectorMessage);
        }
        return host;
    }

    protected String evaluate(VelocityContext context, String template) {
        StringWriter writer = new StringWriter();
        try {
            Velocity.evaluate((Context)context, (Writer)writer, (String)"LOG", (String)template);
        }
        catch (Exception e) {
            this.logger.warn("Could not replace template values", (Throwable)e);
            return template;
        }
        return writer.toString();
    }

    protected VelocityContext getDefaultContext() {
        VelocityContext context = new VelocityContext();
        context.put("date", (Object)new DateTool());
        context.put("DATE", (Object)new SimpleDateFormat("dd-MM-yy_HH-mm-ss.SS").format(new Date()));
        context.put("COUNT", (Object)new CountTool());
        context.put("UUID", (Object)UUID.randomUUID().toString());
        context.put("SYSTIME", (Object)String.valueOf(System.currentTimeMillis()));
        context.put("XmlUtil", XmlUtil.class);
        context.put("JsonUtil", JsonUtil.class);
        context.put("maps", (Object)new MapTool());
        return context;
    }

    protected void loadContextFromMap(VelocityContext context, Map<String, ?> map) {
        if (map != null) {
            ((MapTool)context.get("maps")).addMap(map);
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                context.put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void loadContextFromConnectorMessage(VelocityContext context, ConnectorMessage connectorMessage) {
        context.put("message", (Object)new ImmutableConnectorMessage(connectorMessage));
        context.put("channelName", (Object)connectorMessage.getChannelName());
        context.put("channelId", (Object)connectorMessage.getChannelId());
        context.put("HASH", (Object)new HashTool(connectorMessage));
        this.loadContextFromMap(context, connectorMessage.getSourceMap());
        this.loadContextFromMap(context, connectorMessage.getChannelMap());
        this.loadContextFromMap(context, connectorMessage.getConnectorMap());
        this.loadContextFromMap(context, connectorMessage.getResponseMap());
        if (!context.containsKey("originalFilename")) {
            context.put("originalFilename", (Object)(System.currentTimeMillis() + ".dat"));
        }
    }

    protected void loadContextFromMessage(VelocityContext context, Message message) {
        context.put("message", (Object)new ImmutableMessage(message));
        ConnectorMessage mergedConnectorMessage = message.getMergedConnectorMessage();
        this.loadContextFromMap(context, mergedConnectorMessage.getSourceMap());
        this.loadContextFromMap(context, mergedConnectorMessage.getChannelMap());
        this.loadContextFromMap(context, mergedConnectorMessage.getResponseMap());
        if (!context.containsKey("originalFilename")) {
            context.put("originalFilename", (Object)(System.currentTimeMillis() + ".dat"));
        }
        context.put("HASH", (Object)new HashTool(mergedConnectorMessage));
    }

    static {
        Properties props = new Properties();
        props.put("parser.allow_hyphen_in_identifiers", (Object)true);
        Velocity.init((Properties)props);
    }

    public class CountTool {
        public String toString() {
            return String.valueOf(ValueReplacer.this.getCount());
        }
    }

    public class MapTool {
        private List<Map<String, ?>> maps = new ArrayList();

        void addMap(Map<String, ?> map) {
            this.maps.add(map);
        }

        public Object get(String key) {
            for (Map<String, ?> map : this.maps) {
                if (!map.containsKey(key)) continue;
                return map.get(key);
            }
            return null;
        }
    }

    public class HashTool {
        private ConnectorMessage connectorMessage;

        public HashTool(ConnectorMessage connectorMessage) {
            this.connectorMessage = connectorMessage;
        }

        public String toString() {
            if (this.connectorMessage != null) {
                try {
                    if (this.connectorMessage.getEncoded() != null) {
                        return HashUtil.generate(this.connectorMessage.getEncoded().getContent());
                    }
                    return HashUtil.generate(this.connectorMessage.getRaw().getContent());
                }
                catch (Exception e) {
                    ValueReplacer.this.logger.debug("error while generating the hash for the message", (Throwable)e);
                }
            }
            return null;
        }
    }
}

