/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util.messagewriter;

import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.util.ArchiveUtils;
import com.mirth.connect.util.messagewriter.EncryptionType;
import com.mirth.connect.util.messagewriter.MessageWriter;
import com.mirth.connect.util.messagewriter.MessageWriterException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class MessageWriterArchive
implements MessageWriter {
    private MessageWriter fileWriter;
    private File rootFolder;
    private File archiveFile;
    private String archiver;
    private String compressor;
    private String password;
    private EncryptionType encryptionType;
    private boolean messagesWritten;

    public MessageWriterArchive(MessageWriter fileWriter, File rootFolder, File archiveFile, String archiver, String compressor, String password, EncryptionType encryptionType) {
        this.fileWriter = fileWriter;
        this.rootFolder = rootFolder;
        this.archiveFile = archiveFile;
        this.archiver = archiver;
        this.compressor = compressor;
        this.password = password;
        this.encryptionType = encryptionType;
    }

    @Override
    public boolean write(Message message) throws MessageWriterException {
        boolean result = this.fileWriter.write(message);
        if (!this.messagesWritten && result) {
            this.messagesWritten = true;
        }
        return result;
    }

    @Override
    public void finishWrite() throws MessageWriterException {
        this.fileWriter.close();
        if (this.messagesWritten) {
            try {
                File tempFile = new File(this.archiveFile.getParent() + IOUtils.DIR_SEPARATOR + "." + this.archiveFile.getName());
                if (tempFile.exists()) {
                    try {
                        FileUtils.forceDelete((File)tempFile);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ArchiveUtils.createArchive(this.rootFolder, tempFile, this.archiver, this.compressor, this.password, this.encryptionType);
                if (this.archiveFile.exists()) {
                    try {
                        FileUtils.forceDelete((File)this.archiveFile);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                FileUtils.moveFile((File)tempFile, (File)this.archiveFile);
            }
            catch (Exception e) {
                throw new MessageWriterException(e);
            }
            finally {
                FileUtils.deleteQuietly((File)this.rootFolder);
            }
        }
    }

    @Override
    public void close() throws MessageWriterException {
        this.fileWriter.close();
    }
}

