/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeSelectionModel;
import org.mozilla.javascript.tools.debugger.VariableModel;
import org.mozilla.javascript.tools.debugger.treetable.JTreeTable;
import org.mozilla.javascript.tools.debugger.treetable.TreeTableModel;
import org.mozilla.javascript.tools.debugger.treetable.TreeTableModelAdapter;

class MyTreeTable
extends JTreeTable {
    private static final long serialVersionUID = 3457265548184453049L;

    public MyTreeTable(VariableModel model) {
        super((TreeTableModel)model);
    }

    public JTree resetTree(TreeTableModel treeTableModel) {
        this.tree = new JTreeTable.TreeTableCellRenderer((JTreeTable)this, (TreeModel)treeTableModel);
        super.setModel((TableModel)new TreeTableModelAdapter(treeTableModel, (JTree)this.tree));
        JTreeTable.ListToTreeSelectionModelWrapper selectionWrapper = new JTreeTable.ListToTreeSelectionModelWrapper((JTreeTable)this);
        this.tree.setSelectionModel((TreeSelectionModel)selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        } else if (this.tree.getRowHeight() != this.getRowHeight()) {
            this.tree.setRowHeight(this.getRowHeight());
        }
        this.setDefaultRenderer(TreeTableModel.class, (TableCellRenderer)this.tree);
        this.setDefaultEditor(TreeTableModel.class, (TableCellEditor)new JTreeTable.TreeTableCellEditor((JTreeTable)this));
        this.setShowGrid(true);
        this.setIntercellSpacing(new Dimension(1, 1));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        DefaultTreeCellRenderer r = (DefaultTreeCellRenderer)this.tree.getCellRenderer();
        r.setOpenIcon(null);
        r.setClosedIcon(null);
        r.setLeafIcon(null);
        return this.tree;
    }

    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            if (me.getModifiers() == 0 || (me.getModifiers() & 0x410) != 0 && (me.getModifiers() & 0x1ACF) == 0) {
                int row = this.rowAtPoint(me.getPoint());
                for (int counter = this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (TreeTableModel.class != this.getColumnClass(counter)) continue;
                    MouseEvent newME = new MouseEvent((Component)this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - this.getCellRect((int)row, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                    this.tree.dispatchEvent((AWTEvent)newME);
                    break;
                }
            }
            return me.getClickCount() >= 3;
        }
        return e == null;
    }
}

