/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.extprops;

import com.mirth.connect.server.extprops.ExtensionStatusProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class ExtensionStatusFile
extends ExtensionStatusProvider {
    private File extensionPropertiesFile;
    private volatile Properties extensionProperties = new Properties();

    public ExtensionStatusFile(Properties mirthProperties) {
        super(mirthProperties);
        File appDataDir;
        String appData = mirthProperties.getProperty("dir.appdata");
        if (appData == null || appData.isEmpty()) {
            appData = "appdata";
        }
        if ((appDataDir = new File(appData)).exists()) {
            this.extensionPropertiesFile = new File(appDataDir, "extension.properties");
            if (!this.extensionPropertiesFile.exists()) {
                this.save();
                if (!this.extensionPropertiesFile.exists()) {
                    this.extensionPropertiesFile = null;
                    this.logger.error("Unable to create new extension.properties file.");
                }
            } else {
                this.reload();
            }
        } else {
            this.logger.error("Unable to find appdata directory: " + appData);
        }
    }

    @Override
    public void reload() {
        if (this.extensionPropertiesFile != null) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.extensionPropertiesFile);
                Properties props = new Properties();
                props.load(is);
                this.extensionProperties = props;
            }
            catch (Exception e) {
                try {
                    this.logger.error("Error reading extension.properties file.", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly(is);
            }
            IOUtils.closeQuietly(is);
        }
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        for (Object key : this.extensionProperties.keySet()) {
            set.add((String)key);
        }
        return set;
    }

    @Override
    public boolean containsKey(String pluginName) {
        return this.extensionProperties.containsKey(pluginName);
    }

    @Override
    public boolean isEnabled(String pluginName) {
        return Boolean.parseBoolean(this.extensionProperties.getProperty(pluginName, "true"));
    }

    @Override
    public void setEnabled(String pluginName, boolean enabled) {
        this.extensionProperties.setProperty(pluginName, Boolean.toString(enabled));
    }

    @Override
    public void remove(String pluginName) {
        this.extensionProperties.remove(pluginName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        if (this.extensionPropertiesFile != null) {
            Properties props = this.extensionProperties;
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(this.extensionPropertiesFile, false);
                props.store(os, null);
            }
            catch (Exception e) {
                try {
                    this.logger.error("Unable to save extension.properties file.", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
                IOUtils.closeQuietly(os);
            }
            IOUtils.closeQuietly(os);
        }
    }
}

