/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.ORL_O36_SPECIMEN_CONTAINER;
import ca.uhn.hl7v2.model.v27.group.ORL_O36_SPECIMEN_OBSERVATION;
import ca.uhn.hl7v2.model.v27.segment.NTE;
import ca.uhn.hl7v2.model.v27.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORL_O36_SPECIMEN
extends AbstractGroup {
    public ORL_O36_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false, false);
            this.add(ORL_O36_SPECIMEN_OBSERVATION.class, false, true, false);
            this.add(NTE.class, false, true, false);
            this.add(ORL_O36_SPECIMEN_CONTAINER.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORL_O36_SPECIMEN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public SPM getSPM() {
        SPM retVal = (SPM)this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public ORL_O36_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION() {
        ORL_O36_SPECIMEN_OBSERVATION retVal = (ORL_O36_SPECIMEN_OBSERVATION)this.getTyped("SPECIMEN_OBSERVATION", ORL_O36_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public ORL_O36_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION(int rep) {
        ORL_O36_SPECIMEN_OBSERVATION retVal = (ORL_O36_SPECIMEN_OBSERVATION)this.getTyped("SPECIMEN_OBSERVATION", rep, ORL_O36_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public int getSPECIMEN_OBSERVATIONReps() {
        return this.getReps("SPECIMEN_OBSERVATION");
    }

    public List<ORL_O36_SPECIMEN_OBSERVATION> getSPECIMEN_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_OBSERVATION", ORL_O36_SPECIMEN_OBSERVATION.class);
    }

    public void insertSPECIMEN_OBSERVATION(ORL_O36_SPECIMEN_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_OBSERVATION", (Structure)structure, rep);
    }

    public ORL_O36_SPECIMEN_OBSERVATION insertSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (ORL_O36_SPECIMEN_OBSERVATION)super.insertRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public ORL_O36_SPECIMEN_OBSERVATION removeSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (ORL_O36_SPECIMEN_OBSERVATION)super.removeRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public ORL_O36_SPECIMEN_CONTAINER getSPECIMEN_CONTAINER() {
        ORL_O36_SPECIMEN_CONTAINER retVal = (ORL_O36_SPECIMEN_CONTAINER)this.getTyped("SPECIMEN_CONTAINER", ORL_O36_SPECIMEN_CONTAINER.class);
        return retVal;
    }

    public ORL_O36_SPECIMEN_CONTAINER getSPECIMEN_CONTAINER(int rep) {
        ORL_O36_SPECIMEN_CONTAINER retVal = (ORL_O36_SPECIMEN_CONTAINER)this.getTyped("SPECIMEN_CONTAINER", rep, ORL_O36_SPECIMEN_CONTAINER.class);
        return retVal;
    }

    public int getSPECIMEN_CONTAINERReps() {
        return this.getReps("SPECIMEN_CONTAINER");
    }

    public List<ORL_O36_SPECIMEN_CONTAINER> getSPECIMEN_CONTAINERAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_CONTAINER", ORL_O36_SPECIMEN_CONTAINER.class);
    }

    public void insertSPECIMEN_CONTAINER(ORL_O36_SPECIMEN_CONTAINER structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_CONTAINER", (Structure)structure, rep);
    }

    public ORL_O36_SPECIMEN_CONTAINER insertSPECIMEN_CONTAINER(int rep) throws HL7Exception {
        return (ORL_O36_SPECIMEN_CONTAINER)super.insertRepetition("SPECIMEN_CONTAINER", rep);
    }

    public ORL_O36_SPECIMEN_CONTAINER removeSPECIMEN_CONTAINER(int rep) throws HL7Exception {
        return (ORL_O36_SPECIMEN_CONTAINER)super.removeRepetition("SPECIMEN_CONTAINER", rep);
    }
}

