/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.delimited;

import com.mirth.connect.plugins.datatypes.delimited.DelimitedDeserializationProperties;
import com.mirth.connect.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class DelimitedXMLHandler
extends DefaultHandler {
    private StringBuilder output = new StringBuilder();
    private DelimitedDeserializationProperties properties;
    private boolean inRow;
    private boolean inColumn;
    private int columnIndex;
    private String columnDelimiter = null;
    private String recordDelimiter = null;
    private String quoteToken = null;
    private String quoteEscapeToken = null;
    private String escapedQuote = null;
    private String escapedQuoteEscape = null;
    private StringBuilder columnValue = null;

    public DelimitedXMLHandler(DelimitedDeserializationProperties properties) {
        this.properties = properties;
        this.updateColumnDelimiter();
        this.updateRecordDelimiter();
        this.updateQuoteToken();
        this.updateQuoteEscapeToken();
        this.updateEscapedQuote();
        this.updateEscapedQuoteEscape();
    }

    @Override
    public void startDocument() {
        this.inRow = false;
        this.inColumn = false;
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (!this.inRow && name.length() >= 3 && name.substring(0, 3).equalsIgnoreCase("row")) {
            this.inRow = true;
            this.inColumn = false;
            this.columnIndex = 0;
        } else if (this.inRow && !this.inColumn) {
            this.inColumn = true;
            if (this.properties.getColumnWidths() == null && this.columnIndex > 0) {
                this.output.append(this.columnDelimiter);
            }
            this.columnValue = new StringBuilder();
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.inColumn) {
            if (this.properties.getColumnWidths() != null) {
                if (this.columnIndex < this.properties.getColumnWidths().length) {
                    this.output.append((CharSequence)this.columnValue);
                    for (int len = this.properties.getColumnWidths()[this.columnIndex] - this.columnValue.length(); len > 0; --len) {
                        this.output.append(' ');
                    }
                }
            } else {
                String temp = this.columnValue.toString();
                if (temp.contains(this.columnDelimiter) || temp.contains(this.recordDelimiter)) {
                    temp = temp.replace(this.quoteEscapeToken, this.escapedQuoteEscape);
                    temp = temp.replace(this.quoteToken, this.escapedQuote);
                    this.output.append(this.quoteToken);
                    this.output.append(temp);
                    this.output.append(this.quoteToken);
                } else {
                    this.output.append((CharSequence)this.columnValue);
                }
            }
            this.inColumn = false;
            ++this.columnIndex;
        } else if (this.inRow) {
            this.inRow = false;
            this.output.append(this.recordDelimiter);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inColumn) {
            if (this.properties.getColumnWidths() != null) {
                if (this.columnIndex < this.properties.getColumnWidths().length) {
                    int columnWidth = this.properties.getColumnWidths()[this.columnIndex];
                    if (this.columnValue.length() + length > columnWidth) {
                        length = columnWidth - this.columnValue.length();
                    }
                    this.columnValue.append(ch, start, length);
                }
            } else {
                this.columnValue.append(ch, start, length);
            }
        }
    }

    public StringBuilder getOutput() {
        return this.output;
    }

    public void setOutput(StringBuilder output) {
        this.output = output;
    }

    private void updateColumnDelimiter() {
        if (this.columnDelimiter == null && StringUtils.isNotEmpty((CharSequence)this.properties.getColumnDelimiter())) {
            this.columnDelimiter = StringUtil.unescape((String)this.properties.getColumnDelimiter());
        }
    }

    private void updateRecordDelimiter() {
        if (this.recordDelimiter == null && StringUtils.isNotEmpty((CharSequence)this.properties.getRecordDelimiter())) {
            this.recordDelimiter = StringUtil.unescape((String)this.properties.getRecordDelimiter());
        }
    }

    private void updateQuoteToken() {
        if (this.quoteToken == null && StringUtils.isNotEmpty((CharSequence)this.properties.getQuoteToken())) {
            this.quoteToken = StringUtil.unescape((String)this.properties.getQuoteToken());
        }
    }

    private void updateQuoteEscapeToken() {
        if (this.quoteEscapeToken == null && StringUtils.isNotEmpty((CharSequence)this.properties.getQuoteEscapeToken())) {
            this.quoteEscapeToken = StringUtil.unescape((String)this.properties.getQuoteEscapeToken());
        }
    }

    private void updateEscapedQuote() {
        if (this.escapedQuote == null) {
            this.escapedQuote = this.properties.isEscapeWithDoubleQuote() ? this.quoteToken + this.quoteToken : this.quoteEscapeToken + this.quoteToken;
        }
    }

    private void updateEscapedQuoteEscape() {
        if (this.escapedQuoteEscape == null) {
            this.escapedQuoteEscape = this.quoteEscapeToken + this.quoteEscapeToken;
        }
    }
}

