/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v22.group.ADR_A19_QUERY_RESPONSE;
import ca.uhn.hl7v2.model.v22.segment.DSC;
import ca.uhn.hl7v2.model.v22.segment.ERR;
import ca.uhn.hl7v2.model.v22.segment.MSA;
import ca.uhn.hl7v2.model.v22.segment.MSH;
import ca.uhn.hl7v2.model.v22.segment.QRD;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ADR_A19
extends AbstractMessage {
    public ADR_A19() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public ADR_A19(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(QRD.class, true, false);
            this.add(ADR_A19_QUERY_RESPONSE.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADR_A19 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.2";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public QRD getQRD() {
        return (QRD)this.getTyped("QRD", QRD.class);
    }

    public ADR_A19_QUERY_RESPONSE getQUERY_RESPONSE() {
        return (ADR_A19_QUERY_RESPONSE)this.getTyped("QUERY_RESPONSE", ADR_A19_QUERY_RESPONSE.class);
    }

    public ADR_A19_QUERY_RESPONSE getQUERY_RESPONSE(int rep) {
        return (ADR_A19_QUERY_RESPONSE)this.getTyped("QUERY_RESPONSE", rep, ADR_A19_QUERY_RESPONSE.class);
    }

    public int getQUERY_RESPONSEReps() {
        return this.getReps("QUERY_RESPONSE");
    }

    public List<ADR_A19_QUERY_RESPONSE> getQUERY_RESPONSEAll() throws HL7Exception {
        return this.getAllAsList("QUERY_RESPONSE", ADR_A19_QUERY_RESPONSE.class);
    }

    public void insertQUERY_RESPONSE(ADR_A19_QUERY_RESPONSE structure, int rep) throws HL7Exception {
        super.insertRepetition("QUERY_RESPONSE", (Structure)structure, rep);
    }

    public ADR_A19_QUERY_RESPONSE insertQUERY_RESPONSE(int rep) throws HL7Exception {
        return (ADR_A19_QUERY_RESPONSE)super.insertRepetition("QUERY_RESPONSE", rep);
    }

    public ADR_A19_QUERY_RESPONSE removeQUERY_RESPONSE(int rep) throws HL7Exception {
        return (ADR_A19_QUERY_RESPONSE)super.removeRepetition("QUERY_RESPONSE", rep);
    }

    public DSC getDSC() {
        return (DSC)this.getTyped("DSC", DSC.class);
    }
}

