/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.server.controller;

import com.mirth.connect.plugins.messagetrends.server.dao.impl.MyBatisMessageStatisticsTimeseriesDao;
import com.mirth.connect.plugins.messagetrends.server.exception.MessageTrendsException;
import com.mirth.connect.plugins.messagetrends.server.maintenance.MessageTrendsConfig;
import com.mirth.connect.plugins.messagetrends.server.maintenance.MessageTrendsScheduler;
import com.mirth.connect.plugins.messagetrends.server.maintenance.MessageTrendsSchedulerFactory;
import com.mirth.connect.plugins.messagetrends.server.migration.MessageTrendsDatabaseMigrator;
import com.mirth.connect.plugins.messagetrends.server.service.MessageTrendsService;
import com.mirth.connect.plugins.messagetrends.server.util.DatabaseDialect;
import com.mirth.connect.plugins.messagetrends.server.util.SqlSessionManagerProvider;
import com.mirth.connect.plugins.messagetrends.shared.model.MessageTrendsProperties;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ExtensionController;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageTrendsController {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final MessageTrendsService messageTrendsService = MessageTrendsService.getInstance();
    private MessageTrendsScheduler messageTrendsScheduler;
    private MessageTrendsConfig messageTrendsConfig;
    private final ScheduledExecutorService restoreExec = Executors.newSingleThreadScheduledExecutor(runnable -> {
        Thread thread = new Thread(runnable, "MessageTrends Restore Reconcile");
        thread.setDaemon(true);
        return thread;
    });
    private ScheduledFuture<?> pendingRestore;
    private static MessageTrendsController instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageTrendsController getInstance() {
        Class<MessageTrendsController> clazz = MessageTrendsController.class;
        synchronized (MessageTrendsController.class) {
            if (instance == null) {
                instance = new MessageTrendsController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Properties properties) throws MessageTrendsException {
        try {
            SqlSessionManager sqlSessionManager = this.getSqlSessionManager();
            new MessageTrendsDatabaseMigrator(sqlSessionManager).initializeDatabase();
            DatabaseDialect.DatabaseType databaseType = DatabaseDialect.determineDatabaseType(sqlSessionManager);
            MyBatisMessageStatisticsTimeseriesDao myBatisMessageStatisticsTimeseriesDao = new MyBatisMessageStatisticsTimeseriesDao(sqlSessionManager, databaseType);
            this.messageTrendsService.init(myBatisMessageStatisticsTimeseriesDao);
            MessageTrendsProperties messageTrendsProperties = MessageTrendsProperties.fromProperties((Properties)properties);
            this.messageTrendsConfig = MessageTrendsConfig.defaultConfig().withEnabled(messageTrendsProperties.isEnabled());
            if (this.messageTrendsConfig.isEnabled()) {
                this.messageTrendsScheduler = MessageTrendsSchedulerFactory.build(this.messageTrendsService, ConfigurationController.getInstance().getServerId(), this.messageTrendsConfig);
            }
            this.logger.info("Message Trends initialized. enabled={}", (Object)messageTrendsProperties.isEnabled());
        }
        catch (Exception exception) {
            throw new MessageTrendsException(exception);
        }
    }

    public void update(Properties properties) throws MessageTrendsException {
        if (this.pendingRestore != null) {
            this.pendingRestore.cancel(false);
            this.pendingRestore = null;
        }
        try {
            MessageTrendsProperties messageTrendsProperties = MessageTrendsProperties.fromProperties((Properties)properties);
            boolean bl = messageTrendsProperties.isEnabled();
            boolean bl2 = this.messageTrendsConfig.isEnabled();
            if (bl == bl2) {
                return;
            }
            this.messageTrendsConfig = MessageTrendsConfig.defaultConfig().withEnabled(bl);
            if (this.messageTrendsScheduler != null) {
                this.messageTrendsScheduler.stop();
                this.messageTrendsScheduler = null;
            }
            if (bl) {
                this.messageTrendsScheduler = MessageTrendsSchedulerFactory.buildAndStart(this.messageTrendsService, ConfigurationController.getInstance().getServerId(), this.messageTrendsConfig);
            }
        }
        catch (Exception exception) {
            throw new MessageTrendsException(exception);
        }
    }

    public void start() throws MessageTrendsException {
        try {
            if (this.messageTrendsScheduler != null) {
                this.messageTrendsScheduler.start();
            }
        }
        catch (Exception exception) {
            throw new MessageTrendsException(exception);
        }
    }

    public void stop() throws MessageTrendsException {
        try {
            if (this.messageTrendsScheduler != null) {
                this.messageTrendsScheduler.stop();
                this.messageTrendsScheduler = null;
            }
        }
        catch (Exception exception) {
            throw new MessageTrendsException(exception);
        }
        finally {
            if (this.pendingRestore != null) {
                this.pendingRestore.cancel(false);
                this.pendingRestore = null;
            }
        }
    }

    public void onRestoreTriggered() {
        if (this.pendingRestore != null && !this.pendingRestore.isDone()) {
            this.pendingRestore.cancel(false);
            this.pendingRestore = null;
        }
        this.pendingRestore = this.restoreExec.schedule(() -> {
            try {
                Properties properties = ExtensionController.getInstance().getPluginProperties("Message Trends Management System");
                if (properties != null) {
                    this.update(properties);
                }
            }
            catch (Exception exception) {
                this.logger.error("Failed to reconcile after restore", (Throwable)exception);
            }
        }, 5L, TimeUnit.SECONDS);
        this.logger.debug("Scheduled reconcile after restore (5s delay).");
    }

    private SqlSessionManager getSqlSessionManager() {
        return SqlSessionManagerProvider.get();
    }
}

