/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.server.maintenance;

import com.mirth.connect.plugins.messagetrends.server.core.MessageTrendsBuffer;
import com.mirth.connect.plugins.messagetrends.server.maintenance.MinuteFlushRunner;
import com.mirth.connect.plugins.messagetrends.server.maintenance.PurgeRunner;
import com.mirth.connect.plugins.messagetrends.server.maintenance.RollupRunner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MessageTrendsScheduler {
    private static final Logger logger = LogManager.getLogger(MessageTrendsScheduler.class);
    private final ScheduledExecutorService flushExec = Executors.newSingleThreadScheduledExecutor(runnable -> MessageTrendsScheduler.named("MT-Flush", runnable));
    private final ScheduledExecutorService rollupExec = Executors.newSingleThreadScheduledExecutor(runnable -> MessageTrendsScheduler.named("MT-Rollup", runnable));
    private final ScheduledExecutorService purgeExec = Executors.newSingleThreadScheduledExecutor(runnable -> MessageTrendsScheduler.named("MT-Purge", runnable));
    private final MinuteFlushRunner flushRunner;
    private final RollupRunner rollupRunner;
    private final PurgeRunner purgeRunner;
    private ScheduledFuture<?> flushTask;
    private ScheduledFuture<?> rollupTask;
    private ScheduledFuture<?> purgeTask;

    public MessageTrendsScheduler(MinuteFlushRunner minuteFlushRunner, RollupRunner rollupRunner, PurgeRunner purgeRunner) {
        this.flushRunner = minuteFlushRunner;
        this.rollupRunner = rollupRunner;
        this.purgeRunner = purgeRunner;
    }

    public synchronized void start() {
        MessageTrendsBuffer.getInstance().setEnabled(true);
        this.scheduleFlush();
        this.scheduleRollups();
        this.schedulePurge();
        logger.info("MessageTrendsScheduler started. tasks: flush={}, rollup={}, purge={}", (Object)(this.flushTask != null ? 1 : 0), (Object)(this.rollupTask != null ? 1 : 0), (Object)(this.purgeTask != null ? 1 : 0));
    }

    public synchronized void stop() {
        MessageTrendsBuffer.getInstance().setEnabled(false);
        MessageTrendsScheduler.cancel(this.flushTask);
        MessageTrendsScheduler.cancel(this.rollupTask);
        MessageTrendsScheduler.cancel(this.purgeTask);
        MessageTrendsScheduler.safeShutdown(this.flushExec);
        MessageTrendsScheduler.safeShutdown(this.rollupExec);
        MessageTrendsScheduler.safeShutdown(this.purgeExec);
        logger.info("MessageTrendsScheduler stopped.");
    }

    private void scheduleFlush() {
        long l = this.flushRunner.initialDelaySecondsToNextMinuteBoundary();
        this.flushTask = this.flushExec.scheduleAtFixedRate(this.flushRunner::runOnce, l, this.flushRunner.getFixedRateSeconds(), TimeUnit.SECONDS);
    }

    private void scheduleRollups() {
        long l = this.rollupRunner.initialDelaySeconds();
        long l2 = this.rollupRunner.fixedRateSeconds();
        logger.debug("Scheduling rollups: initialDelay={}s, period={}s", (Object)l, (Object)l2);
        if (l < 0L || l2 <= 0L) {
            logger.error("Invalid rollup schedule: initialDelay={}, period={}", (Object)l, (Object)l2);
            return;
        }
        this.rollupTask = this.rollupExec.scheduleAtFixedRate(this.rollupRunner::runOnce, this.rollupRunner.initialDelaySeconds(), this.rollupRunner.fixedRateSeconds(), TimeUnit.SECONDS);
    }

    private void schedulePurge() {
        this.purgeTask = this.purgeExec.scheduleAtFixedRate(this.purgeRunner::runOnce, this.purgeRunner.initialDelaySeconds(), this.purgeRunner.fixedRateSeconds(), TimeUnit.SECONDS);
    }

    private static Thread named(String string, Runnable runnable) {
        Thread thread = new Thread(runnable, string);
        thread.setDaemon(true);
        return thread;
    }

    private static void cancel(ScheduledFuture<?> scheduledFuture) {
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
    }

    private static void safeShutdown(ExecutorService executorService) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

