/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.server.maintenance;

import com.mirth.connect.plugins.messagetrends.server.maintenance.MessageTrendsConfig;
import com.mirth.connect.plugins.messagetrends.server.maintenance.MessageTrendsScheduler;
import com.mirth.connect.plugins.messagetrends.server.maintenance.MinuteFlushRunner;
import com.mirth.connect.plugins.messagetrends.server.maintenance.PurgeRunner;
import com.mirth.connect.plugins.messagetrends.server.maintenance.RollupRunner;
import com.mirth.connect.plugins.messagetrends.server.service.MessageTrendsService;
import java.util.Objects;

public final class MessageTrendsSchedulerFactory {
    private MessageTrendsSchedulerFactory() {
    }

    public static MessageTrendsScheduler build(MessageTrendsService messageTrendsService, String string) {
        return MessageTrendsSchedulerFactory.build(messageTrendsService, string, MessageTrendsConfig.defaultConfig());
    }

    public static MessageTrendsScheduler build(MessageTrendsService messageTrendsService, String string, MessageTrendsConfig messageTrendsConfig) {
        Objects.requireNonNull(messageTrendsService, "service");
        Objects.requireNonNull(messageTrendsConfig, "config");
        MinuteFlushRunner minuteFlushRunner = new MinuteFlushRunner(messageTrendsService, messageTrendsConfig.getClock(), string);
        RollupRunner rollupRunner = new RollupRunner(messageTrendsService, messageTrendsConfig.getClock(), messageTrendsConfig.getRollupFixedRateSeconds(), string);
        PurgeRunner purgeRunner = new PurgeRunner(messageTrendsService, messageTrendsConfig.getClock(), messageTrendsConfig.getRetentionByBucket(), messageTrendsConfig.getPurgeFixedRateSeconds(), messageTrendsConfig.getPurgeThrottleMs());
        return new MessageTrendsScheduler(minuteFlushRunner, rollupRunner, purgeRunner);
    }

    public static MessageTrendsScheduler buildAndStart(MessageTrendsService messageTrendsService, String string, MessageTrendsConfig messageTrendsConfig) {
        MessageTrendsScheduler messageTrendsScheduler = MessageTrendsSchedulerFactory.build(messageTrendsService, string, messageTrendsConfig);
        messageTrendsScheduler.start();
        return messageTrendsScheduler;
    }
}

