/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.server.plugin;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.client.core.api.util.OperationUtil;
import com.mirth.connect.model.ExtensionPermission;
import com.mirth.connect.plugins.MergePropertiesInterface;
import com.mirth.connect.plugins.ServicePlugin;
import com.mirth.connect.plugins.messagetrends.server.controller.MessageTrendsController;
import com.mirth.connect.plugins.messagetrends.server.exception.MessageTrendsException;
import com.mirth.connect.plugins.messagetrends.shared.interfaces.MessageTrendsServletInterface;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageTrendsServicePlugin
implements ServicePlugin,
MergePropertiesInterface {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final MessageTrendsController messageTrendsController = MessageTrendsController.getInstance();

    public void init(Properties properties) {
        try {
            this.messageTrendsController.init(properties);
        }
        catch (MessageTrendsException messageTrendsException) {
            this.logger.error("Failed to initialize Message Trends Management System plugin", (Throwable)messageTrendsException);
        }
    }

    public void update(Properties properties) {
        try {
            this.messageTrendsController.update(properties);
        }
        catch (MessageTrendsException messageTrendsException) {
            this.logger.error("Failed to update Message Trends Management System plugin", (Throwable)messageTrendsException);
        }
    }

    public void start() {
        try {
            this.messageTrendsController.start();
        }
        catch (MessageTrendsException messageTrendsException) {
            this.logger.error("Failed to start Message Trends Management System plugin", (Throwable)messageTrendsException);
        }
    }

    public void stop() {
        try {
            this.messageTrendsController.stop();
        }
        catch (MessageTrendsException messageTrendsException) {
            this.logger.error("Failed to stop Message Trends Management System plugin", (Throwable)messageTrendsException);
        }
    }

    public Properties getDefaultProperties() {
        return new Properties();
    }

    public ExtensionPermission[] getExtensionPermissions() {
        ExtensionPermission extensionPermission = new ExtensionPermission("Message Trends Management System", "Access Message Trends", "Allows to accessing Message Trends", OperationUtil.getOperationNamesForPermission((String)"Access Message Trends", MessageTrendsServletInterface.class, (String[])new String[0]), new String[0]);
        return new ExtensionPermission[]{extensionPermission};
    }

    public String getPluginPointName() {
        return "Message Trends Management System";
    }

    public void modifyPropertiesOnRestore(Properties properties) throws ControllerException {
        this.messageTrendsController.onRestoreTriggered();
    }
}

