/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.ForwardOnlyResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class OracleReturnResultSet
extends ForwardOnlyResultSet {
    OracleReturnResultSet(PhysicalConnection physicalConnection, OracleStatement oracleStatement) throws SQLException {
        super(physicalConnection, oracleStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            super.close();
            this.statement.currentResultSet = null;
            this.statement.returnParamsFetched = false;
            this.statement.rowsDmlReturned = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            if (!this.statement.isAutoGeneratedKey) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
            }
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10).fillInStackTrace();
            }
            if (this.statement.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            AutoKeyInfo autoKeyInfo = this.statement.autoKeyInfo;
            autoKeyInfo.statement = this.statement;
            autoKeyInfo.connection = this.connection;
            autoKeyInfo.initMetaData(this);
            return autoKeyInfo;
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
        }
    }
}

