/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.dimse;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.connectors.dimse.DICOMReceiverProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class DICOMListener
extends ConnectorSettingsPanel {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private boolean tlsComponentsEnabled = true;
    private JLabel acceptSSLv2Label;
    private MirthRadioButton acceptSSLv2NoRadio;
    private MirthRadioButton acceptSSLv2YesRadio;
    private MirthTextField applicationEntityField;
    private MirthTextField asyncField;
    private MirthRadioButton bigendianNo;
    private MirthRadioButton bigendianYes;
    private MirthTextField bufsizeField;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private ButtonGroup buttonGroup5;
    private ButtonGroup buttonGroup6;
    private ButtonGroup buttonGroup7;
    private ButtonGroup buttonGroup8;
    private JLabel clientAuthenticationLabel;
    private MirthRadioButton clientAuthenticationNoRadio;
    private MirthRadioButton clientAuthenticationYesRadio;
    private MirthRadioButton deftsNo;
    private MirthRadioButton deftsYes;
    private MirthTextField destField;
    private MirthTextField idletoField;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel31;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private MirthTextField keyPasswordField;
    private JLabel keyPasswordLabel;
    private MirthTextField keyStoreField;
    private JLabel keyStoreLabel;
    private MirthTextField keyStorePasswordField;
    private JLabel keyStorePasswordLabel;
    private MirthRadioButton nativeNo;
    private MirthRadioButton nativeYes;
    private MirthRadioButton pdv1No;
    private MirthRadioButton pdv1Yes;
    private MirthTextField rcvpdulenField;
    private MirthTextField reaperField;
    private MirthTextField releasetoField;
    private MirthTextField requesttoField;
    private MirthTextField rspdelayField;
    private MirthTextField sndpdulenField;
    private MirthTextField soclosedelayField;
    private MirthTextField sorcvbufField;
    private MirthTextField sosndbufField;
    private MirthRadioButton tcpdelayNo;
    private MirthRadioButton tcpdelayYes;
    private MirthRadioButton tls3DESRadio;
    private MirthRadioButton tlsAESRadio;
    private JLabel tlsLabel;
    private MirthRadioButton tlsNoRadio;
    private MirthRadioButton tlsWithoutRadio;
    private MirthTextField trustStoreField;
    private JLabel trustStoreLabel;
    private MirthTextField trustStorePasswordField;
    private JLabel trustStorePasswordLabel;

    public DICOMListener() {
        this.initComponents();
    }

    public String getConnectorName() {
        return new DICOMReceiverProperties().getName();
    }

    public ConnectorProperties getProperties() {
        DICOMReceiverProperties properties = new DICOMReceiverProperties();
        properties.setAsync(this.asyncField.getText());
        properties.setBufSize(this.bufsizeField.getText());
        properties.setPdv1(this.pdv1Yes.isSelected());
        properties.setBigEndian(this.bigendianYes.isSelected());
        properties.setDefts(this.deftsYes.isSelected());
        properties.setNativeData(this.nativeYes.isSelected());
        properties.setDest(this.destField.getText());
        properties.setRcvpdulen(this.rcvpdulenField.getText());
        properties.setSndpdulen(this.sndpdulenField.getText());
        properties.setReaper(this.reaperField.getText());
        properties.setReleaseTo(this.releasetoField.getText());
        properties.setRequestTo(this.requesttoField.getText());
        properties.setRspDelay(this.rspdelayField.getText());
        properties.setIdleTo(this.idletoField.getText());
        properties.setSoCloseDelay(this.soclosedelayField.getText());
        properties.setSorcvbuf(this.sorcvbufField.getText());
        properties.setSosndbuf(this.sosndbufField.getText());
        properties.setTcpDelay(this.tcpdelayYes.isSelected());
        properties.setKeyPW(this.keyPasswordField.getText());
        properties.setKeyStore(this.keyStoreField.getText());
        properties.setKeyStorePW(this.keyStorePasswordField.getText());
        properties.setNoClientAuth(this.clientAuthenticationYesRadio.isSelected());
        properties.setNossl2(this.acceptSSLv2YesRadio.isSelected());
        if (this.tlsAESRadio.isSelected()) {
            properties.setTls("aes");
        } else if (this.tls3DESRadio.isSelected()) {
            properties.setTls("3des");
        } else if (this.tlsWithoutRadio.isSelected()) {
            properties.setTls("without");
        } else {
            properties.setTls("notls");
        }
        properties.setTrustStore(this.trustStoreField.getText());
        properties.setTrustStorePW(this.trustStorePasswordField.getText());
        properties.setApplicationEntity(this.applicationEntityField.getText());
        return properties;
    }

    public void setProperties(ConnectorProperties properties) {
        DICOMReceiverProperties props = (DICOMReceiverProperties)properties;
        this.asyncField.setText(props.getAsync());
        this.bufsizeField.setText(props.getBufSize());
        this.rcvpdulenField.setText(props.getRcvpdulen());
        this.reaperField.setText(props.getReaper());
        this.releasetoField.setText(props.getReleaseTo());
        this.requesttoField.setText(props.getRequestTo());
        this.idletoField.setText(props.getIdleTo());
        this.rspdelayField.setText(props.getRspDelay());
        this.sndpdulenField.setText(props.getSndpdulen());
        this.soclosedelayField.setText(props.getSoCloseDelay());
        this.sorcvbufField.setText(props.getSorcvbuf());
        this.sosndbufField.setText(props.getSosndbuf());
        this.destField.setText(props.getDest());
        if (props.isPdv1()) {
            this.pdv1Yes.setSelected(true);
        } else {
            this.pdv1No.setSelected(true);
        }
        if (props.isBigEndian()) {
            this.bigendianYes.setSelected(true);
            this.bigendianYesActionPerformed(null);
        } else {
            this.bigendianNo.setSelected(true);
            this.bigendianNoActionPerformed(null);
        }
        if (props.isDefts()) {
            this.deftsYes.setSelected(true);
            this.deftsYesActionPerformed(null);
        } else {
            this.deftsNo.setSelected(true);
            this.deftsNoActionPerformed(null);
        }
        if (props.isNativeData()) {
            this.nativeYes.setSelected(true);
            this.nativeYesActionPerformed(null);
        } else {
            this.nativeNo.setSelected(true);
            this.nativeNoActionPerformed(null);
        }
        if (props.isTcpDelay()) {
            this.tcpdelayYes.setSelected(true);
        } else {
            this.tcpdelayNo.setSelected(true);
        }
        this.keyPasswordField.setText(props.getKeyPW());
        this.keyStoreField.setText(props.getKeyStore());
        this.keyStorePasswordField.setText(props.getKeyStorePW());
        this.trustStoreField.setText(props.getTrustStore());
        this.trustStorePasswordField.setText(props.getTrustStorePW());
        if (props.isNoClientAuth()) {
            this.clientAuthenticationYesRadio.setSelected(true);
        } else {
            this.clientAuthenticationNoRadio.setSelected(true);
        }
        if (props.isNossl2()) {
            this.acceptSSLv2YesRadio.setSelected(true);
        } else {
            this.acceptSSLv2NoRadio.setSelected(true);
        }
        if (props.getTls().equals("aes")) {
            this.tlsAESRadio.setSelected(true);
            this.tlsAESRadioActionPerformed(null);
        } else if (props.getTls().equals("3des")) {
            this.tls3DESRadio.setSelected(true);
            this.tls3DESRadioActionPerformed(null);
        } else if (props.getTls().equals("without")) {
            this.tlsWithoutRadio.setSelected(true);
            this.tlsWithoutRadioActionPerformed(null);
        } else {
            this.tlsNoRadio.setSelected(true);
            this.tlsNoRadioActionPerformed(null);
        }
        this.applicationEntityField.setText(props.getApplicationEntity());
    }

    public ConnectorProperties getDefaults() {
        return new DICOMReceiverProperties();
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        DICOMReceiverProperties props = (DICOMReceiverProperties)properties;
        boolean valid = true;
        return valid;
    }

    public void resetInvalidProperties() {
    }

    public void enableTLSComponents() {
        this.tlsComponentsEnabled = true;
        this.tlsLabel.setEnabled(true);
        this.tls3DESRadio.setEnabled(true);
        this.tlsAESRadio.setEnabled(true);
        this.tlsWithoutRadio.setEnabled(true);
        this.tlsNoRadio.setEnabled(true);
        if (this.tls3DESRadio.isSelected()) {
            this.tls3DESRadioActionPerformed(null);
        } else if (this.tlsAESRadio.isSelected()) {
            this.tlsAESRadioActionPerformed(null);
        } else if (this.tlsWithoutRadio.isSelected()) {
            this.tlsWithoutRadioActionPerformed(null);
        } else {
            this.tlsNoRadioActionPerformed(null);
        }
    }

    public void disableTLSComponents() {
        this.tlsComponentsEnabled = false;
        this.tlsLabel.setEnabled(false);
        this.tls3DESRadio.setEnabled(false);
        this.tlsAESRadio.setEnabled(false);
        this.tlsWithoutRadio.setEnabled(false);
        this.tlsNoRadio.setEnabled(false);
        this.tlsNoRadioActionPerformed(null);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.buttonGroup5 = new ButtonGroup();
        this.buttonGroup6 = new ButtonGroup();
        this.buttonGroup7 = new ButtonGroup();
        this.buttonGroup8 = new ButtonGroup();
        this.jLabel5 = new JLabel();
        this.asyncField = new MirthTextField();
        this.jLabel17 = new JLabel();
        this.pdv1Yes = new MirthRadioButton();
        this.pdv1No = new MirthRadioButton();
        this.jLabel18 = new JLabel();
        this.reaperField = new MirthTextField();
        this.jLabel19 = new JLabel();
        this.releasetoField = new MirthTextField();
        this.jLabel23 = new JLabel();
        this.soclosedelayField = new MirthTextField();
        this.jLabel22 = new JLabel();
        this.jLabel16 = new JLabel();
        this.sndpdulenField = new MirthTextField();
        this.rcvpdulenField = new MirthTextField();
        this.jLabel6 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jLabel24 = new JLabel();
        this.sorcvbufField = new MirthTextField();
        this.sosndbufField = new MirthTextField();
        this.bufsizeField = new MirthTextField();
        this.jLabel27 = new JLabel();
        this.tcpdelayYes = new MirthRadioButton();
        this.tcpdelayNo = new MirthRadioButton();
        this.jLabel20 = new JLabel();
        this.requesttoField = new MirthTextField();
        this.jLabel21 = new JLabel();
        this.idletoField = new MirthTextField();
        this.jLabel26 = new JLabel();
        this.rspdelayField = new MirthTextField();
        this.jLabel28 = new JLabel();
        this.bigendianYes = new MirthRadioButton();
        this.bigendianNo = new MirthRadioButton();
        this.jLabel29 = new JLabel();
        this.deftsYes = new MirthRadioButton();
        this.deftsNo = new MirthRadioButton();
        this.jLabel30 = new JLabel();
        this.destField = new MirthTextField();
        this.jLabel31 = new JLabel();
        this.nativeYes = new MirthRadioButton();
        this.nativeNo = new MirthRadioButton();
        this.tlsLabel = new JLabel();
        this.tls3DESRadio = new MirthRadioButton();
        this.tlsAESRadio = new MirthRadioButton();
        this.tlsWithoutRadio = new MirthRadioButton();
        this.tlsNoRadio = new MirthRadioButton();
        this.clientAuthenticationLabel = new JLabel();
        this.clientAuthenticationYesRadio = new MirthRadioButton();
        this.clientAuthenticationNoRadio = new MirthRadioButton();
        this.acceptSSLv2Label = new JLabel();
        this.acceptSSLv2YesRadio = new MirthRadioButton();
        this.acceptSSLv2NoRadio = new MirthRadioButton();
        this.keyStoreLabel = new JLabel();
        this.keyStoreField = new MirthTextField();
        this.trustStoreLabel = new JLabel();
        this.trustStoreField = new MirthTextField();
        this.keyStorePasswordLabel = new JLabel();
        this.keyStorePasswordField = new MirthTextField();
        this.trustStorePasswordLabel = new JLabel();
        this.trustStorePasswordField = new MirthTextField();
        this.keyPasswordLabel = new JLabel();
        this.keyPasswordField = new MirthTextField();
        this.applicationEntityField = new MirthTextField();
        this.jLabel3 = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setToolTipText("");
        this.jLabel5.setText("Max Async operations:");
        this.asyncField.setToolTipText("Maximum number of outstanding operations performed asynchronously, unlimited by default.");
        this.jLabel17.setText("Pack PDV:");
        this.pdv1Yes.setBackground(new Color(255, 255, 255));
        this.pdv1Yes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup5.add((AbstractButton)this.pdv1Yes);
        this.pdv1Yes.setText("Yes");
        this.pdv1Yes.setToolTipText("Send only one PDV in one P-Data-TF PDU, pack command and data PDV in one P-DATA-TF PDU by default.");
        this.pdv1Yes.setMargin(new Insets(0, 0, 0, 0));
        this.pdv1No.setBackground(new Color(255, 255, 255));
        this.pdv1No.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup5.add((AbstractButton)this.pdv1No);
        this.pdv1No.setSelected(true);
        this.pdv1No.setText("No");
        this.pdv1No.setToolTipText("Send only one PDV in one P-Data-TF PDU, pack command and data PDV in one P-DATA-TF PDU by default.");
        this.pdv1No.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel18.setText("DIMSE-RSP interval period (s):");
        this.reaperField.setToolTipText("Period in ms to check for outstanding DIMSE-RSP, 10s by default");
        this.jLabel19.setText("A-RELEASE-RP timeout (s):");
        this.releasetoField.setToolTipText("Timeout in ms for receiving A-RELEASE-RP, 5s by default.");
        this.jLabel23.setText("Socket Close Delay After A-ABORT (ms):");
        this.soclosedelayField.setToolTipText("Delay in ms for Socket close after sending A-ABORT, 50ms by default.");
        this.jLabel22.setText("Receive Socket Buffer Size (KB):");
        this.jLabel16.setText("P-DATA-TF PDUs max length sent (KB):");
        this.sndpdulenField.setToolTipText("Maximal length in KB of sent P-DATA-TF PDUs, 16KB by default.");
        this.rcvpdulenField.setToolTipText("Maximal length in KB of received P-DATA-TF PDUs, 16KB by default.");
        this.jLabel6.setText("Transcoder Buffer Size (KB):");
        this.jLabel25.setText("Send Socket Buffer Size (KB):");
        this.jLabel24.setText("P-DATA-TF PDUs max length received (KB):");
        this.sorcvbufField.setToolTipText("Set receive socket buffer to specified value in KB");
        this.sosndbufField.setToolTipText("Set send socket buffer to specified value in KB");
        this.bufsizeField.setToolTipText("Minimal buffer size to write received object to file, 1KB by default.");
        this.jLabel27.setText("TCP Delay:");
        this.tcpdelayYes.setBackground(new Color(255, 255, 255));
        this.tcpdelayYes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup1.add((AbstractButton)this.tcpdelayYes);
        this.tcpdelayYes.setSelected(true);
        this.tcpdelayYes.setText("Yes");
        this.tcpdelayYes.setToolTipText("Set TCP_NODELAY socket option to false, true by default.");
        this.tcpdelayYes.setMargin(new Insets(0, 0, 0, 0));
        this.tcpdelayNo.setBackground(new Color(255, 255, 255));
        this.tcpdelayNo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup1.add((AbstractButton)this.tcpdelayNo);
        this.tcpdelayNo.setText("No");
        this.tcpdelayNo.setToolTipText("Set TCP_NODELAY socket option to false, true by default.");
        this.tcpdelayNo.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel20.setText("ASSOCIATE-RQ timeout (ms):");
        this.requesttoField.setToolTipText("Timeout in ms for receiving -ASSOCIATE-RQ, 5s by default.");
        this.jLabel21.setText("DIMSE-RQ timeout (ms):");
        this.idletoField.setToolTipText("Timeout in ms for receiving DIMSE-RQ, 60s by default.");
        this.jLabel26.setText("DIMSE-RSP delay (ms):");
        this.rspdelayField.setToolTipText("Delay in ms for DIMSE-RSP; useful for testing asynchronous mode.");
        this.jLabel28.setText("Accept Explict VR Big Endian:");
        this.bigendianYes.setBackground(new Color(255, 255, 255));
        this.bigendianYes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup4.add((AbstractButton)this.bigendianYes);
        this.bigendianYes.setText("Yes");
        this.bigendianYes.setToolTipText("Accept also Explict VR Big Endian transfer syntax.");
        this.bigendianYes.setMargin(new Insets(0, 0, 0, 0));
        this.bigendianYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DICOMListener.this.bigendianYesActionPerformed(evt);
            }
        });
        this.bigendianNo.setBackground(new Color(255, 255, 255));
        this.bigendianNo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup4.add((AbstractButton)this.bigendianNo);
        this.bigendianNo.setSelected(true);
        this.bigendianNo.setText("No");
        this.bigendianNo.setToolTipText("Accept also Explict VR Big Endian transfer syntax.");
        this.bigendianNo.setMargin(new Insets(0, 0, 0, 0));
        this.bigendianNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DICOMListener.this.bigendianNoActionPerformed(evt);
            }
        });
        this.jLabel29.setText("Only Accept Default Transfer Syntax:");
        this.deftsYes.setBackground(new Color(255, 255, 255));
        this.deftsYes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup3.add((AbstractButton)this.deftsYes);
        this.deftsYes.setText("Yes");
        this.deftsYes.setToolTipText("Accept only default transfer syntax.");
        this.deftsYes.setMargin(new Insets(0, 0, 0, 0));
        this.deftsYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DICOMListener.this.deftsYesActionPerformed(evt);
            }
        });
        this.deftsNo.setBackground(new Color(255, 255, 255));
        this.deftsNo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup3.add((AbstractButton)this.deftsNo);
        this.deftsNo.setSelected(true);
        this.deftsNo.setText("No");
        this.deftsNo.setToolTipText("Accept only default transfer syntax.");
        this.deftsNo.setMargin(new Insets(0, 0, 0, 0));
        this.deftsNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DICOMListener.this.deftsNoActionPerformed(evt);
            }
        });
        this.jLabel30.setText("Store Recieved Objects in Directory:");
        this.destField.setToolTipText("Store received objects into files in specified directory <dir>. Do not store received objects by default.");
        this.jLabel31.setText("Only Uncompressed Pixel Data:");
        this.nativeYes.setBackground(new Color(255, 255, 255));
        this.nativeYes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup2.add((AbstractButton)this.nativeYes);
        this.nativeYes.setText("Yes");
        this.nativeYes.setToolTipText("Accept only transfer syntax with uncompressed pixel data.");
        this.nativeYes.setMargin(new Insets(0, 0, 0, 0));
        this.nativeYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DICOMListener.this.nativeYesActionPerformed(evt);
            }
        });
        this.nativeNo.setBackground(new Color(255, 255, 255));
        this.nativeNo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup2.add((AbstractButton)this.nativeNo);
        this.nativeNo.setSelected(true);
        this.nativeNo.setText("No");
        this.nativeNo.setToolTipText("Accept only transfer syntax with uncompressed pixel data.");
        this.nativeNo.setMargin(new Insets(0, 0, 0, 0));
        this.nativeNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DICOMListener.this.nativeNoActionPerformed(evt);
            }
        });
        this.tlsLabel.setText("TLS:");
        this.tls3DESRadio.setBackground(new Color(255, 255, 255));
        this.tls3DESRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup6.add((AbstractButton)this.tls3DESRadio);
        this.tls3DESRadio.setText("3DES");
        this.tls3DESRadio.setToolTipText("Enable TLS connection without, 3DES or AES encryption.");
        this.tls3DESRadio.setMargin(new Insets(0, 0, 0, 0));
        this.tls3DESRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DICOMListener.this.tls3DESRadioActionPerformed(evt);
            }
        });
        this.tlsAESRadio.setBackground(new Color(255, 255, 255));
        this.tlsAESRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup6.add((AbstractButton)this.tlsAESRadio);
        this.tlsAESRadio.setText("AES");
        this.tlsAESRadio.setToolTipText("Enable TLS connection without, 3DES or AES encryption.");
        this.tlsAESRadio.setMargin(new Insets(0, 0, 0, 0));
        this.tlsAESRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DICOMListener.this.tlsAESRadioActionPerformed(evt);
            }
        });
        this.tlsWithoutRadio.setBackground(new Color(255, 255, 255));
        this.tlsWithoutRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup6.add((AbstractButton)this.tlsWithoutRadio);
        this.tlsWithoutRadio.setText("Without");
        this.tlsWithoutRadio.setToolTipText("Enable TLS connection without, 3DES or AES encryption.");
        this.tlsWithoutRadio.setMargin(new Insets(0, 0, 0, 0));
        this.tlsWithoutRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DICOMListener.this.tlsWithoutRadioActionPerformed(evt);
            }
        });
        this.tlsNoRadio.setBackground(new Color(255, 255, 255));
        this.tlsNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup6.add((AbstractButton)this.tlsNoRadio);
        this.tlsNoRadio.setSelected(true);
        this.tlsNoRadio.setText("No TLS");
        this.tlsNoRadio.setToolTipText("Enable TLS connection without, 3DES or AES encryption.");
        this.tlsNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.tlsNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DICOMListener.this.tlsNoRadioActionPerformed(evt);
            }
        });
        this.clientAuthenticationLabel.setText("Client Authentication TLS:");
        this.clientAuthenticationYesRadio.setBackground(new Color(255, 255, 255));
        this.clientAuthenticationYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup7.add((AbstractButton)this.clientAuthenticationYesRadio);
        this.clientAuthenticationYesRadio.setSelected(true);
        this.clientAuthenticationYesRadio.setText("Yes");
        this.clientAuthenticationYesRadio.setToolTipText("Enable client authentification for TLS.");
        this.clientAuthenticationYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.clientAuthenticationNoRadio.setBackground(new Color(255, 255, 255));
        this.clientAuthenticationNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup7.add((AbstractButton)this.clientAuthenticationNoRadio);
        this.clientAuthenticationNoRadio.setText("No");
        this.clientAuthenticationNoRadio.setToolTipText("Enable client authentification for TLS.");
        this.clientAuthenticationNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.acceptSSLv2Label.setText("Accept ssl v2 TLS handshake:");
        this.acceptSSLv2YesRadio.setBackground(new Color(255, 255, 255));
        this.acceptSSLv2YesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup8.add((AbstractButton)this.acceptSSLv2YesRadio);
        this.acceptSSLv2YesRadio.setSelected(true);
        this.acceptSSLv2YesRadio.setText("Yes");
        this.acceptSSLv2YesRadio.setToolTipText("Enable acceptance of SSLv2Hello TLS handshake.");
        this.acceptSSLv2YesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.acceptSSLv2NoRadio.setBackground(new Color(255, 255, 255));
        this.acceptSSLv2NoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup8.add((AbstractButton)this.acceptSSLv2NoRadio);
        this.acceptSSLv2NoRadio.setText("No");
        this.acceptSSLv2NoRadio.setToolTipText("Enable acceptance of SSLv2Hello TLS handshake.");
        this.acceptSSLv2NoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.keyStoreLabel.setText("Keystore:");
        this.keyStoreField.setToolTipText("File path or URL of P12 or JKS keystore, resource:tls/test_sys_2.p12 by default.");
        this.trustStoreLabel.setText("Trust Store:");
        this.trustStoreField.setToolTipText("File path or URL of JKS truststore, resource:tls/mesa_certs.jks by default.");
        this.keyStorePasswordLabel.setText("Keystore Password:");
        this.keyStorePasswordField.setToolTipText("Password for keystore file.");
        this.trustStorePasswordLabel.setText("Trust Store Password:");
        this.trustStorePasswordField.setToolTipText("Password for truststore file.");
        this.keyPasswordLabel.setText("Key Password:");
        this.keyPasswordField.setToolTipText("Password for accessing the key in the keystore.");
        this.applicationEntityField.setToolTipText("If specified, only requests with a matching called AE title will be accepted");
        this.jLabel3.setText("Application Entity:");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.keyPasswordLabel).addComponent(this.acceptSSLv2Label).addComponent(this.jLabel28).addComponent(this.jLabel29).addComponent(this.jLabel31).addComponent(this.jLabel27).addComponent(this.jLabel30).addComponent(this.jLabel5).addComponent(this.jLabel17).addComponent(this.tlsLabel).addComponent(this.clientAuthenticationLabel).addComponent(this.keyStoreLabel).addComponent(this.trustStoreLabel).addComponent(this.jLabel18).addComponent(this.jLabel19).addComponent(this.jLabel23).addComponent(this.jLabel20).addComponent(this.jLabel21).addComponent(this.jLabel26)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.nativeYes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.nativeNo, -2, -1, -2)).addComponent((Component)this.rspdelayField, -2, 50, -2).addComponent((Component)this.asyncField, -2, 50, -2).addGroup(layout.createSequentialGroup().addComponent((Component)this.pdv1Yes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.pdv1No, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent((Component)this.clientAuthenticationYesRadio, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.clientAuthenticationNoRadio, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent((Component)this.acceptSSLv2YesRadio, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.acceptSSLv2NoRadio, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent((Component)this.tcpdelayYes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.tcpdelayNo, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent((Component)this.bigendianYes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.bigendianNo, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent((Component)this.deftsYes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.deftsNo, -2, -1, -2)).addComponent((Component)this.destField, -2, 103, -2).addComponent((Component)this.applicationEntityField, -2, 50, -2).addComponent((Component)this.keyPasswordField, -2, 150, -2).addGroup(layout.createSequentialGroup().addComponent((Component)this.tls3DESRadio, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.tlsAESRadio, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.tlsWithoutRadio, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.tlsNoRadio, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.reaperField, -2, 50, -2).addComponent((Component)this.soclosedelayField, -2, 50, -2).addComponent((Component)this.requesttoField, -2, 50, -2).addComponent((Component)this.idletoField, -2, 50, -2).addComponent((Component)this.releasetoField, -2, 50, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel22).addComponent(this.jLabel6).addComponent(this.jLabel25).addComponent(this.jLabel24).addComponent(this.jLabel16)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.bufsizeField, -2, 50, -2).addComponent((Component)this.sorcvbufField, -2, 50, -2).addComponent((Component)this.sosndbufField, -2, 50, -2).addComponent((Component)this.rcvpdulenField, -2, 50, -2).addComponent((Component)this.sndpdulenField, -2, 50, -2))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.trustStoreField, -2, 150, -2).addComponent((Component)this.keyStoreField, -2, 150, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.keyStorePasswordLabel).addComponent(this.trustStorePasswordLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.trustStorePasswordField, -2, 75, -2).addComponent((Component)this.keyStorePasswordField, -2, 75, -2)))).addContainerGap(36, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, 16, -2).addComponent((Component)this.applicationEntityField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent((Component)this.asyncField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.pdv1Yes, -2, -1, -2).addComponent(this.jLabel17).addComponent((Component)this.pdv1No, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.reaperField, -2, -1, -2).addComponent(this.jLabel18)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.releasetoField, -2, -1, -2).addComponent(this.jLabel19)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.soclosedelayField, -2, 17, -2).addComponent(this.jLabel23)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.requesttoField, -2, -1, -2).addComponent(this.jLabel20)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.idletoField, -2, -1, -2).addComponent(this.jLabel21)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.rspdelayField, -2, -1, -2).addComponent(this.jLabel26))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.sndpdulenField, -2, -1, -2).addComponent(this.jLabel16)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.rcvpdulenField, -2, -1, -2).addComponent(this.jLabel24)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.sosndbufField, -2, -1, -2).addComponent(this.jLabel25)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.sorcvbufField, -2, -1, -2).addComponent(this.jLabel22)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent((Component)this.bufsizeField, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel28).addComponent((Component)this.bigendianYes, -2, 15, -2).addComponent((Component)this.bigendianNo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.deftsYes, -2, 15, -2).addComponent(this.jLabel29).addComponent((Component)this.deftsNo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.nativeNo, -2, -1, -2).addComponent((Component)this.nativeYes, -2, 15, -2).addComponent(this.jLabel31)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.tcpdelayYes, -2, 15, -2).addComponent(this.jLabel27).addComponent((Component)this.tcpdelayNo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel30).addComponent((Component)this.destField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tlsLabel).addComponent((Component)this.tls3DESRadio, -2, -1, -2).addComponent((Component)this.tlsAESRadio, -2, -1, -2).addComponent((Component)this.tlsWithoutRadio, -2, -1, -2).addComponent((Component)this.tlsNoRadio, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clientAuthenticationLabel).addComponent((Component)this.clientAuthenticationYesRadio, -2, -1, -2).addComponent((Component)this.clientAuthenticationNoRadio, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.acceptSSLv2Label).addComponent((Component)this.acceptSSLv2YesRadio, -2, -1, -2).addComponent((Component)this.acceptSSLv2NoRadio, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyStoreLabel).addComponent((Component)this.keyStoreField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.trustStoreLabel).addComponent((Component)this.trustStoreField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyPasswordLabel).addComponent((Component)this.keyPasswordField, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGap(48, 48, 48).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyStorePasswordLabel).addComponent((Component)this.keyStorePasswordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.trustStorePasswordLabel).addComponent((Component)this.trustStorePasswordField, -2, -1, -2)))).addGap(0, 106, Short.MAX_VALUE)));
    }

    private void tlsNoRadioActionPerformed(ActionEvent evt) {
        this.clientAuthenticationLabel.setEnabled(false);
        this.clientAuthenticationYesRadio.setEnabled(false);
        this.clientAuthenticationNoRadio.setEnabled(false);
        this.acceptSSLv2Label.setEnabled(false);
        this.acceptSSLv2YesRadio.setEnabled(false);
        this.acceptSSLv2NoRadio.setEnabled(false);
        this.keyStoreLabel.setEnabled(false);
        this.keyStoreField.setEnabled(false);
        this.keyStorePasswordLabel.setEnabled(false);
        this.keyStorePasswordField.setEnabled(false);
        this.trustStoreLabel.setEnabled(false);
        this.trustStoreField.setEnabled(false);
        this.trustStorePasswordLabel.setEnabled(false);
        this.trustStorePasswordField.setEnabled(false);
        this.keyPasswordLabel.setEnabled(false);
        this.keyPasswordField.setEnabled(false);
    }

    private void tlsWithoutRadioActionPerformed(ActionEvent evt) {
        if (!this.tlsComponentsEnabled) {
            return;
        }
        this.clientAuthenticationLabel.setEnabled(true);
        this.clientAuthenticationYesRadio.setEnabled(true);
        this.clientAuthenticationNoRadio.setEnabled(true);
        this.acceptSSLv2Label.setEnabled(true);
        this.acceptSSLv2YesRadio.setEnabled(true);
        this.acceptSSLv2NoRadio.setEnabled(true);
        this.keyStoreLabel.setEnabled(true);
        this.keyStoreField.setEnabled(true);
        this.keyStorePasswordLabel.setEnabled(true);
        this.keyStorePasswordField.setEnabled(true);
        this.trustStoreLabel.setEnabled(true);
        this.trustStoreField.setEnabled(true);
        this.trustStorePasswordLabel.setEnabled(true);
        this.trustStorePasswordField.setEnabled(true);
        this.keyPasswordLabel.setEnabled(true);
        this.keyPasswordField.setEnabled(true);
    }

    private void tlsAESRadioActionPerformed(ActionEvent evt) {
        if (!this.tlsComponentsEnabled) {
            return;
        }
        this.clientAuthenticationLabel.setEnabled(true);
        this.clientAuthenticationYesRadio.setEnabled(true);
        this.clientAuthenticationNoRadio.setEnabled(true);
        this.acceptSSLv2Label.setEnabled(true);
        this.acceptSSLv2YesRadio.setEnabled(true);
        this.acceptSSLv2NoRadio.setEnabled(true);
        this.keyStoreLabel.setEnabled(true);
        this.keyStoreField.setEnabled(true);
        this.keyStorePasswordLabel.setEnabled(true);
        this.keyStorePasswordField.setEnabled(true);
        this.trustStoreLabel.setEnabled(true);
        this.trustStoreField.setEnabled(true);
        this.trustStorePasswordLabel.setEnabled(true);
        this.trustStorePasswordField.setEnabled(true);
        this.keyPasswordLabel.setEnabled(true);
        this.keyPasswordField.setEnabled(true);
    }

    private void tls3DESRadioActionPerformed(ActionEvent evt) {
        if (!this.tlsComponentsEnabled) {
            return;
        }
        this.clientAuthenticationLabel.setEnabled(true);
        this.clientAuthenticationYesRadio.setEnabled(true);
        this.clientAuthenticationNoRadio.setEnabled(true);
        this.acceptSSLv2Label.setEnabled(true);
        this.acceptSSLv2YesRadio.setEnabled(true);
        this.acceptSSLv2NoRadio.setEnabled(true);
        this.keyStoreLabel.setEnabled(true);
        this.keyStoreField.setEnabled(true);
        this.keyStorePasswordLabel.setEnabled(true);
        this.keyStorePasswordField.setEnabled(true);
        this.trustStoreLabel.setEnabled(true);
        this.trustStoreField.setEnabled(true);
        this.trustStorePasswordLabel.setEnabled(true);
        this.trustStorePasswordField.setEnabled(true);
        this.keyPasswordLabel.setEnabled(true);
        this.keyPasswordField.setEnabled(true);
    }

    private void nativeNoActionPerformed(ActionEvent evt) {
        if (this.bigendianNo.isSelected()) {
            this.jLabel29.setEnabled(true);
            this.deftsYes.setEnabled(true);
            this.deftsNo.setEnabled(true);
        }
    }

    private void deftsNoActionPerformed(ActionEvent evt) {
        this.jLabel31.setEnabled(true);
        this.nativeYes.setEnabled(true);
        this.nativeNo.setEnabled(true);
        this.jLabel28.setEnabled(true);
        this.bigendianYes.setEnabled(true);
        this.bigendianNo.setEnabled(true);
    }

    private void bigendianNoActionPerformed(ActionEvent evt) {
        if (this.nativeNo.isSelected()) {
            this.jLabel29.setEnabled(true);
            this.deftsYes.setEnabled(true);
            this.deftsNo.setEnabled(true);
        }
    }

    private void bigendianYesActionPerformed(ActionEvent evt) {
        this.jLabel29.setEnabled(false);
        this.deftsYes.setEnabled(false);
        this.deftsNo.setEnabled(false);
        this.deftsNo.setSelected(true);
    }

    private void deftsYesActionPerformed(ActionEvent evt) {
        this.jLabel31.setEnabled(false);
        this.nativeYes.setEnabled(false);
        this.nativeNo.setEnabled(false);
        this.nativeNo.setSelected(true);
        this.jLabel28.setEnabled(false);
        this.bigendianYes.setEnabled(false);
        this.bigendianNo.setEnabled(false);
        this.bigendianNo.setSelected(true);
    }

    private void nativeYesActionPerformed(ActionEvent evt) {
        this.jLabel29.setEnabled(false);
        this.deftsYes.setEnabled(false);
        this.deftsNo.setEnabled(false);
        this.deftsNo.setSelected(true);
    }

    private void ackOnNewConnectionNoActionPerformed(ActionEvent evt) {
    }

    private void ackOnNewConnectionYesActionPerformed(ActionEvent evt) {
    }
}

