/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dashboardstatus;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.plugins.DashboardTabPlugin;
import com.mirth.connect.plugins.DashboardTablePlugin;
import com.mirth.connect.plugins.dashboardstatus.ConnectionLogItem;
import com.mirth.connect.plugins.dashboardstatus.DashboardConnectorStatusPanel;
import com.mirth.connect.plugins.dashboardstatus.DashboardConnectorStatusServletInterface;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;

public class DashboardConnectorStatusClient
extends DashboardTabPlugin {
    private DashboardConnectorStatusPanel dcsp;
    private static final String NO_SERVER_SELECTED = "No Server Selected";
    private static final String NO_CHANNEL_SELECTED = "No Channel Selected";
    private ConcurrentHashMap<String, Map<String, LinkedList<ConnectionLogItem>>> connectorInfoLogs;
    private int currentDashboardLogSize;
    private List<DashboardStatus> selectedStatuses;
    private boolean shouldResetLogs = true;
    private Map<String, Map<String, Long>> lastLogIdByServerId = new ConcurrentHashMap<String, Map<String, Long>>();

    public DashboardConnectorStatusClient(String name) {
        super(name);
        this.connectorInfoLogs = new ConcurrentHashMap();
        this.dcsp = new DashboardConnectorStatusPanel(this);
        this.currentDashboardLogSize = this.dcsp.getCurrentDashboardLogSize();
    }

    public void clearLog(String selectedChannelId) {
        String serverId = this.getSelectedServerId();
        if (serverId == null) {
            for (String srvId : this.lastLogIdByServerId.keySet()) {
                this.clearLog(srvId, selectedChannelId);
                this.updateServerLastLogId(srvId, selectedChannelId);
            }
        } else {
            this.removeLogsFromCluster(serverId, selectedChannelId);
            this.clearLog(serverId, selectedChannelId);
        }
        this.dcsp.updateTable(null);
    }

    private void clearLog(String serverId, String selectedChannelId) {
        Map<String, LinkedList<ConnectionLogItem>> serverLog = this.connectorInfoLogs.get(serverId);
        if (serverLog != null) {
            List<String> channelIds = this.getSelectedChannelIds(selectedChannelId);
            for (String channelId : channelIds) {
                serverLog.remove(channelId);
            }
        }
    }

    private void updateServerLastLogId(String serverId, String selectedChannelId) {
        List<String> channelIds = this.getSelectedChannelIds(selectedChannelId);
        for (String channelId : channelIds) {
            Map<String, Long> lastLogIds;
            Map<String, Long> clusterLastLogIds = this.lastLogIdByServerId.get(NO_SERVER_SELECTED);
            Long clusterLastLogId = null;
            if (clusterLastLogIds != null) {
                clusterLastLogId = clusterLastLogIds.get(channelId);
            }
            if ((lastLogIds = this.lastLogIdByServerId.get(serverId)) == null) {
                lastLogIds = new HashMap<String, Long>();
                this.lastLogIdByServerId.put(serverId, lastLogIds);
            }
            Long lastLogId = lastLogIds.get(channelId);
            if (clusterLastLogId == null || lastLogId != null && clusterLastLogId <= lastLogId) continue;
            lastLogIds.put(channelId, clusterLastLogId);
        }
    }

    private void removeLogsFromCluster(String serverId, String selectedChannelId) {
        Map<String, LinkedList<ConnectionLogItem>> serverLog = this.connectorInfoLogs.get(serverId);
        if (serverLog != null) {
            List<String> channelIds = this.getSelectedChannelIds(selectedChannelId);
            HashSet<Long> logIdsToRemove = new HashSet<Long>();
            for (String channelId : channelIds) {
                this.getChannelLogs(NO_SERVER_SELECTED, channelId);
                Map<String, LinkedList<ConnectionLogItem>> clusterLog = this.connectorInfoLogs.get(NO_SERVER_SELECTED);
                if (clusterLog == null) {
                    clusterLog = new HashMap<String, LinkedList<ConnectionLogItem>>();
                    this.connectorInfoLogs.put(NO_SERVER_SELECTED, clusterLog);
                }
                if (!clusterLog.containsKey(channelId)) continue;
                List items = serverLog.get(channelId);
                for (ConnectionLogItem item : items) {
                    logIdsToRemove.add(item.getLogId());
                }
                LinkedList<ConnectionLogItem> prunedClusterLog = new LinkedList<ConnectionLogItem>();
                for (ConnectionLogItem item : clusterLog.get(channelId)) {
                    if (logIdsToRemove.contains(item.getLogId())) continue;
                    prunedClusterLog.add(item);
                }
                clusterLog.put(channelId, prunedClusterLog);
            }
        }
    }

    private List<String> getSelectedChannelIds(String selectedChannelId) {
        ArrayList<String> channelIds = new ArrayList<String>();
        if (selectedChannelId.equals(NO_CHANNEL_SELECTED) && this.selectedStatuses != null && this.selectedStatuses.size() > 0) {
            for (DashboardStatus status : this.selectedStatuses) {
                channelIds.add(status.getChannelId());
            }
        } else {
            channelIds.add(selectedChannelId);
        }
        return channelIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLogSize(int newDashboardLogSize, String selectedChannel) {
        if (newDashboardLogSize < this.currentDashboardLogSize) {
            LinkedList<ConnectionLogItem> newChannelLog = this.getChannelLog(this.selectedStatuses);
            DashboardConnectorStatusClient dashboardConnectorStatusClient = this;
            synchronized (dashboardConnectorStatusClient) {
                while (newDashboardLogSize < newChannelLog.size()) {
                    newChannelLog.removeLast();
                }
            }
            this.dcsp.updateTable(newChannelLog);
        }
        this.currentDashboardLogSize = newDashboardLogSize;
    }

    public void prepareData() throws ClientException {
        this.prepareData(null);
    }

    public void prepareData(List<DashboardStatus> statuses) throws ClientException {
        if (this.shouldResetLogs) {
            this.connectorInfoLogs.clear();
            this.dcsp.resetAllChannelStates();
            this.shouldResetLogs = false;
        }
        this.selectedStatuses = statuses;
        String serverId = this.getSelectedServerId();
        if (serverId == null) {
            serverId = NO_SERVER_SELECTED;
        }
        if (statuses != null && statuses.size() > 0) {
            for (DashboardStatus status : statuses) {
                this.getChannelLogs(serverId, status.getChannelId());
            }
        } else {
            this.getChannelLogs(serverId, NO_CHANNEL_SELECTED);
        }
    }

    private synchronized void getChannelLogs(String serverId, String channelId) {
        Map<String, Long> lastLogIdByChannelId = this.lastLogIdByServerId.get(serverId);
        if (lastLogIdByChannelId == null) {
            lastLogIdByChannelId = new HashMap<String, Long>();
            this.lastLogIdByServerId.put(serverId, lastLogIdByChannelId);
        }
        Long lastLogId = lastLogIdByChannelId.get(channelId);
        if (!this.dcsp.isPaused(channelId)) {
            LinkedList connectionInfoLogsReceived = new LinkedList();
            try {
                connectionInfoLogsReceived = channelId.equals(NO_CHANNEL_SELECTED) ? ((DashboardConnectorStatusServletInterface)PlatformUI.MIRTH_FRAME.mirthClient.getServlet(DashboardConnectorStatusServletInterface.class)).getAllChannelLogs(serverId.equals(NO_SERVER_SELECTED) ? null : serverId, this.currentDashboardLogSize, lastLogId) : ((DashboardConnectorStatusServletInterface)PlatformUI.MIRTH_FRAME.mirthClient.getServlet(DashboardConnectorStatusServletInterface.class)).getChannelLog(serverId.equals(NO_SERVER_SELECTED) ? null : serverId, channelId, this.currentDashboardLogSize, lastLogId);
            }
            catch (ClientException e) {
                this.parent.alertThrowable((Component)this.parent, (Throwable)e, false);
            }
            LinkedList<ConnectionLogItem> channelLog = this.getChannelLog(serverId, channelId);
            for (int i = connectionInfoLogsReceived.size() - 1; i >= 0; --i) {
                ConnectionLogItem item = (ConnectionLogItem)connectionInfoLogsReceived.get(i);
                channelLog.addFirst(item);
                if (item.getServerId() == null || this.lastLogIdByServerId.containsKey(item.getServerId())) continue;
                this.lastLogIdByServerId.put(item.getServerId(), new HashMap());
            }
            while (channelLog.size() > this.currentDashboardLogSize) {
                channelLog.removeLast();
            }
            Map<String, LinkedList<ConnectionLogItem>> serverLog = this.connectorInfoLogs.get(serverId);
            if (serverLog == null) {
                serverLog = new HashMap<String, LinkedList<ConnectionLogItem>>();
                this.connectorInfoLogs.put(serverId, serverLog);
            }
            serverLog.put(channelId, channelLog);
            if (!connectionInfoLogsReceived.isEmpty()) {
                lastLogIdByChannelId.put(channelId, ((ConnectionLogItem)connectionInfoLogsReceived.getFirst()).getLogId());
            }
        }
    }

    public void update() {
        this.update(null);
    }

    public void update(List<DashboardStatus> statuses) {
        ConcurrentHashMap<String, List<Integer>> selectedConnectorMap = null;
        if (statuses != null) {
            selectedConnectorMap = new ConcurrentHashMap<String, List<Integer>>();
            for (DashboardStatus status : statuses) {
                String channelId = status.getChannelId();
                Integer metaDataId = status.getMetaDataId();
                ArrayList<Integer> selectedConnectors = (ArrayList<Integer>)selectedConnectorMap.get(channelId);
                if (selectedConnectors == null) {
                    selectedConnectors = new ArrayList<Integer>();
                    selectedConnectorMap.put(channelId, selectedConnectors);
                }
                selectedConnectors.add(metaDataId);
            }
        }
        String selectedChannelId = statuses != null && statuses.size() == 1 ? statuses.get(0).getChannelId() : NO_CHANNEL_SELECTED;
        this.dcsp.setSelectedChannelId(selectedChannelId);
        this.dcsp.setSelectedConnectors(selectedConnectorMap);
        this.dcsp.updateTable(this.getChannelLog(statuses));
        this.dcsp.adjustPauseResumeButton(selectedChannelId);
    }

    public JComponent getTabComponent() {
        return this.dcsp;
    }

    public void start() {
    }

    public void stop() {
        this.reset();
    }

    public void reset() {
        this.clearLog(NO_CHANNEL_SELECTED);
        this.shouldResetLogs = true;
    }

    public String getPluginPointName() {
        return "Connection Log";
    }

    private LinkedList<ConnectionLogItem> getChannelLog(List<DashboardStatus> statuses) {
        if (statuses == null || statuses.size() < 1) {
            return this.getChannelLog(NO_CHANNEL_SELECTED);
        }
        List<Object> items = new ArrayList<ConnectionLogItem>();
        HashSet<String> selectedChannelIds = new HashSet<String>();
        for (DashboardStatus status : statuses) {
            if (selectedChannelIds.contains(status.getChannelId())) continue;
            items.addAll(this.getChannelLog(status.getChannelId()));
            selectedChannelIds.add(status.getChannelId());
        }
        items.sort(new Comparator<ConnectionLogItem>(){

            @Override
            public int compare(ConnectionLogItem item1, ConnectionLogItem item2) {
                return item2.getLogId().compareTo(item1.getLogId());
            }
        });
        if (items.size() > this.currentDashboardLogSize) {
            items = items.subList(0, this.currentDashboardLogSize);
        }
        LinkedList<ConnectionLogItem> linkedItems = new LinkedList<ConnectionLogItem>();
        linkedItems.addAll(items);
        return linkedItems;
    }

    private LinkedList<ConnectionLogItem> getChannelLog(String channelId) {
        String server = this.getSelectedServerId();
        return this.getChannelLog(server == null ? NO_SERVER_SELECTED : server, channelId);
    }

    private LinkedList<ConnectionLogItem> getChannelLog(String serverId, String channelId) {
        Map<String, LinkedList<ConnectionLogItem>> serverLog;
        if (this.connectorInfoLogs.containsKey(serverId) && (serverLog = this.connectorInfoLogs.get(serverId)).containsKey(channelId)) {
            return serverLog.get(channelId);
        }
        return new LinkedList<ConnectionLogItem>();
    }

    private String getSelectedServerId() {
        for (DashboardTablePlugin plugin : LoadedExtensions.getInstance().getDashboardTablePlugins().values()) {
            if (plugin.getServerId() == null) continue;
            return plugin.getServerId();
        }
        return null;
    }
}

