/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.connectors.file.AdvancedSettingsDialog;
import com.mirth.connect.connectors.file.FTPSchemeProperties;
import com.mirth.connect.connectors.file.SchemeProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AdvancedFTPSettingsDialog
extends AdvancedSettingsDialog {
    private boolean saved;
    private JLabel initialCommandsLabel;
    private JTextField initialCommandsField;
    private JButton okButton;
    private JButton cancelButton;

    public AdvancedFTPSettingsDialog(FTPSchemeProperties schemeProperties) {
        this.setTitle("Method Settings");
        this.setDefaultCloseOperation(2);
        this.setSize(new Dimension(350, 140));
        DisplayUtil.setResizable((Dialog)((Object)this), (boolean)false);
        this.setLayout((LayoutManager)new MigLayout("insets 8 8 0 8, novisualpadding, hidemode 3"));
        this.getContentPane().setBackground(UIConstants.BACKGROUND_COLOR);
        this.initComponents();
        this.initLayout();
        this.setFileSchemeProperties(schemeProperties != null ? schemeProperties : new FTPSchemeProperties());
        this.setLocationRelativeTo((Component)PlatformUI.MIRTH_FRAME);
        this.setVisible(true);
    }

    @Override
    public boolean wasSaved() {
        return this.saved;
    }

    @Override
    public SchemeProperties getSchemeProperties() {
        FTPSchemeProperties props = new FTPSchemeProperties();
        props.setInitialCommands(this.commandStringToList(this.initialCommandsField.getText()));
        return props;
    }

    public void setFileSchemeProperties(FTPSchemeProperties schemeProperties) {
        this.initialCommandsField.setText(this.commandListToString(schemeProperties.getInitialCommands()));
    }

    public boolean validateProperties() {
        return true;
    }

    private void initComponents() {
        this.initialCommandsLabel = new JLabel("Initial Commands:");
        this.initialCommandsField = new JTextField();
        this.initialCommandsField.setToolTipText("<html>Commands to run when initializing a FTP connection.<br/>Use commas to separate multiple commands.</html>");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedFTPSettingsDialog.this.okCancelButtonActionPerformed();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedFTPSettingsDialog.this.dispose();
            }
        });
    }

    private void initLayout() {
        JPanel propertiesPanel = new JPanel((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fillx", "[right][left]"));
        propertiesPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        propertiesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(204, 204, 204)), "FTP Settings", 0, 0, new Font("Tahoma", 1, 11)));
        propertiesPanel.add(this.initialCommandsLabel);
        propertiesPanel.add((Component)this.initialCommandsField, "w 200!");
        this.add(propertiesPanel, "grow, push, top, wrap");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("insets 0 8 8 8, novisualpadding, hidemode 3, fill"));
        buttonPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        buttonPanel.add((Component)new JSeparator(), "growx, sx, wrap");
        buttonPanel.add((Component)this.okButton, "newline, w 50!, sx, right, split");
        buttonPanel.add((Component)this.cancelButton, "w 50!");
        this.add(buttonPanel, "south, span");
    }

    private void okCancelButtonActionPerformed() {
        if (!this.validateProperties()) {
            return;
        }
        this.saved = true;
        PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
        this.dispose();
    }

    private List<String> commandStringToList(String commandString) {
        String[] commandArray;
        ArrayList<String> commandList = new ArrayList<String>();
        for (String command : commandArray = commandString.split(",")) {
            String commandToAdd = command.trim();
            if (!StringUtils.isNotBlank((CharSequence)commandToAdd)) continue;
            commandList.add(commandToAdd);
        }
        return commandList;
    }

    private String commandListToString(List<String> commandList) {
        String commandString = null;
        commandString = CollectionUtils.isNotEmpty(commandList) ? String.join((CharSequence)",", commandList) : "";
        return commandString;
    }
}

