/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateContextSet;
import com.mirth.connect.model.codetemplates.CodeTemplateProperties;
import com.mirth.connect.plugins.CodeTemplatePlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileReaderCodeTemplatePlugin
extends CodeTemplatePlugin {
    public FileReaderCodeTemplatePlugin(String name) {
        super(name);
    }

    public Map<String, List<CodeTemplate>> getReferenceItems() {
        HashMap<String, List<CodeTemplate>> referenceItems = new HashMap<String, List<CodeTemplate>>();
        ArrayList<CodeTemplate> fileReaderFunctionsList = new ArrayList<CodeTemplate>();
        fileReaderFunctionsList.add(new CodeTemplate("Get Original File Name", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "sourceMap.get('originalFilename')", "Retrieves the name of the file read by the File Reader."));
        fileReaderFunctionsList.add(new CodeTemplate("Get Original File Directory", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "sourceMap.get('fileDirectory')", "Retrieves the parent directory of the file read by the File Reader."));
        fileReaderFunctionsList.add(new CodeTemplate("Get Original File Size in Bytes", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "sourceMap.get('fileSize')", "Retrieves the size (in bytes) of the file read by the File Reader."));
        fileReaderFunctionsList.add(new CodeTemplate("Get Original File Last Modified Timestamp", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "sourceMap.get('fileLastModified')", "Retrieves the last modified timestamp (in milliseconds since January 1st, 1970) of the file read by the File Reader."));
        referenceItems.put("File Reader Functions", fileReaderFunctionsList);
        return referenceItems;
    }

    public String getPluginPointName() {
        return this.pluginName + " Code Template Plugin";
    }

    public void start() {
    }

    public void stop() {
    }

    public void reset() {
    }
}

