/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v22.group.MFR_M01_MF;
import ca.uhn.hl7v2.model.v22.segment.DSC;
import ca.uhn.hl7v2.model.v22.segment.ERR;
import ca.uhn.hl7v2.model.v22.segment.MFI;
import ca.uhn.hl7v2.model.v22.segment.MSA;
import ca.uhn.hl7v2.model.v22.segment.MSH;
import ca.uhn.hl7v2.model.v22.segment.QRD;
import ca.uhn.hl7v2.model.v22.segment.QRF;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFR_M01
extends AbstractMessage {
    public MFR_M01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MFR_M01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(MFI.class, true, false);
            this.add(MFR_M01_MF.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFR_M01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.2";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public QRD getQRD() {
        return (QRD)this.getTyped("QRD", QRD.class);
    }

    public QRF getQRF() {
        return (QRF)this.getTyped("QRF", QRF.class);
    }

    public MFI getMFI() {
        return (MFI)this.getTyped("MFI", MFI.class);
    }

    public MFR_M01_MF getMF() {
        return (MFR_M01_MF)this.getTyped("MF", MFR_M01_MF.class);
    }

    public MFR_M01_MF getMF(int rep) {
        return (MFR_M01_MF)this.getTyped("MF", rep, MFR_M01_MF.class);
    }

    public int getMFReps() {
        return this.getReps("MF");
    }

    public List<MFR_M01_MF> getMFAll() throws HL7Exception {
        return this.getAllAsList("MF", MFR_M01_MF.class);
    }

    public void insertMF(MFR_M01_MF structure, int rep) throws HL7Exception {
        super.insertRepetition("MF", (Structure)structure, rep);
    }

    public MFR_M01_MF insertMF(int rep) throws HL7Exception {
        return (MFR_M01_MF)super.insertRepetition("MF", rep);
    }

    public MFR_M01_MF removeMF(int rep) throws HL7Exception {
        return (MFR_M01_MF)super.removeRepetition("MF", rep);
    }

    public DSC getDSC() {
        return (DSC)this.getTyped("DSC", DSC.class);
    }
}

