/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.Queue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ConcurrentLinkedQueue
extends AbstractQueue
implements Queue,
Serializable {
    private static final long serialVersionUID = 196745693267521676L;
    private static final AtomicReferenceFieldUpdater tailUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentLinkedQueue.class, Node.class, "tail");
    private static final AtomicReferenceFieldUpdater headUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentLinkedQueue.class, Node.class, "head");
    private volatile transient Node head;
    private volatile transient Node tail;

    private boolean casTail(Node cmp, Node val) {
        return tailUpdater.compareAndSet(this, cmp, val);
    }

    private boolean casHead(Node cmp, Node val) {
        return headUpdater.compareAndSet(this, cmp, val);
    }

    public ConcurrentLinkedQueue() {
        this.tail = this.head = new Node(null, null);
    }

    public ConcurrentLinkedQueue(Collection c) {
        this.tail = this.head = new Node(null, null);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public boolean add(Object e) {
        return this.offer(e);
    }

    public boolean offer(Object e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Node n = new Node(e, null);
        while (true) {
            Node t = this.tail;
            Node s = t.getNext();
            if (t != this.tail) continue;
            if (s == null) {
                if (!t.casNext(s, n)) continue;
                this.casTail(t, n);
                return true;
            }
            this.casTail(t, s);
        }
    }

    public Object poll() {
        Object item;
        Node first;
        while (true) {
            Node h = this.head;
            Node t = this.tail;
            first = h.getNext();
            if (h != this.head) continue;
            if (h == t) {
                if (first == null) {
                    return null;
                }
                this.casTail(t, first);
                continue;
            }
            if (this.casHead(h, first) && (item = first.getItem()) != null) break;
        }
        first.setItem(null);
        return item;
    }

    public Object peek() {
        while (true) {
            Node h = this.head;
            Node t = this.tail;
            Node first = h.getNext();
            if (h != this.head) continue;
            if (h == t) {
                if (first == null) {
                    return null;
                }
                this.casTail(t, first);
                continue;
            }
            Object item = first.getItem();
            if (item != null) {
                return item;
            }
            this.casHead(h, first);
        }
    }

    Node first() {
        while (true) {
            Node h = this.head;
            Node t = this.tail;
            Node first = h.getNext();
            if (h != this.head) continue;
            if (h == t) {
                if (first == null) {
                    return null;
                }
                this.casTail(t, first);
                continue;
            }
            if (first.getItem() != null) {
                return first;
            }
            this.casHead(h, first);
        }
    }

    public boolean isEmpty() {
        return this.first() == null;
    }

    public int size() {
        int count = 0;
        for (Node p = this.first(); p != null && (p.getItem() == null || ++count != Integer.MAX_VALUE); p = p.getNext()) {
        }
        return count;
    }

    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        for (Node p = this.first(); p != null; p = p.getNext()) {
            Object item = p.getItem();
            if (item == null || !o.equals(item)) continue;
            return true;
        }
        return false;
    }

    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        for (Node p = this.first(); p != null; p = p.getNext()) {
            Object item = p.getItem();
            if (item == null || !o.equals(item) || !p.casItem(item, null)) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return new Itr();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (Node p = this.first(); p != null; p = p.getNext()) {
            Object item = p.getItem();
            if (item == null) continue;
            s.writeObject(item);
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object item;
        s.defaultReadObject();
        this.tail = this.head = new Node(null, null);
        while ((item = s.readObject()) != null) {
            this.offer(item);
        }
    }

    private class Itr
    implements Iterator {
        private Node nextNode;
        private Object nextItem;
        private Node lastRet;

        Itr() {
            this.advance();
        }

        private Object advance() {
            Node p;
            this.lastRet = this.nextNode;
            Object x = this.nextItem;
            Node node = p = this.nextNode == null ? ConcurrentLinkedQueue.this.first() : this.nextNode.getNext();
            while (true) {
                if (p == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    return x;
                }
                Object item = p.getItem();
                if (item != null) {
                    this.nextNode = p;
                    this.nextItem = item;
                    return x;
                }
                p = p.getNext();
            }
        }

        public boolean hasNext() {
            return this.nextNode != null;
        }

        public Object next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            return this.advance();
        }

        public void remove() {
            Node l = this.lastRet;
            if (l == null) {
                throw new IllegalStateException();
            }
            l.setItem(null);
            this.lastRet = null;
        }
    }

    private static class Node {
        private volatile Object item;
        private volatile Node next;
        private static final AtomicReferenceFieldUpdater nextUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");
        private static final AtomicReferenceFieldUpdater itemUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Object.class, "item");

        Node(Object x) {
            this.item = x;
        }

        Node(Object x, Node n) {
            this.item = x;
            this.next = n;
        }

        Object getItem() {
            return this.item;
        }

        boolean casItem(Object cmp, Object val) {
            return itemUpdater.compareAndSet(this, cmp, val);
        }

        void setItem(Object val) {
            itemUpdater.set(this, val);
        }

        Node getNext() {
            return this.next;
        }

        boolean casNext(Node cmp, Node val) {
            return nextUpdater.compareAndSet(this, cmp, val);
        }

        void setNext(Node val) {
            nextUpdater.set(this, val);
        }
    }
}

