/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.PriorityQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Delayed;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Condition;

public class DelayQueue
extends AbstractQueue
implements BlockingQueue {
    private final transient ReentrantLock lock = new ReentrantLock();
    private final transient Condition available = (Condition)((Object)this.lock.newCondition());
    private final PriorityQueue q = new PriorityQueue();

    public DelayQueue() {
    }

    public DelayQueue(Collection c) {
        this.addAll(c);
    }

    public boolean add(Object e) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object e) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object first = this.q.peek();
            this.q.offer(e);
            if (first == null || ((Delayed)e).compareTo(first) < 0) {
                this.available.signalAll();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void put(Object e) {
        this.offer(e);
    }

    public boolean offer(Object e, long timeout, TimeUnit unit) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object first = this.q.peek();
            if (first == null || ((Delayed)first).getDelay(TimeUnit.NANOSECONDS) > 0L) {
                Object var3_3 = null;
                return var3_3;
            }
            Object x = this.q.poll();
            assert (x != null);
            if (this.q.size() != 0) {
                this.available.signalAll();
            }
            Object object = x;
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    public Object take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                Object first;
                if ((first = this.q.peek()) == null) {
                    this.available.await();
                    continue;
                }
                long delay = ((Delayed)first).getDelay(TimeUnit.NANOSECONDS);
                if (delay > 0L) {
                    long tl = this.available.awaitNanos(delay);
                    continue;
                }
                Object x = this.q.poll();
                assert (x != null);
                if (this.q.size() != 0) {
                    this.available.signalAll();
                }
                Object object = x;
                return object;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                Object first;
                if ((first = this.q.peek()) == null) {
                    if (nanos <= 0L) {
                        Object var8_7 = null;
                        return var8_7;
                    }
                    nanos = this.available.awaitNanos(nanos);
                    continue;
                }
                long delay = ((Delayed)first).getDelay(TimeUnit.NANOSECONDS);
                if (delay > 0L) {
                    if (nanos <= 0L) {
                        Object var10_9 = null;
                        return var10_9;
                    }
                    if (delay > nanos) {
                        delay = nanos;
                    }
                    long timeLeft = this.available.awaitNanos(delay);
                    nanos -= delay - timeLeft;
                    continue;
                }
                Object x = this.q.poll();
                assert (x != null);
                if (this.q.size() != 0) {
                    this.available.signalAll();
                }
                Object object = x;
                return object;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object object = this.q.peek();
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.q.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object first;
            int n = 0;
            while ((first = this.q.peek()) != null && ((Delayed)first).getDelay(TimeUnit.NANOSECONDS) <= 0L) {
                c.add(this.q.poll());
                ++n;
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object first;
            int n;
            for (n = 0; n < maxElements && (first = this.q.peek()) != null && ((Delayed)first).getDelay(TimeUnit.NANOSECONDS) <= 0L; ++n) {
                c.add(this.q.poll());
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.q.clear();
        }
        finally {
            lock.unlock();
        }
    }

    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray();
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray(a);
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.q.remove(o);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public Iterator iterator() {
        return new Itr(this.toArray());
    }

    private class Itr
    implements Iterator {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        Itr(Object[] array) {
            this.array = array;
        }

        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        public Object next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return this.array[this.cursor++];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            Object x = this.array[this.lastRet];
            this.lastRet = -1;
            DelayQueue.this.lock.lock();
            try {
                Iterator it = DelayQueue.this.q.iterator();
                while (it.hasNext()) {
                    if (it.next() != x) continue;
                    it.remove();
                    return;
                }
            }
            finally {
                DelayQueue.this.lock.unlock();
            }
        }
    }
}

