/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.CancellationException;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.RunnableFuture;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class FutureTask
implements RunnableFuture {
    private final Sync sync;

    public FutureTask(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        this.sync = new Sync(callable);
    }

    public FutureTask(Runnable runnable, Object result) {
        this(Executors.callable(runnable, result));
    }

    public boolean isCancelled() {
        return this.sync.innerIsCancelled();
    }

    public boolean isDone() {
        return this.sync.innerIsDone();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.sync.innerCancel(mayInterruptIfRunning);
    }

    public Object get() throws InterruptedException, ExecutionException {
        return this.sync.innerGet();
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.sync.innerGet(unit.toNanos(timeout));
    }

    protected void done() {
    }

    protected void set(Object v) {
        this.sync.innerSet(v);
    }

    protected void setException(Throwable t) {
        this.sync.innerSetException(t);
    }

    public void run() {
        this.sync.innerRun();
    }

    protected boolean runAndReset() {
        return this.sync.innerRunAndReset();
    }

    private final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = -7828117401763700385L;
        private static final int READY = 0;
        private static final int RUNNING = 1;
        private static final int RAN = 2;
        private static final int CANCELLED = 4;
        private final Callable callable;
        private Object result;
        private Throwable exception;
        private volatile Thread runner;

        Sync(Callable callable) {
            this.callable = callable;
        }

        private boolean ranOrCancelled(int state) {
            return (state & 6) != 0;
        }

        protected int tryAcquireShared(int ignore) {
            return this.innerIsDone() ? 1 : -1;
        }

        protected boolean tryReleaseShared(int ignore) {
            this.runner = null;
            return true;
        }

        boolean innerIsCancelled() {
            return this.getState() == 4;
        }

        boolean innerIsDone() {
            return this.ranOrCancelled(this.getState()) && this.runner == null;
        }

        Object innerGet() throws InterruptedException, ExecutionException {
            this.acquireSharedInterruptibly(0);
            if (this.getState() == 4) {
                throw new CancellationException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        Object innerGet(long nanosTimeout) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.tryAcquireSharedNanos(0, nanosTimeout)) {
                throw new TimeoutException();
            }
            if (this.getState() == 4) {
                throw new CancellationException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        void innerSet(Object v) {
            int s;
            do {
                if ((s = this.getState()) == 2) {
                    return;
                }
                if (s != 4) continue;
                this.releaseShared(0);
                return;
            } while (!this.compareAndSetState(s, 2));
            this.result = v;
            this.releaseShared(0);
            FutureTask.this.done();
        }

        void innerSetException(Throwable t) {
            int s;
            do {
                if ((s = this.getState()) == 2) {
                    return;
                }
                if (s != 4) continue;
                this.releaseShared(0);
                return;
            } while (!this.compareAndSetState(s, 2));
            this.exception = t;
            this.releaseShared(0);
            FutureTask.this.done();
        }

        boolean innerCancel(boolean mayInterruptIfRunning) {
            Thread r;
            int s;
            do {
                if (!this.ranOrCancelled(s = this.getState())) continue;
                return false;
            } while (!this.compareAndSetState(s, 4));
            if (mayInterruptIfRunning && (r = this.runner) != null) {
                r.interrupt();
            }
            this.releaseShared(0);
            FutureTask.this.done();
            return true;
        }

        void innerRun() {
            if (!this.compareAndSetState(0, 1)) {
                return;
            }
            try {
                this.runner = Thread.currentThread();
                if (this.getState() == 1) {
                    FutureTask.this.set(this.callable.call());
                } else {
                    this.releaseShared(0);
                }
            }
            catch (Throwable ex) {
                FutureTask.this.setException(ex);
            }
        }

        boolean innerRunAndReset() {
            if (!this.compareAndSetState(0, 1)) {
                return false;
            }
            try {
                this.runner = Thread.currentThread();
                if (this.getState() == 1) {
                    this.callable.call();
                }
                this.runner = null;
                return this.compareAndSetState(1, 0);
            }
            catch (Throwable ex) {
                FutureTask.this.setException(ex);
                return false;
            }
        }
    }
}

