/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.helpers;

import edu.emory.mathcs.backport.java.util.Arrays;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public final class Utils {
    private Utils() {
    }

    public static long nanoTime() {
        return System.nanoTime();
    }

    public static long awaitNanos(Condition cond, long nanosTimeout) throws InterruptedException {
        if (nanosTimeout <= 0L) {
            return nanosTimeout;
        }
        long now = Utils.nanoTime();
        cond.await(nanosTimeout, TimeUnit.NANOSECONDS);
        return nanosTimeout - (Utils.nanoTime() - now);
    }

    public static Object[] collectionToArray(Collection c) {
        int len = c.size();
        Object[] arr = new Object[len];
        Iterator itr = c.iterator();
        int idx = 0;
        while (true) {
            if (idx < len && itr.hasNext()) {
                arr[idx++] = itr.next();
                continue;
            }
            if (!itr.hasNext()) {
                if (idx == len) {
                    return arr;
                }
                return Arrays.copyOf(arr, idx, Object[].class);
            }
            int newcap = (arr.length / 2 + 1) * 3;
            if (newcap < arr.length) {
                if (arr.length < Integer.MAX_VALUE) {
                    newcap = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError("required array size too large");
                }
            }
            arr = Arrays.copyOf(arr, newcap, Object[].class);
            len = newcap;
        }
    }

    public static Object[] collectionToArray(Collection c, Object[] a) {
        Class<?> aType = a.getClass();
        int len = c.size();
        Object[] arr = a.length >= len ? a : (Object[])Array.newInstance(aType.getComponentType(), len);
        Iterator itr = c.iterator();
        int idx = 0;
        while (true) {
            if (idx < len && itr.hasNext()) {
                arr[idx++] = itr.next();
                continue;
            }
            if (!itr.hasNext()) {
                if (idx == len) {
                    return arr;
                }
                if (arr == a) {
                    a[idx] = null;
                    return a;
                }
                return Arrays.copyOf(arr, idx, aType);
            }
            int newcap = (arr.length / 2 + 1) * 3;
            if (newcap < arr.length) {
                if (arr.length < Integer.MAX_VALUE) {
                    newcap = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError("required array size too large");
                }
            }
            arr = Arrays.copyOf(arr, newcap, aType);
            len = newcap;
        }
    }
}

