/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.ws;

import com.mirth.connect.client.ui.ConnectorTypeDecoration;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.client.ui.panels.connectors.ListenerSettingsPanel;
import com.mirth.connect.connectors.ws.Binding;
import com.mirth.connect.connectors.ws.WebServiceReceiverProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URI;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class WebServiceListener
extends ConnectorSettingsPanel {
    private boolean usingHttps = false;
    private JLabel versionLabel;
    private MirthComboBox versionComboBox;
    private JLabel webServiceLabel;
    private MirthRadioButton classNameDefaultRadio;
    private MirthRadioButton classNameCustomRadio;
    private JLabel classNameLabel;
    private MirthTextField classNameField;
    private JLabel serviceNameLabel;
    private MirthTextField serviceNameField;
    private JLabel wsdlLabel;
    private JTextField wsdlField;
    private ButtonGroup classNameButtonGroup;
    private JLabel methodLabel;
    private JTextField methodField;

    public WebServiceListener() {
        this.initComponents();
        this.initLayout();
        this.wsdlField.setEditable(false);
        this.methodField.setEditable(false);
    }

    public String getConnectorName() {
        return new WebServiceReceiverProperties().getName();
    }

    public ConnectorProperties getProperties() {
        WebServiceReceiverProperties properties = new WebServiceReceiverProperties();
        properties.setClassName(this.classNameField.getText());
        properties.setServiceName(this.serviceNameField.getText());
        properties.setSoapBinding(Binding.fromDisplayName((String)((String)this.versionComboBox.getSelectedItem())));
        return properties;
    }

    public void setProperties(ConnectorProperties properties) {
        WebServiceReceiverProperties props = (WebServiceReceiverProperties)properties;
        this.versionComboBox.setSelectedIndex(0);
        this.versionComboBox.setSelectedItem((Object)props.getSoapBinding().getName());
        this.classNameField.setText(props.getClassName());
        this.updateClassNameRadio();
        this.serviceNameField.setText(props.getServiceName());
        this.updateWSDL();
    }

    public ConnectorProperties getDefaults() {
        return new WebServiceReceiverProperties();
    }

    private void updateClassNameRadio() {
        if (this.classNameField.getText().equals(new WebServiceReceiverProperties().getClassName())) {
            this.classNameDefaultRadio.setSelected(true);
            this.classNameDefaultRadioActionPerformed();
        } else {
            this.classNameCustomRadio.setSelected(true);
            this.classNameCustomRadioActionPerformed();
        }
    }

    public void updateWSDL() {
        String server = "<server ip>";
        try {
            server = new URI(PlatformUI.SERVER_URL).getHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.wsdlField.setText("http" + (this.usingHttps ? "s" : "") + "://" + server + ":" + ((WebServiceReceiverProperties)this.getFilledProperties()).getListenerConnectorProperties().getPort() + "/services/" + this.serviceNameField.getText() + "?wsdl");
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        WebServiceReceiverProperties props = (WebServiceReceiverProperties)properties;
        boolean valid = true;
        if (props.getClassName().length() == 0) {
            valid = false;
            if (highlight) {
                this.classNameField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getServiceName().length() == 0) {
            valid = false;
            if (highlight) {
                this.serviceNameField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return valid;
    }

    public void resetInvalidProperties() {
        this.classNameField.setBackground(null);
        this.serviceNameField.setBackground(null);
    }

    public void doLocalDecoration(ConnectorTypeDecoration connectorTypeDecoration) {
        this.usingHttps = connectorTypeDecoration != null;
        this.updateWSDL();
    }

    public void updatedField(String field) {
        if (ListenerSettingsPanel.FIELD_PORT.equals(field)) {
            this.updateWSDL();
        }
    }

    private void initComponents() {
        this.versionLabel = new JLabel("Binding:");
        this.serviceNameLabel = new JLabel("Service Name:");
        this.methodLabel = new JLabel("Method:");
        this.webServiceLabel = new JLabel("Web Service:");
        this.classNameLabel = new JLabel("Service Class Name:");
        this.serviceNameField = new MirthTextField();
        this.serviceNameField.setToolTipText("The name to give to the web service.");
        this.serviceNameField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                WebServiceListener.this.serviceNameFieldKeyReleased(evt);
            }
        });
        this.methodField = new JTextField();
        this.methodField.setText("String acceptMessage(String message)");
        this.methodField.setToolTipText("Displays the generated web service operation signature the client will call.");
        this.versionComboBox = new MirthComboBox();
        this.versionComboBox.addItem((Object)Binding.DEFAULT.getName());
        this.versionComboBox.addItem((Object)Binding.SOAP11HTTP.getName());
        this.versionComboBox.addItem((Object)Binding.SOAP12HTTP.getName());
        this.versionComboBox.setSelectedIndex(0);
        this.versionComboBox.setToolTipText("<html>The selected binding version defines the structure of the generated envelope.<br/>Selecting default will publish this endpoint with the specified binding annotation.<br/>If no annotation is provided, a SOAP 1.1 binding will be used.</html>");
        this.wsdlLabel = new JLabel("WSDL URL:");
        this.wsdlField = new JTextField();
        this.wsdlField.setToolTipText("<html>Displays the generated WSDL URL for the web service.<br>The client that sends messages to the service can download this file to determine how to call the web service.</html>");
        this.classNameDefaultRadio = new MirthRadioButton("Default service");
        this.classNameDefaultRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.classNameDefaultRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.classNameDefaultRadio.setToolTipText("<html>If checked, the connector will use the DefaultAcceptMessage web service.</html>");
        this.classNameDefaultRadio.setMargin(new Insets(0, 0, 0, 0));
        this.classNameDefaultRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceListener.this.classNameDefaultRadioActionPerformed();
            }
        });
        this.classNameCustomRadio = new MirthRadioButton("Custom service");
        this.classNameCustomRadio.setSelected(true);
        this.classNameCustomRadio.setBackground(new Color(255, 255, 255));
        this.classNameCustomRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.classNameCustomRadio.setToolTipText("<html>If checked, the connector will use a custom web service defined below.</html>");
        this.classNameCustomRadio.setMargin(new Insets(0, 0, 0, 0));
        this.classNameCustomRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceListener.this.classNameCustomRadioActionPerformed();
            }
        });
        this.classNameButtonGroup = new ButtonGroup();
        this.classNameButtonGroup.add((AbstractButton)this.classNameDefaultRadio);
        this.classNameButtonGroup.add((AbstractButton)this.classNameCustomRadio);
        this.classNameField = new MirthTextField();
        this.classNameField.setToolTipText("<html>The fully qualified class name of the web service that should be hosted.<br>If this is a custom class, it should be added in a custom jar so it is loaded with BridgeLink.</html>");
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("novisualpadding, hidemode 3, insets 0", "[right]12[left]"));
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add(this.webServiceLabel);
        this.add((Component)this.classNameDefaultRadio, "split");
        this.add((Component)this.classNameCustomRadio, "wrap");
        this.add(this.classNameLabel);
        this.add((Component)this.classNameField, "w 300!, wrap");
        this.add(this.serviceNameLabel);
        this.add((Component)this.serviceNameField, "w 100!, wrap");
        this.add(this.versionLabel);
        this.add((Component)this.versionComboBox, "wrap");
        this.add(this.wsdlLabel);
        this.add(this.wsdlField, "w 250!, wrap");
        this.add(this.methodLabel);
        this.add(this.methodField, "w 250!, wrap");
    }

    private void serviceNameFieldKeyReleased(KeyEvent evt) {
        this.updateWSDL();
    }

    private void classNameDefaultRadioActionPerformed() {
        this.classNameField.setText(new WebServiceReceiverProperties().getClassName());
        this.methodField.setText("String acceptMessage(String message)");
        this.classNameLabel.setEnabled(false);
        this.classNameField.setEnabled(false);
    }

    private void classNameCustomRadioActionPerformed() {
        this.methodField.setText("<Custom Web Service Methods>");
        this.classNameLabel.setEnabled(true);
        this.classNameField.setEnabled(true);
    }
}

