/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.util;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class ActionTimer {
    private boolean enabled = true;
    private Map<String, Long> times = new ConcurrentHashMap<String, Long>();
    private Map<String, Integer> counts = new ConcurrentHashMap<String, Integer>();

    public void log(String eventName, long millis) {
        if (!this.enabled) {
            return;
        }
        Long oldTime = this.times.get(eventName);
        if (oldTime == null) {
            this.times.put(eventName, millis);
        } else {
            this.times.put(eventName, oldTime + millis);
        }
        Integer count = this.counts.get(eventName);
        if (count == null) {
            this.counts.put(eventName, 1);
        } else {
            this.counts.put(eventName, count + 1);
        }
    }

    public long getTotalTime() {
        long total = 0L;
        for (Long time : this.times.values()) {
            total += time.longValue();
        }
        return total;
    }

    public int getTotalCount() {
        int total = 0;
        for (Integer count : this.counts.values()) {
            total += count.intValue();
        }
        return total;
    }

    public Map<String, Long> getTimes() {
        return this.times;
    }

    public Map<String, Integer> getCounts() {
        return this.counts;
    }

    public String getLog() {
        long totalTime = this.getTotalTime();
        StringBuilder log = new StringBuilder();
        LongComparator longComparator = new LongComparator(this.times);
        TreeMap<String, Long> sortedTimes = new TreeMap<String, Long>(longComparator);
        sortedTimes.putAll(this.times);
        for (Map.Entry logEntry : sortedTimes.entrySet()) {
            String eventName = logEntry.getKey();
            Integer count = this.counts.get(eventName);
            Long time = (Long)logEntry.getValue();
            long pct = totalTime > 0L ? time * 100L / totalTime : 0L;
            log.append(StringUtils.rightPad((String)(eventName + ":"), (int)40) + StringUtils.rightPad((String)(count + " occurrence" + (count != 1 ? "s" : "")), (int)20) + StringUtils.rightPad((String)(time + "ms"), (int)12) + pct + "%\n");
        }
        int totalCount = this.getTotalCount();
        log.append(StringUtils.rightPad((String)"Totals:", (int)40) + StringUtils.rightPad((String)(totalCount + " occurrence" + (totalCount != 1 ? "s" : "")), (int)20) + totalTime + "ms\n");
        return log.toString();
    }

    public void reset() {
        this.counts.clear();
        this.times.clear();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private class LongComparator
    implements Comparator<String> {
        private Map<String, Long> base;

        public LongComparator(Map<String, Long> base) {
            this.base = base;
        }

        @Override
        public int compare(String a, String b) {
            return this.base.get(b).compareTo(this.base.get(a));
        }
    }
}

