/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DocumentReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.w3c.dom.Element;

public class InvalidThrowable
extends Throwable {
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("(?<method>[^\\(]*)(\\((?<file>[\\s\\S]*)\\))?");
    private String throwableXml;
    private String className;
    private String detailMessage;

    public InvalidThrowable(String preUnmarshalXml, DonkeyElement element, HierarchicalStreamReader reader) {
        DonkeyElement stackTraceElement;
        DonkeyElement causeElement;
        this.throwableXml = preUnmarshalXml;
        while (reader != null && reader.underlyingReader() instanceof DocumentReader && ((DocumentReader)reader.underlyingReader()).getCurrent() instanceof Element && !((DocumentReader)reader.underlyingReader()).getCurrent().equals(element.getElement())) {
            reader.moveUp();
        }
        this.className = element.hasAttribute("class") ? element.getAttribute("class") : element.getTagName();
        DonkeyElement detailMessageElement = element.getChildElement("detailMessage");
        if (detailMessageElement != null) {
            this.detailMessage = detailMessageElement.getTextContent();
        }
        if ((causeElement = element.getChildElement("cause")) != null) {
            try {
                this.initCause(ObjectXMLSerializer.getInstance().deserialize(causeElement.toXml(), Throwable.class));
            }
            catch (DonkeyElement.DonkeyElementException donkeyElementException) {
                // empty catch block
            }
        }
        if ((stackTraceElement = element.getChildElement("stackTrace")) != null) {
            ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>();
            for (DonkeyElement trace : stackTraceElement.getChildElements()) {
                String file;
                Matcher matcher = STACK_TRACE_PATTERN.matcher(trace.getTextContent());
                if (!matcher.find()) continue;
                String declaringClass = "";
                String methodName = "";
                String fileName = null;
                int lineNumber = 0;
                String method = matcher.group("method");
                if (method != null) {
                    int index = method.lastIndexOf(46);
                    if (index >= 0) {
                        declaringClass = method.substring(0, index);
                        methodName = method.substring(index + 1);
                    } else {
                        declaringClass = method;
                    }
                }
                if ((file = matcher.group("file")) != null) {
                    int index = file.lastIndexOf(":");
                    if (index >= 0) {
                        fileName = file.substring(0, index);
                        lineNumber = NumberUtils.toInt((String)file.substring(index + 1));
                    } else {
                        fileName = file;
                    }
                }
                stackTrace.add(new StackTraceElement(declaringClass, methodName, fileName, lineNumber));
            }
            this.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
        }
    }

    public String getThrowableXml() {
        return this.throwableXml;
    }

    @Override
    public String getMessage() {
        return this.detailMessage;
    }

    @Override
    public String toString() {
        String message = this.getLocalizedMessage();
        return message != null ? this.className + ": " + message : this.className;
    }
}

