/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.codetemplates;

import com.mirth.connect.model.CalendarToStringStyle;
import com.mirth.connect.model.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CodeTemplateFunctionDefinition
implements Serializable {
    private String name;
    private List<Parameter> parameters;
    private String returnType;
    private String returnDescription;

    public CodeTemplateFunctionDefinition() {
        this(null);
    }

    public CodeTemplateFunctionDefinition(String name) {
        this(name, null);
    }

    public CodeTemplateFunctionDefinition(String name, List<Parameter> parameters) {
        this(name, parameters, null, null);
    }

    public CodeTemplateFunctionDefinition(String name, List<Parameter> parameters, String returnType, String returnDescription) {
        this.name = name;
        this.setParameters(parameters);
        this.returnType = returnType;
        this.returnDescription = returnDescription;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters != null ? new ArrayList<Parameter>(parameters) : new ArrayList();
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String getReturnDescription() {
        return this.returnDescription;
    }

    public void setReturnDescription(String returnDescription) {
        this.returnDescription = returnDescription;
    }

    public String getTransferData() {
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            StringBuilder builder = new StringBuilder(this.name).append('(');
            if (CollectionUtils.isNotEmpty(this.parameters)) {
                Iterator<Parameter> it = this.parameters.iterator();
                while (it.hasNext()) {
                    builder.append(it.next().getName());
                    if (!it.hasNext()) continue;
                    builder.append(", ");
                }
            }
            return builder.append(')').toString();
        }
        return "Bad Function Definition!";
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)CalendarToStringStyle.instance());
    }
}

