/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.filter;

import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelStatus;
import com.mirth.connect.model.DashboardStatus;
import java.util.Iterator;
import java.util.List;

public abstract class SearchFilter {
    public void filterChannelIds(Iterable<String> channelIds) {
        Iterator<String> it = channelIds.iterator();
        while (it.hasNext()) {
            if (this.acceptChannelId(it.next())) continue;
            it.remove();
        }
    }

    public void filterChannelNames(Iterable<String> channelNames) {
        Iterator<String> it = channelNames.iterator();
        while (it.hasNext()) {
            if (this.acceptChannelName(it.next())) continue;
            it.remove();
        }
    }

    public void filterChannels(Iterable<Channel> channels) {
        Iterator<Channel> it = channels.iterator();
        while (it.hasNext()) {
            if (this.acceptChannel(it.next())) continue;
            it.remove();
        }
    }

    public void filterDashboardStatuses(Iterable<DashboardStatus> statuses) {
        Iterator<DashboardStatus> it = statuses.iterator();
        while (it.hasNext()) {
            if (this.acceptDashboardStatus(it.next())) continue;
            it.remove();
        }
    }

    public void filterChannelStatuses(Iterable<ChannelStatus> statuses) {
        Iterator<ChannelStatus> it = statuses.iterator();
        while (it.hasNext()) {
            if (this.acceptChannelStatus(it.next())) continue;
            it.remove();
        }
    }

    public abstract List<String> getValues();

    public abstract boolean acceptChannelId(String var1);

    public abstract boolean acceptChannelName(String var1);

    public abstract boolean acceptChannel(Channel var1);

    public abstract boolean acceptDashboardStatus(DashboardStatus var1);

    public abstract boolean acceptChannelStatus(ChannelStatus var1);

    public abstract String toDisplayString();
}

