/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server;

import com.google.inject.Inject;
import com.mirth.connect.donkey.server.DonkeyConfiguration;
import com.mirth.connect.donkey.server.DonkeyConnectionPools;
import com.mirth.connect.donkey.server.Encryptor;
import com.mirth.connect.donkey.server.StartException;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.donkey.server.controllers.ChannelController;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.data.DonkeyDaoFactory;
import com.mirth.connect.donkey.server.data.DonkeyStatisticsUpdater;
import com.mirth.connect.donkey.server.data.jdbc.JdbcDaoFactory;
import com.mirth.connect.donkey.server.data.jdbc.XmlQuerySource;
import com.mirth.connect.donkey.server.event.EventDispatcher;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.donkey.util.SerializerProvider;
import com.mirth.connect.donkey.util.xstream.XStreamSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Donkey {
    @Inject
    private static Donkey instance;
    private Map<String, Channel> deployedChannels = new ConcurrentHashMap<String, Channel>();
    private DonkeyConfiguration donkeyConfiguration;
    private DonkeyDaoFactory daoFactory;
    private DonkeyDaoFactory readOnlyDaoFactory;
    private Serializer serializer = new XStreamSerializer();
    private Encryptor encryptor;
    private EventDispatcher eventDispatcher;
    private DonkeyStatisticsUpdater statisticsUpdater;
    private Logger logger = LogManager.getLogger(this.getClass());
    private boolean running = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Donkey getInstance() {
        Class<Donkey> clazz = Donkey.class;
        synchronized (Donkey.class) {
            if (instance == null) {
                instance = new Donkey();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEngine(DonkeyConfiguration donkeyConfiguration) throws StartException {
        this.donkeyConfiguration = donkeyConfiguration;
        Properties dbProperties = donkeyConfiguration.getDonkeyProperties();
        String database = dbProperties.getProperty("database");
        SerializerProvider serializerProvider = new SerializerProvider(){

            @Override
            public Serializer getSerializer(Integer metaDataId) {
                return Donkey.this.serializer;
            }
        };
        XmlQuerySource xmlQuerySource = new XmlQuerySource();
        try {
            xmlQuerySource.load("default.xml");
            xmlQuerySource.load(dbProperties.getProperty("database") + ".xml");
        }
        catch (XmlQuerySource.XmlQuerySourceException e) {
            throw new StartException(e);
        }
        this.daoFactory = this.createDaoFactory(database, serializerProvider, xmlQuerySource, false);
        boolean splitReadWrite = Boolean.parseBoolean(dbProperties.getProperty("database.enable-read-write-split"));
        if (splitReadWrite) {
            String readOnlyDatabase = dbProperties.getProperty("database-readonly", database);
            this.readOnlyDaoFactory = this.createDaoFactory(readOnlyDatabase, serializerProvider, xmlQuerySource, true);
        } else {
            this.readOnlyDaoFactory = this.daoFactory;
        }
        try (DonkeyDao dao = null;){
            dao = this.daoFactory.getDao();
            if (dao.initTableStructure()) {
                dao.commit();
            }
            dao.checkAndCreateChannelTables();
            dao.commit();
        }
        ChannelController.getInstance().loadStatistics(donkeyConfiguration.getServerId());
        this.encryptor = donkeyConfiguration.getEncryptor();
        this.eventDispatcher = donkeyConfiguration.getEventDispatcher();
        int updateInterval = NumberUtils.toInt((String)donkeyConfiguration.getDonkeyProperties().getProperty("donkey.statsupdateinterval"), (int)1000);
        this.statisticsUpdater = new DonkeyStatisticsUpdater(this.daoFactory, updateInterval);
        this.statisticsUpdater.start();
        this.running = true;
    }

    private JdbcDaoFactory createDaoFactory(String database, SerializerProvider serializerProvider, XmlQuerySource xmlQuerySource, boolean readOnly) throws StartException {
        JdbcDaoFactory jdbcDaoFactory = JdbcDaoFactory.getInstance(database);
        jdbcDaoFactory.setStatsServerId(this.donkeyConfiguration.getServerId());
        if (readOnly) {
            jdbcDaoFactory.setConnectionPool(DonkeyConnectionPools.getInstance().getReadOnlyConnectionPool());
        } else {
            jdbcDaoFactory.setConnectionPool(DonkeyConnectionPools.getInstance().getConnectionPool());
        }
        jdbcDaoFactory.setSerializerProvider(serializerProvider);
        jdbcDaoFactory.setQuerySource(xmlQuerySource);
        return jdbcDaoFactory;
    }

    public DonkeyDaoFactory getDaoFactory() {
        return this.daoFactory;
    }

    public void setDaoFactory(DonkeyDaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    public DonkeyDaoFactory getReadOnlyDaoFactory() {
        return this.readOnlyDaoFactory;
    }

    public void setReadOnlyDaoFactory(DonkeyDaoFactory readOnlyDaoFactory) {
        this.readOnlyDaoFactory = readOnlyDaoFactory;
    }

    public DonkeyStatisticsUpdater getStatisticsUpdater() {
        return this.statisticsUpdater;
    }

    public void stopEngine() {
        if (this.statisticsUpdater != null) {
            this.statisticsUpdater.shutdown();
        }
        this.running = false;
    }

    public Map<String, Channel> getDeployedChannels() {
        return this.deployedChannels;
    }

    public Set<String> getDeployedChannelIds() {
        ArrayList<Channel> channels = new ArrayList<Channel>(this.deployedChannels.values());
        Collections.sort(channels, new Comparator<Channel>(){

            @Override
            public int compare(Channel o1, Channel o2) {
                return o1.getDeployDate().compareTo(o2.getDeployDate());
            }
        });
        LinkedHashSet<String> channelIds = new LinkedHashSet<String>();
        for (Channel channel : channels) {
            channelIds.add(channel.getChannelId());
        }
        return channelIds;
    }

    public boolean isRunning() {
        return this.running;
    }

    public DonkeyConfiguration getConfiguration() {
        return this.donkeyConfiguration;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }
}

